/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.enums.addon;

import com.sun.codemodel.JDefinedClass;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.CodeAugmenter;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.generator.ClassContext;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.TypeItem;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.jaxbcommons.addon.generator.MethodStrategy;
import org.jvnet.jaxbcommons.enums.addon.generator.CodesStrategy;
import org.jvnet.jaxbcommons.enums.addon.generator.GetEnumCodeMapStrategy;
import org.jvnet.jaxbcommons.enums.addon.generator.GetEnumMapStrategy;
import org.jvnet.jaxbcommons.enums.addon.generator.ValuesStrategy;
import org.jvnet.jaxbcommons.util.TypeUtils;
import org.jvnet.jaxbcommons.visitor.ClassifyingVisitor;
import org.xml.sax.ErrorHandler;

public class AddOn
implements CodeAugmenter {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected MethodStrategy valuesStrategy = new ValuesStrategy();
    protected MethodStrategy codesStrategy = new CodesStrategy();
    protected MethodStrategy getEnumMapStrategy = new GetEnumMapStrategy();
    protected MethodStrategy getEnumCodeMapStrategy = new GetEnumCodeMapStrategy();

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        return 0;
    }

    public String getOptionName() {
        return "Xenums";
    }

    public String getUsage() {
        return "  -Xenums                      :  adds values() and getEnumMap() methods to the generated enum classes";
    }

    public boolean run(AnnotatedGrammar grammar, GeneratorContext generatorContext, Options options, ErrorHandler errorHandler) {
        ClassItem[] classItems = grammar.getClasses();
        for (int index = 0; index < classItems.length; ++index) {
            ClassItem classItem = classItems[index];
            ClassContext classContext = generatorContext.getClassContext(classItem);
            classItem.visit((ExpressionVisitor)new ClassifyingVisitor(classContext){

                public Object onEnumCollectionField(FieldItem fieldItem) {
                    AddOn.this.onEnumField(this.classContext, fieldItem);
                    return null;
                }

                public Object onEnumSingleField(FieldItem fieldItem) {
                    AddOn.this.onEnumField(this.classContext, fieldItem);
                    return null;
                }
            });
        }
        return true;
    }

    public MethodStrategy getValuesStrategy() {
        return this.valuesStrategy;
    }

    public void setValuesStrategy(MethodStrategy valuesStrategy) {
        this.valuesStrategy = valuesStrategy;
    }

    public MethodStrategy getCodesStrategy() {
        return this.codesStrategy;
    }

    public void setCodesStrategy(MethodStrategy codesStrategy) {
        this.codesStrategy = codesStrategy;
    }

    public MethodStrategy getGetEnumMapStrategy() {
        return this.getEnumMapStrategy;
    }

    public void setGetEnumMapStrategy(MethodStrategy getEnumMapStrategy) {
        this.getEnumMapStrategy = getEnumMapStrategy;
    }

    public MethodStrategy getGetEnumCodeMapStrategy() {
        return this.getEnumCodeMapStrategy;
    }

    public void setGetEnumCodeMapStrategy(MethodStrategy getEnumCodeMapStrategy) {
        this.getEnumCodeMapStrategy = getEnumCodeMapStrategy;
    }

    protected void onEnumField(ClassContext classContext, FieldItem fieldItem) {
        TypeItem typeItem = TypeUtils.getCommonBaseTypeItem(classContext, fieldItem);
        JDefinedClass theClass = TypeUtils.getEnumClass(typeItem);
        this.logger.debug((Object)("Augmenting enum class [" + theClass.fullName() + "]."));
        this.getValuesStrategy().generate(classContext, fieldItem, theClass);
        this.getCodesStrategy().generate(classContext, fieldItem, theClass);
        this.getGetEnumMapStrategy().generate(classContext, fieldItem, theClass);
        this.getGetEnumCodeMapStrategy().generate(classContext, fieldItem, theClass);
    }
}

