/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.extendedi18n.addon;

import com.sun.codemodel.JDefinedClass;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.ValueExp;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.generator.ClassContext;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.generator.PackageContext;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.FieldUse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.jaxbcommons.addon.AbstractParameterizableCodeAugmenter;
import org.jvnet.jaxbcommons.enums.addon.util.EnumUtils;
import org.jvnet.jaxbcommons.i18n.addon.util.PropertyUtils;
import org.jvnet.jaxbcommons.util.ClassUtils;
import org.jvnet.jaxbcommons.util.FieldUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class AddOn
extends AbstractParameterizableCodeAugmenter {
    protected Log logger = LogFactory.getLog(this.getClass());
    public static final String OPTION_NAME = "XextendedI18n";
    private List locales = new ArrayList(3);
    private File importDirectory;
    private String importName = "messages";
    private File exportDirectory;
    private String exportName = "messages";
    private Map importedProperties = Collections.EMPTY_MAP;
    private Map properties = new HashMap();

    public void setLocale(String locale) {
        this.locales.add(this.parseLocale(locale));
    }

    public Locale[] getLocales() {
        return this.locales.toArray(new Locale[this.locales.size()]);
    }

    public void setImportDirectory(File importDirectory) {
        this.importDirectory = importDirectory;
    }

    public void setImportName(String importName) {
        this.importName = importName;
    }

    public void setExportDirectory(File exportDirectory) {
        this.exportDirectory = exportDirectory;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "";
    }

    private Locale parseLocale(String string) {
        StringTokenizer tokens = new StringTokenizer(string, "_");
        String language = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        String country = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        String variant = "";
        String sep = "";
        while (tokens.hasMoreTokens()) {
            variant = variant + sep + tokens.nextToken();
            sep = "_";
        }
        return new Locale(language, country, variant);
    }

    public boolean run(AnnotatedGrammar grammar, GeneratorContext context, Options options, ErrorHandler errorHandler) {
        if (this.importDirectory == null) {
            this.logger.debug((Object)"Import directory is not specified, trying to guess it.");
            InputSource[] grammars = options.getGrammars();
            for (int index = 0; index < grammars.length; ++index) {
                InputSource source = grammars[index];
                try {
                    String systemId = source.getSystemId();
                    this.logger.debug((Object)("Trying out [" + systemId + "]."));
                    URI uri = new URI(systemId);
                    File file = new File(uri);
                    this.importDirectory = file.getParentFile();
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (this.importDirectory == null) {
            this.logger.warn((Object)"Could not find out the import directory.");
        }
        if (this.exportDirectory == null) {
            this.logger.info((Object)"Export directory is not specified. Using XJC target directory.");
            this.exportDirectory = options.targetDir;
        }
        this.importProperties(context);
        this.processProperties(context);
        this.writeProperties(context);
        return true;
    }

    public void addClassEntry(ClassContext classContext) {
        PackageContext packageContext = classContext._package;
        Locale[] locales = this.getLocales();
        for (int index = 0; index < locales.length; ++index) {
            Locale locale = locales[index];
            String property = this.getImportedClassProperty(classContext, locale);
            String key = this.getClassKey(classContext);
            this.getProperties(packageContext, locale).put(key, property != null ? property : "@@TODO." + classContext.target.name + "@@");
        }
    }

    public void addFieldEntry(ClassContext classContext, FieldItem fieldItem) {
        PackageContext packageContext = classContext._package;
        Locale[] locales = this.getLocales();
        for (int index = 0; index < locales.length; ++index) {
            Locale locale = locales[index];
            String property = this.getImportedFieldProperty(classContext, fieldItem, locale);
            String key = this.getFieldKey(classContext, fieldItem);
            this.getProperties(packageContext, locale).put(key, property != null ? property : "@@TODO." + fieldItem.name + "@@");
        }
    }

    public void addEnumEntry(ClassContext classContext, FieldItem fieldItem) {
        FieldUse fieldUse = FieldUtils.getFieldUse(classContext, fieldItem);
        JDefinedClass enumClass = (JDefinedClass)fieldUse.type;
        PackageContext packageContext = classContext.parent.getPackageContext(enumClass._package());
        Collection enumValues = EnumUtils.getValues(classContext, fieldItem);
        if (enumValues != null) {
            Iterator iterator = enumValues.iterator();
            while (iterator.hasNext()) {
                ValueExp enumValue = (ValueExp)iterator.next();
                String lexical = enumValue.dt instanceof XSDatatype ? ((XSDatatype)enumValue.dt).convertToLexicalValue(enumValue.value, null) : enumValue.value.toString();
                Locale[] locales = this.getLocales();
                String key = this.getEnumKey(enumClass, lexical);
                for (int index = 0; index < locales.length; ++index) {
                    Locale locale = locales[index];
                    String property = this.getImportedProperty(packageContext, locale, key);
                    this.getProperties(packageContext, locale).put(key, property != null ? property : "@@TODO." + lexical + "@@");
                }
            }
        }
    }

    private String getEnumKey(JDefinedClass enumClass, String lexical) {
        return enumClass.fullName() + "." + lexical;
    }

    public String getClassKey(ClassContext classContext) {
        return ClassUtils.getFQCN(classContext, false);
    }

    public String getFieldKey(ClassContext classContext, FieldItem fieldItem) {
        return FieldUtils.getFQFN(classContext, fieldItem, false);
    }

    private String getImportedClassProperty(ClassContext classContext, Locale locale) {
        PackageContext packageContext = classContext._package;
        String key = this.getClassKey(classContext);
        String property = this.getImportedProperty(packageContext, locale, key);
        return property;
    }

    private String getImportedFieldProperty(ClassContext classContext, FieldItem fieldItem, Locale locale) {
        PackageContext packageContext = classContext._package;
        String key = this.getFieldKey(classContext, fieldItem);
        String property = this.getImportedProperty(packageContext, locale, key);
        if (property != null) {
            return property;
        }
        ClassItem classItem = classContext.target;
        if (classItem.getSuperClass() == null) {
            return null;
        }
        ClassContext superClassContext = classContext.parent.getClassContext(classItem.getSuperClass());
        String superProperty = this.getImportedFieldProperty(superClassContext, fieldItem, locale);
        return superProperty;
    }

    public String getImportedProperty(PackageContext packageContext, Locale locale, String key) {
        Map localeProperties = (Map)this.importedProperties.get(locale);
        if (localeProperties == null) {
            return null;
        }
        return (String)localeProperties.get(key);
    }

    public void importProperties(GeneratorContext generatorContext) {
        Locale[] locales = this.getLocales();
        this.importedProperties = new HashMap(locales.length);
        for (int index = 0; index < locales.length; ++index) {
            Locale locale = locales[index];
            HashMap localeProperties = new HashMap();
            this.importedProperties.put(locale, localeProperties);
            PackageContext[] packageContexts = this.getPackageContexts(generatorContext);
            for (int jndex = 0; jndex < packageContexts.length; ++jndex) {
                PackageContext packageContext = packageContexts[jndex];
                Map properties = this.importProperties(packageContext, locale);
                localeProperties.putAll(properties);
            }
        }
    }

    public Map importProperties(PackageContext packageContext, Locale locale) {
        if (this.importDirectory != null) {
            String fileName;
            String draftPackageName = packageContext._package.name();
            String packageName = draftPackageName == null ? "" : draftPackageName;
            String packageDirectoryName = packageName.replace('.', File.separatorChar);
            File packageDirectory = new File(this.importDirectory, packageDirectoryName);
            File file = new File(packageDirectory, fileName = this.importName + "_" + locale.toString() + ".properties");
            if (file.isFile()) {
                this.logger.info((Object)MessageFormat.format("Loading properties from [{0}].", file.getAbsolutePath()));
                try {
                    Map properties = PropertyUtils.load(new FileInputStream(file));
                    return properties;
                }
                catch (IOException ioex) {
                    this.logger.error((Object)"Error loading properties.", (Throwable)ioex);
                    return Collections.EMPTY_MAP;
                }
            }
            this.logger.warn((Object)MessageFormat.format("[{0}] is not a file. Ignoring.", file.getAbsolutePath()));
            return Collections.EMPTY_MAP;
        }
        return Collections.EMPTY_MAP;
    }

    protected void processProperties(GeneratorContext context) {
        ClassItem[] classes = context.getGrammar().getClasses();
        for (int index = 0; index < classes.length; ++index) {
            ClassItem classItem = classes[index];
            ClassContext classContext = context.getClassContext(classItem);
            this.processProperties(classContext);
        }
    }

    protected void processProperties(ClassContext classContext) {
        this.addClassEntry(classContext);
        FieldUse[] allFieldUses = FieldUtils.getAllFieldUses(classContext);
        for (int index = 0; index < allFieldUses.length; ++index) {
            FieldUse fieldUse = allFieldUses[index];
            FieldItem fieldItem = FieldUtils.getFieldItem(fieldUse);
            this.processProperties(classContext, fieldItem);
        }
    }

    protected void processProperties(ClassContext classContext, FieldItem fieldItem) {
        this.addFieldEntry(classContext, fieldItem);
        if (FieldUtils.isEnumField(classContext, fieldItem)) {
            this.addEnumEntry(classContext, fieldItem);
        }
    }

    public void writeProperties(GeneratorContext context) {
        PackageContext[] packageContexts = this.getPackageContexts(context);
        for (int index = 0; index < packageContexts.length; ++index) {
            PackageContext packageContext = packageContexts[index];
            this.writeProperties(packageContext);
        }
    }

    public void writeProperties(PackageContext packageContext) {
        Locale[] locales = this.getLocales();
        for (int index = 0; index < locales.length; ++index) {
            Locale locale = locales[index];
            this.writeProperties(packageContext, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProperties(PackageContext packageContext, Locale locale) {
        this.logger.info((Object)("Generating properties for package [" + packageContext._package.name() + "] and locale [" + locale.toString() + "]."));
        Map properties = this.getProperties(packageContext, locale);
        String draftPackageName = packageContext._package.name();
        String packageName = draftPackageName == null ? "" : draftPackageName;
        String packageDirectoryName = packageName.replace('.', File.separatorChar);
        File packageDirectory = new File(this.exportDirectory, packageDirectoryName);
        packageDirectory.mkdirs();
        String fileName = this.exportName + "_" + locale.toString() + ".properties";
        File file = new File(packageDirectory, fileName);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            PropertyUtils.store(properties, os, null);
        }
        catch (IOException ex) {
            this.logger.error((Object)MessageFormat.format("Error saving properties to [{0}].", file.getAbsolutePath()), (Throwable)ex);
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public Map getProperties(PackageContext packageContext, Locale locale) {
        TreeMap packageLocaleProperties;
        IdentityHashMap localeProperties;
        IdentityHashMap draftLocaleProperties = (IdentityHashMap)this.properties.get(locale);
        if (draftLocaleProperties != null) {
            localeProperties = draftLocaleProperties;
        } else {
            localeProperties = new IdentityHashMap();
            this.properties.put(locale, localeProperties);
        }
        TreeMap draftPackageLocaleProperties = (TreeMap)localeProperties.get(packageContext);
        if (draftPackageLocaleProperties != null) {
            packageLocaleProperties = draftPackageLocaleProperties;
        } else {
            packageLocaleProperties = new TreeMap();
            localeProperties.put(packageContext, packageLocaleProperties);
        }
        return packageLocaleProperties;
    }

    public PackageContext[] getPackageContexts(GeneratorContext generatorContext) {
        return generatorContext.getAllPackageContexts();
    }
}

