/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.i18n.addon;

import com.sun.codemodel.JDefinedClass;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.ValueExp;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.generator.ClassContext;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.FieldUse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.jaxbcommons.addon.AbstractParameterizableCodeAugmenter;
import org.jvnet.jaxbcommons.enums.addon.util.EnumUtils;
import org.jvnet.jaxbcommons.i18n.addon.util.PropertyUtils;
import org.jvnet.jaxbcommons.util.FieldUtils;
import org.xml.sax.ErrorHandler;

public class AddOn
extends AbstractParameterizableCodeAugmenter {
    protected Log logger = LogFactory.getLog(this.getClass());
    public static final String OPTION_NAME = "Xi18n";
    private Map importedProperties = new HashMap();
    private Map lowercaseImportedProperties = new HashMap();
    private Map exportedProperties = new HashMap();
    private Map lowercaseExportedProperties = new HashMap();
    private List locales = new ArrayList(3);
    private File importDirectory;
    private String importName = "messages";
    private File exportDirectory;
    private String exportName = "messages";

    public void setLocale(String locale) {
        this.locales.add(this.parseLocale(locale));
    }

    public void setImportDirectory(File importDirectory) {
        this.importDirectory = importDirectory;
    }

    public void setImportName(String importName) {
        this.importName = importName;
    }

    public void setExportDirectory(File exportDirectory) {
        this.exportDirectory = exportDirectory;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "";
    }

    private Locale parseLocale(String string) {
        StringTokenizer tokens = new StringTokenizer(string, "_");
        String language = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        String country = tokens.hasMoreTokens() ? tokens.nextToken() : "";
        String variant = "";
        String sep = "";
        while (tokens.hasMoreTokens()) {
            variant = variant + sep + tokens.nextToken();
            sep = "_";
        }
        return new Locale(language, country, variant);
    }

    public boolean run(AnnotatedGrammar grammar, GeneratorContext context, Options options, ErrorHandler errorHandler) {
        this.loadProperties();
        this.processProperties(grammar, context);
        this.processLowercaseProperties();
        this.saveProperties(options);
        return true;
    }

    protected void saveProperties(Options options) {
        Iterator iterator = this.locales.iterator();
        while (iterator.hasNext()) {
            Locale locale = (Locale)iterator.next();
            String l = locale.toString();
            Map exp = (Map)this.exportedProperties.get(l);
            File exportDirectory = this.exportDirectory == null ? options.targetDir : this.exportDirectory;
            if (exportDirectory == null || this.exportName == null) continue;
            if (!exportDirectory.exists()) {
                this.logger.info((Object)MessageFormat.format("Export directory [{0}] does not exist. Creating.", exportDirectory.getAbsolutePath()));
                exportDirectory.mkdirs();
            }
            if (exportDirectory.isDirectory()) {
                String name = this.exportName + "_" + l + ".properties";
                File file = new File(exportDirectory, name);
                try {
                    PropertyUtils.store(exp, new FileOutputStream(file), null);
                }
                catch (IOException ioex) {
                    this.logger.error((Object)"Error storing properties.", (Throwable)ioex);
                }
                continue;
            }
            this.logger.error((Object)MessageFormat.format("Export directory [{0}] is not a directory. Unable to export", exportDirectory.getAbsolutePath()));
        }
    }

    protected void processLowercaseProperties() {
        Iterator iterator = this.locales.iterator();
        while (iterator.hasNext()) {
            Locale locale = (Locale)iterator.next();
            String l = locale.toString();
            Map imp = (Map)this.importedProperties.get(l);
            Map exp = (Map)this.exportedProperties.get(l);
            Map lexp = (Map)this.lowercaseExportedProperties.get(l);
            Iterator names = imp.keySet().iterator();
            while (names.hasNext()) {
                String key = (String)names.next();
                if (lexp.containsKey(key.toLowerCase(locale))) continue;
                String value = (String)imp.get(key);
                this.logger.debug((Object)MessageFormat.format("{0}={1}[{2}]", key, value, l));
                exp.put(key, value);
                lexp.put(key.toLowerCase(locale), value);
            }
        }
    }

    protected void processProperties(AnnotatedGrammar grammar, GeneratorContext context) {
        ClassItem[] classes = grammar.getClasses();
        for (int index = 0; index < classes.length; ++index) {
            ClassItem classItem = classes[index];
            ClassContext classContext = context.getClassContext(classItem);
            this.setProperty(classItem.getTypeAsDefined().fullName(), "@@TODO." + classItem.getTypeAsDefined().name() + "@@");
            FieldUse[] fields = classItem.getDeclaredFieldUses();
            for (int jndex = 0; jndex < fields.length; ++jndex) {
                FieldUse fieldUse = fields[jndex];
                this.setProperty(fieldUse.owner.getType().fullName() + "." + fieldUse.name, "@@TODO." + fieldUse.name + "@@");
                if (!(fieldUse.type instanceof JDefinedClass) || null != grammar.getClassItem((JDefinedClass)fieldUse.type)) continue;
                JDefinedClass enumClass = (JDefinedClass)fieldUse.type;
                FieldItem fieldItem = FieldUtils.getFieldItem(fieldUse);
                Collection enumValues = EnumUtils.getValues(classContext, fieldItem);
                if (enumValues == null) continue;
                Iterator iterator = enumValues.iterator();
                while (iterator.hasNext()) {
                    ValueExp enumValue = (ValueExp)iterator.next();
                    String lexical = enumValue.dt instanceof XSDatatype ? ((XSDatatype)enumValue.dt).convertToLexicalValue(enumValue.value, null) : enumValue.value.toString();
                    this.setProperty(enumClass.fullName() + "." + lexical, "@@TODO." + lexical + "@@");
                }
            }
        }
    }

    protected void loadProperties() {
        Iterator iterator = this.locales.iterator();
        while (iterator.hasNext()) {
            Locale locale = (Locale)iterator.next();
            this.loadProperties(locale);
        }
    }

    protected void loadProperties(Locale locale) {
        String l = locale.toString();
        if (this.importDirectory != null && this.importName != null) {
            String name = this.importName + "_" + l + ".properties";
            File file = new File(this.importDirectory, name);
            if (file.isFile()) {
                this.logger.info((Object)MessageFormat.format("Loading properties from [{0}].", file.getAbsolutePath()));
                try {
                    Map properties = PropertyUtils.load(new FileInputStream(file));
                    Map lowercaseProperties = PropertyUtils.toLowerCase(properties, locale);
                    this.importedProperties.put(l, properties);
                    this.lowercaseImportedProperties.put(l, lowercaseProperties);
                }
                catch (IOException ioex) {
                    this.logger.error((Object)"Error loading properties.", (Throwable)ioex);
                    this.importedProperties.put(l, new TreeMap());
                    this.lowercaseImportedProperties.put(l, new TreeMap());
                }
            } else {
                this.logger.warn((Object)MessageFormat.format("[{0}] is not a file. Ignoring.", file.getAbsolutePath()));
                this.importedProperties.put(l, new TreeMap());
                this.lowercaseImportedProperties.put(l, new TreeMap());
            }
        }
        this.exportedProperties.put(l, new TreeMap());
        this.lowercaseExportedProperties.put(l, new TreeMap());
    }

    protected void setProperty(String name, String value) {
        Iterator iterator = this.locales.iterator();
        while (iterator.hasNext()) {
            Locale locale = (Locale)iterator.next();
            this.setProperty(name, value, locale);
        }
    }

    protected void setProperty(String name, String draft, Locale locale) {
        String l = locale.toString();
        Map imp = (Map)this.lowercaseImportedProperties.get(l);
        Map exp = (Map)this.exportedProperties.get(l);
        Map lexp = (Map)this.lowercaseExportedProperties.get(l);
        String key = name.toLowerCase(locale);
        String value = imp.containsKey(key) ? (String)imp.get(key) : draft;
        this.logger.debug((Object)MessageFormat.format("{0}={1}[{2}]", name, value, l));
        exp.put(name, value);
        lexp.put(name.toLowerCase(), value);
    }
}

