/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.util;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.generator.ClassContext;
import com.sun.tools.xjc.grammar.FieldItem;
import org.jvnet.jaxbcommons.util.CodeModelUtils;

public class AccessorUtils {
    private AccessorUtils() {
    }

    public static JMethod get(ClassContext classContext, FieldItem fieldItem) {
        JCodeModel codeModel = classContext.ref.owner();
        JType type = fieldItem.getType(codeModel);
        String getterName = (codeModel.BOOLEAN.equals(type) ? "is" : "get") + fieldItem.name;
        return CodeModelUtils.getMethod(classContext, getterName);
    }

    public static JMethod set(ClassContext classContext, FieldItem fieldItem) {
        String setterName = "set" + fieldItem.name;
        return CodeModelUtils.getMethod(classContext, setterName);
    }

    public static JMethod unset(ClassContext classContext, FieldItem fieldItem) {
        String unsetterName = "unset" + fieldItem.name;
        JMethod method = CodeModelUtils.getMethod(classContext, unsetterName);
        if (method == null) {
            throw new AssertionError((Object)("No unsetter [" + unsetterName + "] found."));
        }
        return method;
    }

    public static JMethod isSet(ClassContext classContext, FieldItem fieldItem) {
        String isSetterName = "isSet" + fieldItem.name;
        return CodeModelUtils.getMethod(classContext, isSetterName);
    }
}

