/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.generator.ClassContext;
import com.sun.tools.xjc.grammar.ClassItem;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jvnet.jaxbcommons.util.CodeModelUtils;

public class ClassUtils {
    public static String getFQCN(ClassContext theClass, boolean dotted) {
        return CodeModelUtils.getFQCN(theClass.ref, dotted);
    }

    public static String getLCN(ClassContext theClass, boolean dotted) {
        return CodeModelUtils.getLCN(theClass.ref, dotted);
    }

    public static String getFQCN(ClassItem theClass, boolean dotted) {
        return CodeModelUtils.getFQCN(theClass.getTypeAsDefined(), dotted);
    }

    public static String getLCN(ClassItem theClass, boolean dotted) {
        return CodeModelUtils.getLCN(theClass.getTypeAsDefined(), dotted);
    }

    public static String getClassName(ClassContext classContext) {
        return ClassUtils.getClassName(classContext.target);
    }

    public static String getPackagedClassName(ClassContext classContext) {
        return CodeModelUtils.getPackagedClassName(classContext.target.getTypeAsDefined());
    }

    public static String getClassName(ClassItem classItem) {
        return CodeModelUtils.getClassName(classItem.getTypeAsDefined());
    }

    public static void _implements(JDefinedClass theClass, JClass theInterface) {
        if (!ClassUtils.isImplementing(theClass, theInterface)) {
            theClass._implements(theInterface);
        }
    }

    public static boolean isImplementing(JDefinedClass theClass, JClass theInterface) {
        Iterator iterator = theClass._implements();
        while (iterator.hasNext()) {
            JClass implementedInterface = (JClass)iterator.next();
            if (!theInterface.equals(implementedInterface)) continue;
            return true;
        }
        return false;
    }

    public static List getAncestors(ClassContext classContext) {
        ClassItem classItem = classContext.target;
        if (classItem.getSuperClass() == null) {
            return Collections.EMPTY_LIST;
        }
        ClassItem superClassItem = classItem.getSuperClass();
        ClassContext superClassContext = classContext.parent.getClassContext(superClassItem);
        return ClassUtils.getAncestorsAndSelf(superClassContext);
    }

    public static List getAncestorsAndSelf(ClassContext classContext) {
        ClassItem classItem = classContext.target;
        if (classItem.getSuperClass() == null) {
            return Collections.singletonList(classContext);
        }
        LinkedList<ClassContext> superClassContexts = new LinkedList<ClassContext>();
        superClassContexts.add(classContext);
        ClassItem superClassItem = classItem.getSuperClass();
        ClassContext superClassContext = classContext.parent.getClassContext(superClassItem);
        superClassContexts.addAll(ClassUtils.getAncestorsAndSelf(superClassContext));
        return superClassContexts;
    }
}

