/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.util;

import com.sun.tools.xjc.generator.ClassContext;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.FieldUse;
import com.sun.tools.xjc.grammar.JavaItem;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIXPluginCustomization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jvnet.jaxbcommons.util.FieldUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomizationUtils {
    private static final DocumentBuilder DOCUMENT_BUILDER;

    public static Collection getCustomizations(JavaItem item) {
        ArrayList<BIDeclaration> customizations = new ArrayList<BIDeclaration>();
        Iterator iterator = item.declarations.iterator();
        while (iterator.hasNext()) {
            BIDeclaration declaration = (BIDeclaration)iterator.next();
            if (!(declaration instanceof BIXPluginCustomization)) continue;
            customizations.add(declaration);
        }
        return customizations;
    }

    public static BIXPluginCustomization createCustomization(QName name) {
        Document document = DOCUMENT_BUILDER.newDocument();
        Element element = document.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        return CustomizationUtils.createCustomization(element);
    }

    public static BIXPluginCustomization createCustomization(Element element) {
        BIXPluginCustomization customization = new BIXPluginCustomization(element, null);
        return customization;
    }

    public static BIXPluginCustomization getOrCreateCustomization(JavaItem item, QName name) {
        if (CustomizationUtils.containsCustomization(item, name)) {
            return CustomizationUtils.getCustomization(item, name);
        }
        BIXPluginCustomization customization = CustomizationUtils.createCustomization(name);
        item.declarations.add(customization);
        return customization;
    }

    public static BIXPluginCustomization[] getCustomizations(JavaItem item, QName name) {
        Collection customizationsDraft = CustomizationUtils.getCustomizations(item);
        ArrayList<BIXPluginCustomization> customizations = new ArrayList<BIXPluginCustomization>();
        Iterator iterator = customizationsDraft.iterator();
        while (iterator.hasNext()) {
            QName elementName;
            BIXPluginCustomization customization = (BIXPluginCustomization)iterator.next();
            Element element = customization.element;
            if (null == element || !(elementName = new QName(element.getNamespaceURI(), element.getLocalName())).equals(name)) continue;
            customizations.add(customization);
        }
        return customizations.toArray(new BIXPluginCustomization[customizations.size()]);
    }

    public static boolean containsCustomization(JavaItem item, QName name) {
        Iterator iterator = item.declarations.iterator();
        while (iterator.hasNext()) {
            BIXPluginCustomization customization;
            BIDeclaration declaration = (BIDeclaration)iterator.next();
            if (!(declaration instanceof BIXPluginCustomization) || !name.equals((customization = (BIXPluginCustomization)declaration).getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean ancestorOrSelfContainsCustomization(ClassItem item, QName name) {
        return CustomizationUtils.containsCustomization((JavaItem)item, name) || item.getSuperClass() != null && CustomizationUtils.ancestorOrSelfContainsCustomization(item.getSuperClass(), name);
    }

    public static BIXPluginCustomization ancestorOrSelfCustomization(ClassItem item, QName name) {
        if (CustomizationUtils.containsCustomization((JavaItem)item, name)) {
            return CustomizationUtils.getCustomization((JavaItem)item, name);
        }
        if (item.getSuperClass() != null) {
            return CustomizationUtils.ancestorOrSelfCustomization(item.getSuperClass(), name);
        }
        return null;
    }

    public static BIXPluginCustomization getCustomization(JavaItem item, QName name) {
        BIXPluginCustomization[] customizations = CustomizationUtils.getCustomizations(item, name);
        if (customizations == null || customizations.length < 1) {
            return null;
        }
        return customizations[0];
    }

    public static FieldItem getFieldItemWithCustomization(ClassContext classContext, QName name) {
        FieldUse[] fieldUses = classContext.target.getDeclaredFieldUses();
        for (int index = 0; index < fieldUses.length; ++index) {
            FieldUse fieldUse = fieldUses[index];
            FieldItem draftFieldItem = FieldUtils.getFieldItem(fieldUse);
            if (!CustomizationUtils.containsCustomization((JavaItem)draftFieldItem, name)) continue;
            return draftFieldItem;
        }
        return null;
    }

    public static FieldItem getInheritedFieldWithCustomization(ClassContext classContext, QName name) {
        FieldUse[] fieldUses = classContext.target.getDeclaredFieldUses();
        for (int index = 0; index < fieldUses.length; ++index) {
            FieldUse fieldUse = fieldUses[index];
            FieldItem draftFieldItem = FieldUtils.getFieldItem(fieldUse);
            if (!CustomizationUtils.containsCustomization((JavaItem)draftFieldItem, name)) continue;
            return draftFieldItem;
        }
        ClassItem superClassItem = classContext.target.getSuperClass();
        if (superClassItem != null) {
            ClassContext superClassContext = classContext.parent.getClassContext(superClassItem);
            return CustomizationUtils.getInheritedFieldWithCustomization(superClassContext, name);
        }
        return null;
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DOCUMENT_BUILDER = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new ExceptionInInitializerError(pce);
        }
    }
}

