/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.util;

import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JType;
import com.sun.msv.datatype.xsd.IDREFType;
import com.sun.msv.grammar.DataOrValueExp;
import com.sun.msv.util.StringPair;
import com.sun.tools.xjc.generator.ClassContext;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.TypeItem;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.commons.lang.ObjectUtils;
import org.jvnet.jaxbcommons.util.CodeModelUtils;

public class TypeUtils {
    private static final Comparator TYPE_ITEM_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            TypeItem t1 = (TypeItem)o1;
            TypeItem t2 = (TypeItem)o2;
            return t1.getType().fullName().compareTo(t2.getType().fullName());
        }
    };

    public static Set getAssignableTypeItems(TypeItem t) {
        TreeSet s = new TreeSet(TYPE_ITEM_COMPARATOR);
        TypeUtils.addAssignableTypeItems(t, s);
        return s;
    }

    private static void addAssignableTypeItems(TypeItem t, Set s) {
        ClassItem c;
        ClassItem sc;
        if (!s.add(t)) {
            return;
        }
        if (t instanceof ClassItem && (sc = (c = (ClassItem)t).getSuperClass()) != null) {
            TypeUtils.addAssignableTypeItems((TypeItem)sc, s);
        }
    }

    public static TypeItem getCommonBaseTypeItem(ClassContext classContext, FieldItem fieldItem) {
        TypeItem[] t = fieldItem.listTypes();
        TreeSet<Object> uniqueTypes = new TreeSet<Object>(TYPE_ITEM_COMPARATOR);
        for (int i = 0; i < t.length; ++i) {
            if (t[i] instanceof PrimitiveItem && ((PrimitiveItem)t[i]).guard == IDREFType.theInstance && t[i].getType() instanceof JDefinedClass) {
                ClassItem classItem = classContext.parent.getGrammar().getClassItem((JDefinedClass)t[i].getType());
                if (classItem != null) {
                    uniqueTypes.add(classItem);
                    continue;
                }
                uniqueTypes.add(t[i]);
                continue;
            }
            uniqueTypes.add(t[i]);
        }
        if (uniqueTypes.isEmpty()) {
            return null;
        }
        TypeItem firstType = (TypeItem)uniqueTypes.iterator().next();
        if (uniqueTypes.size() == 1) {
            return firstType;
        }
        Set s = TypeUtils.getAssignableTypeItems(firstType);
        Iterator itr = uniqueTypes.iterator();
        while (itr.hasNext()) {
            TypeItem type = (TypeItem)itr.next();
            if (type.getType() == type.getType().owner().NULL) continue;
            s.retainAll(TypeUtils.getAssignableTypeItems(type));
        }
        if (s.isEmpty()) {
            return null;
        }
        TypeItem[] raw = s.toArray(new TypeItem[s.size()]);
        s.clear();
        for (int i = 0; i < raw.length; ++i) {
            int j;
            for (j = 0; !(j >= raw.length || i != j && CodeModelUtils.box(raw[i].getType()).isAssignableFrom(CodeModelUtils.box(raw[j].getType()))); ++j) {
            }
            if (j != raw.length) continue;
            s.add(raw[i]);
        }
        if (s.size() == 1) {
            return (TypeItem)s.iterator().next();
        }
        throw new AssertionError((Object)"There can be at most one common base type item.");
    }

    public static TypeItem[] getAllTypeItems(FieldItem fieldItem) {
        TypeItem[] fieldItemTypes = fieldItem.listTypes();
        TypeItem.sort((TypeItem[])fieldItemTypes);
        return fieldItemTypes;
    }

    public static Collection getTypeItems(FieldItem fieldItem) {
        HashSet<TypeItem> typeItems = new HashSet<TypeItem>(1);
        TypeItem[] fieldItemTypes = fieldItem.listTypes();
        TypeItem.sort((TypeItem[])fieldItemTypes);
        for (int index = fieldItemTypes.length - 1; index >= 0; --index) {
            TypeItem typeItem = fieldItemTypes[index];
            if (typeItem instanceof ClassItem) {
                ClassItem classItem = (ClassItem)typeItem;
                typeItems.remove(classItem.getSuperClass());
            }
            typeItems.add(typeItem);
        }
        return typeItems;
    }

    public static PrimitiveItem getPrimitiveItem(FieldItem fieldItem) {
        return (PrimitiveItem)TypeUtils.getTypeItems(fieldItem).iterator().next();
    }

    public static ClassItem getClassItem(ClassContext classContext, FieldItem fieldItem) {
        return (ClassItem)TypeUtils.getCommonBaseTypeItem(classContext, fieldItem);
    }

    public static ClassContext getFieldClassContext(ClassContext classContext, FieldItem fieldItem) {
        ClassItem fieldClassItem = TypeUtils.getClassItem(classContext, fieldItem);
        ClassContext fieldClassContext = classContext.parent.getClassContext(fieldClassItem);
        return fieldClassContext;
    }

    public static JDefinedClass getEnumClass(TypeItem typeItem) {
        JType type = typeItem.getType();
        if (type instanceof JDefinedClass) {
            return (JDefinedClass)type;
        }
        throw new IllegalArgumentException("Type item does not represent the enum.");
    }

    public static PrimitiveItem getPrimitiveItem(GeneratorContext parent, QName typeName) {
        PrimitiveItem[] primitiveItems = parent.getGrammar().getPrimitives();
        for (int index = 0; index < primitiveItems.length; ++index) {
            DataOrValueExp dovexp;
            StringPair name;
            PrimitiveItem item = primitiveItems[index];
            if (!(item.exp instanceof DataOrValueExp) || (name = (dovexp = (DataOrValueExp)item.exp).getName()) == null || !ObjectUtils.equals((Object)name.localName, (Object)typeName.getLocalPart()) || !ObjectUtils.equals((Object)name.namespaceURI, (Object)typeName.getNamespaceURI())) continue;
            return item;
        }
        return null;
    }

    public static ClassItem getClassItem(GeneratorContext parent, String className) {
        JDefinedClass theClass = parent.getCodeModel()._getClass(className);
        if (theClass != null) {
            ClassItem classItem = parent.getGrammar().getClassItem(theClass);
            return classItem;
        }
        return null;
    }
}

