/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.lang.impl;

import org.jvnet.jaxbcommons.lang.ClonedObjects;

public class DefaultClonedObjects
implements ClonedObjects {
    private int size;
    private transient Entry[] elementData;
    private int cursor;

    public DefaultClonedObjects(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Entry[initialCapacity];
    }

    public DefaultClonedObjects() {
        this(10);
    }

    public boolean isCloned(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (object != this.elementData[i].getKey()) continue;
            this.cursor = i;
            return true;
        }
        return false;
    }

    public void addCloned(Object object, Object clone) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = new Entry(object, clone);
    }

    public Object getClone(Object object) {
        Entry entry;
        int index;
        if (this.size == 0) {
            return null;
        }
        int cursor = this.cursor;
        if (cursor < 0) {
            cursor = 0;
        }
        if (cursor > this.size - 1) {
            cursor = this.size - 1;
        }
        for (index = cursor; index < this.size; ++index) {
            entry = this.elementData[index];
            if (object != entry.getKey()) continue;
            this.cursor = cursor;
            return entry.getValue();
        }
        for (index = 0; index < cursor - 1; ++index) {
            entry = this.elementData[index];
            if (object != entry.getKey()) continue;
            this.cursor = cursor;
            return entry.getValue();
        }
        return null;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Entry[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Entry[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    private static class Entry {
        private final Object key;
        private final Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

