/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.lang.impl;

import org.jvnet.jaxbcommons.lang.VisitedObjects;

public class DefaultVisitedObjects
implements VisitedObjects {
    private int size;
    private transient Object[] elementData;

    public DefaultVisitedObjects(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
    }

    public DefaultVisitedObjects() {
        this(10);
    }

    public boolean isVisited(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (object != this.elementData[i]) continue;
            return true;
        }
        return false;
    }

    public void addVisited(Object object) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = object;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }
}

