/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.lang.util;

import java.util.List;
import java.util.ListIterator;
import org.jvnet.jaxbcommons.lang.EqualsAware;
import org.jvnet.jaxbcommons.lang.VisitedObjects;

public class EqualsUtils {
    private EqualsUtils() {
    }

    public static boolean equals(Object left, Object right, VisitedObjects visitedObjects) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (left instanceof EqualsAware) {
            return ((EqualsAware)left).visitEquals(right, visitedObjects);
        }
        if (left instanceof List) {
            if (!(right instanceof List)) {
                return false;
            }
            ListIterator e1 = ((List)left).listIterator();
            ListIterator e2 = ((List)right).listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Object o1 = e1.next();
                Object o2 = e2.next();
                if (o1 != null ? (!(o1 instanceof EqualsAware) ? o1.equals(o2) : ((EqualsAware)o1).visitEquals(o2, visitedObjects)) : o2 == null) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }
        return left.equals(right);
    }
}

