/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.locator;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jvnet.jaxbcommons.locator.AbstractObjectLocator;
import org.jvnet.jaxbcommons.locator.ListEntryObjectLocator;
import org.jvnet.jaxbcommons.locator.ObjectLocator;

public final class DefaultListEntryObjectLocator
extends AbstractObjectLocator
implements ListEntryObjectLocator {
    protected final int index;

    public DefaultListEntryObjectLocator(ObjectLocator parentLocator, Object object, int index) {
        super(parentLocator, object);
        this.index = index;
    }

    public DefaultListEntryObjectLocator(ObjectLocator parentLocator, int index) {
        super(parentLocator, parentLocator.getObject());
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public Object[] getMessageParameters() {
        return new Object[]{this.getObject(), new Integer(this.getIndex())};
    }

    public String getMessage(ResourceBundle bundle) {
        try {
            String messageTemplate = bundle.getString(this.getMessageCode());
            return MessageFormat.format(messageTemplate, this.getMessageParameters());
        }
        catch (MissingResourceException mrex) {
            return MessageFormat.format("Object: {0}\nField: {1}\nEntry index: {2}.", this.getMessageParameters());
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ListEntryObjectLocator) {
            ListEntryObjectLocator locator = (ListEntryObjectLocator)obj;
            result = this.getObject() == locator.getObject() && this.getIndex() == locator.getIndex();
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode() * 23 + this.getIndex();
    }
}

