/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbvalidation.tests.one.validation;

import com.sun.org.apache.xerces.internal.impl.xpath.regex.RegularExpression;
import java.util.List;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.jvnet.jaxbcommons.locator.DefaultFieldObjectLocator;
import org.jvnet.jaxbcommons.locator.DefaultListEntryObjectLocator;
import org.jvnet.jaxbcommons.locator.ObjectLocator;
import org.jvnet.jaxbvalidation.event.ObjectValidationEvent;
import org.jvnet.jaxbvalidation.problem.Problem;
import org.jvnet.jaxbvalidation.problem.datatype.RegularExpressionProblem;
import org.jvnet.jaxbvalidation.problem.datatype.WrongLengthProblem;
import org.jvnet.jaxbvalidation.problem.structure.EmptyFieldProblem;
import org.jvnet.jaxbvalidation.problem.structure.NonExpectedClassProblem;
import org.jvnet.jaxbvalidation.problem.structure.TooFewElementsProblem;
import org.jvnet.jaxbvalidation.tests.one.ElementWithListAttribute1;
import org.jvnet.jaxbvalidation.validator.EntryValidator;
import org.jvnet.jaxbvalidation.validator.ObjectValidator;
import org.jvnet.jaxbvalidation.validator.ValueValidator;

public class ElementWithListAttribute1ObjectValidator
implements ObjectValidator {
    public static final ElementWithListAttribute1ObjectValidator INSTANCE = new ElementWithListAttribute1ObjectValidator();

    public void check(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
        ElementWithListAttribute1 value;
        if (draftValue != null && (value = (ElementWithListAttribute1)draftValue).isSetList1()) {
            DefaultFieldObjectLocator fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "List1");
            if (!value.isSetList1()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                if (value.getList1().size() < 0) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new TooFewElementsProblem(value.getList1().size(), 0)));
                }
                List1FieldValidator fieldValidator = List1FieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getList1());
            }
        }
    }

    public static class List1FieldValidator
    implements ObjectValidator,
    EntryValidator,
    ValueValidator {
        public static final List1FieldValidator INSTANCE = new List1FieldValidator();

        public void check(ObjectLocator parentLocator, ValidationEventHandler handler, Object value) {
            List values = (List)value;
            DefaultFieldObjectLocator locator = new DefaultFieldObjectLocator(parentLocator, "List1");
            if (values != null) {
                for (int index = 0; index < values.size(); ++index) {
                    Object item = values.get(index);
                    this.checkEntry((ObjectLocator)locator, handler, index, item);
                }
            }
        }

        public void checkEntry(ObjectLocator locator, ValidationEventHandler handler, int index, Object value) {
            DefaultListEntryObjectLocator entryLocator = new DefaultListEntryObjectLocator(locator, index);
            this.checkValue((ObjectLocator)entryLocator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                WrongLengthProblem problem = null;
                if ((null == realValue ? 0 : realValue.length()) != 9) {
                    problem = new WrongLengthProblem((Object)realValue, null == realValue ? 0 : realValue.length(), 9);
                }
                if (!new RegularExpression("[A-Z]{2}([0-9]|[A-Z]){7}", "X").matches(realValue.toString())) {
                    problem = new RegularExpressionProblem((Object)realValue, "[A-Z]{2}([0-9]|[A-Z]){7}");
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }
}

