/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.jexcel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellView;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import jxl.write.Blank;
import jxl.write.Formula;
import jxl.write.WritableCell;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.jxls.common.AreaRef;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.ImageType;
import org.jxls.common.RowData;
import org.jxls.common.SheetData;
import org.jxls.common.Size;
import org.jxls.transform.AbstractTransformer;
import org.jxls.transform.jexcel.JexcelCellData;
import org.jxls.transform.jexcel.JexcelRowData;
import org.jxls.transform.jexcel.JexcelSheetData;
import org.jxls.transform.jexcel.JexcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexcelTransformer
extends AbstractTransformer {
    private static Logger logger = LoggerFactory.getLogger(JexcelTransformer.class);
    public static final String JEXCEL_CONTEXT_KEY = "util";
    public static final int MAX_COLUMN_TO_READ_COMMENT = 50;
    private Workbook workbook;
    private WritableWorkbook writableWorkbook;

    public JexcelTransformer() {
    }

    private JexcelTransformer(Workbook workbook, WritableWorkbook writableWorkbook) {
        this.workbook = workbook;
        this.writableWorkbook = writableWorkbook;
    }

    public static JexcelTransformer createTransformer(InputStream is, OutputStream os) throws IOException, BiffException {
        Workbook workbook = Workbook.getWorkbook((InputStream)is);
        WritableWorkbook writableWorkbook = Workbook.createWorkbook((OutputStream)os, (Workbook)workbook);
        JexcelTransformer transformer = new JexcelTransformer(workbook, writableWorkbook);
        transformer.readCellData();
        return transformer;
    }

    public static Context createInitialContext() {
        Context context = new Context();
        context.putVar(JEXCEL_CONTEXT_KEY, (Object)new JexcelUtil());
        return context;
    }

    private void readCellData() {
        int numberOfSheets = this.workbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            Sheet sheet = this.workbook.getSheet(i);
            JexcelSheetData sheetData = JexcelSheetData.createSheetData(sheet, this);
            this.sheetMap.put(sheetData.getSheetName(), sheetData);
        }
    }

    public WritableWorkbook getWritableWorkbook() {
        return this.writableWorkbook;
    }

    public void transform(CellRef srcCellRef, CellRef targetCellRef, Context context, boolean updateRowHeightFlag) {
        CellData cellData = this.getCellData(srcCellRef);
        if (cellData != null) {
            String targetSheetName = targetCellRef.getSheetName();
            if (targetCellRef == null || targetSheetName == null) {
                logger.info("Target cellRef is null or has empty sheet name, cellRef=" + targetCellRef);
                return;
            }
            WritableSheet destSheet = this.writableWorkbook.getSheet(targetSheetName);
            String srcSheetName = srcCellRef.getSheetName();
            if (destSheet == null) {
                destSheet = this.createSheet(srcSheetName, targetSheetName);
            }
            SheetData sheetData = (SheetData)this.sheetMap.get(srcSheetName);
            if (!this.isIgnoreColumnProps()) {
                CellView columnView = destSheet.getColumnView(targetCellRef.getCol());
                columnView.setSize(sheetData.getColumnWidth(srcCellRef.getCol()));
                destSheet.setColumnView(targetCellRef.getCol(), columnView);
            }
            if (updateRowHeightFlag && !this.isIgnoreRowProps()) {
                try {
                    CellView rowView = destSheet.getRowView(targetCellRef.getRow());
                    rowView.setSize(sheetData.getRowData(srcCellRef.getRow()).getHeight());
                    destSheet.setRowView(targetCellRef.getRow(), rowView);
                }
                catch (RowsExceededException e) {
                    logger.warn("Failed to set row height for " + targetCellRef.getCellName(), (Throwable)e);
                }
            }
            try {
                ((JexcelCellData)cellData).writeToCell(destSheet, targetCellRef.getCol(), targetCellRef.getRow(), context);
                this.copyMergedRegions(cellData, targetCellRef);
            }
            catch (Exception e) {
                logger.error("Failed to write a cell with {} and context keys {}", new Object[]{cellData, context.toMap().keySet(), e});
            }
        }
    }

    private WritableSheet createSheet(String srcSheetName, String targetSheetName) {
        int numberOfSheets = this.writableWorkbook.getNumberOfSheets();
        WritableSheet destSheet = this.writableWorkbook.createSheet(targetSheetName, numberOfSheets);
        JexcelUtil.copySheetProperties(this.workbook.getSheet(srcSheetName), destSheet);
        return destSheet;
    }

    private void copyMergedRegions(CellData sourceCellData, CellRef destCell) throws WriteException {
        if (sourceCellData.getSheetName() == null) {
            throw new IllegalArgumentException("Sheet name is null in copyMergedRegions");
        }
        JexcelSheetData sheetData = (JexcelSheetData)((Object)this.sheetMap.get(sourceCellData.getSheetName()));
        Range cellMergedRegion = null;
        for (Range mergedRegion : sheetData.getMergedCells()) {
            if (mergedRegion.getTopLeft().getRow() != sourceCellData.getRow() || mergedRegion.getTopLeft().getColumn() != sourceCellData.getCol()) continue;
            cellMergedRegion = mergedRegion;
            break;
        }
        if (cellMergedRegion != null) {
            this.findAndRemoveExistingCellRegion(destCell);
            WritableSheet destSheet = this.writableWorkbook.getSheet(destCell.getSheetName());
            destSheet.mergeCells(destCell.getCol(), destCell.getRow(), destCell.getCol() + cellMergedRegion.getBottomRight().getColumn() - cellMergedRegion.getTopLeft().getColumn(), destCell.getRow() + cellMergedRegion.getBottomRight().getRow() - cellMergedRegion.getTopLeft().getRow());
        }
    }

    private void findAndRemoveExistingCellRegion(CellRef cellRef) {
        Range[] mergedRegions;
        WritableSheet destSheet = this.writableWorkbook.getSheet(cellRef.getSheetName());
        for (Range mergedRegion : mergedRegions = destSheet.getMergedCells()) {
            if (mergedRegion.getTopLeft().getRow() > cellRef.getRow() || mergedRegion.getBottomRight().getRow() < cellRef.getRow() || mergedRegion.getTopLeft().getColumn() > cellRef.getCol() || mergedRegion.getBottomRight().getColumn() < cellRef.getCol()) continue;
            destSheet.unmergeCells(mergedRegion);
        }
    }

    public void resetArea(AreaRef areaRef) {
        Range[] mergedRegions;
        WritableSheet destSheet = this.writableWorkbook.getSheet(areaRef.getSheetName());
        for (Range mergedRegion : mergedRegions = destSheet.getMergedCells()) {
            destSheet.unmergeCells(mergedRegion);
        }
    }

    public void setFormula(CellRef cellRef, String formulaString) {
        if (cellRef == null || cellRef.getSheetName() == null) {
            return;
        }
        WritableSheet sheet = this.writableWorkbook.getSheet(cellRef.getSheetName());
        if (sheet == null) {
            int numberOfSheets = this.writableWorkbook.getNumberOfSheets();
            sheet = this.writableWorkbook.createSheet(cellRef.getSheetName(), numberOfSheets);
        }
        Cell cell = sheet.getCell(cellRef.getCol(), cellRef.getRow());
        Formula writableCell = new Formula(cellRef.getCol(), cellRef.getRow(), formulaString);
        if (cell != null && cell.getCellFormat() != null) {
            writableCell.setCellFormat(cell.getCellFormat());
        }
        try {
            sheet.addCell((WritableCell)writableCell);
        }
        catch (Exception e) {
            logger.error("Failed to set formula = " + formulaString + " into cell = " + cellRef.getCellName(), (Throwable)e);
        }
    }

    public void clearCell(CellRef cellRef) {
        if (cellRef == null || cellRef.getSheetName() == null) {
            return;
        }
        WritableSheet sheet = this.writableWorkbook.getSheet(cellRef.getSheetName());
        if (sheet == null) {
            return;
        }
        Blank blankCell = new Blank(cellRef.getCol(), cellRef.getRow());
        try {
            sheet.addCell((WritableCell)blankCell);
        }
        catch (WriteException e) {
            logger.error("Failed to clean up cell " + cellRef.getCellName(), (Throwable)e);
        }
    }

    public List<CellData> getCommentedCells() {
        ArrayList<CellData> commentedCells = new ArrayList<CellData>();
        for (SheetData sheetData : this.sheetMap.values()) {
            for (RowData rowData : sheetData) {
                if (rowData == null) continue;
                for (CellData cellData : rowData) {
                    if (cellData == null || cellData.getCellComment() == null) continue;
                    commentedCells.add(cellData);
                }
                if (rowData.getNumberOfCells() != 0) continue;
                List<CellData> commentedCellData = this.readCommentsFromSheet(((JexcelSheetData)sheetData).getSheet(), ((JexcelRowData)rowData).getRow());
                commentedCells.addAll(commentedCellData);
            }
        }
        return commentedCells;
    }

    public void addImage(AreaRef areaRef, byte[] imageBytes, ImageType imageType) {
        if (imageType == null) {
            throw new IllegalArgumentException("Image type is undefined");
        }
        if (imageType != ImageType.PNG) {
            throw new IllegalArgumentException("Only PNG images are currently supported");
        }
        WritableSheet sheet = this.writableWorkbook.getSheet(areaRef.getSheetName());
        sheet.addImage(new WritableImage((double)areaRef.getFirstCellRef().getCol(), (double)areaRef.getFirstCellRef().getRow(), (double)(areaRef.getLastCellRef().getCol() - areaRef.getFirstCellRef().getCol()), (double)(areaRef.getLastCellRef().getRow() - areaRef.getFirstCellRef().getRow()), imageBytes));
    }

    public void write() throws IOException {
        if (this.writableWorkbook != null) {
            this.writableWorkbook.write();
            try {
                this.writableWorkbook.close();
            }
            catch (WriteException e) {
                throw new IllegalStateException("Cannot close a writable workbook", e);
            }
        } else {
            throw new IllegalStateException("An attempt to write an output stream with an uninitialized WritableWorkbook");
        }
    }

    private List<CellData> readCommentsFromSheet(Sheet sheet, Cell[] cells) {
        ArrayList<CellData> commentDataCells = new ArrayList<CellData>();
        for (Cell cell : cells) {
            CellFeatures cellFeatures = cell.getCellFeatures();
            if (cellFeatures.getComment() == null) continue;
            CellData cellData = new CellData(new CellRef(sheet.getName(), cell.getRow(), cell.getColumn()));
            cellData.setCellComment(cellFeatures.getComment());
            commentDataCells.add(cellData);
        }
        return commentDataCells;
    }

    public boolean deleteSheet(String sheetName) {
        if (super.deleteSheet(sheetName)) {
            Integer sheetIndex = this.findSheetIndex(sheetName);
            this.writableWorkbook.removeSheet(sheetIndex.intValue());
            return true;
        }
        logger.warn("Failed to find '{}' worksheet in a sheet map. Skipping the deletion.", (Object)sheetName);
        return false;
    }

    public void setHidden(String sheetName, boolean hidden) {
        WritableSheet sheet = this.writableWorkbook.getSheet(sheetName);
        sheet.getSettings().setHidden(hidden);
    }

    public void updateRowHeight(String srcSheetName, int srcRowNum, String targetSheetName, int targetRowNum) {
        SheetData sheetData = (SheetData)this.sheetMap.get(srcSheetName);
        RowData rowData = sheetData.getRowData(srcRowNum);
        WritableSheet destSheet = this.writableWorkbook.getSheet(targetSheetName);
        if (destSheet == null) {
            destSheet = this.createSheet(srcSheetName, targetSheetName);
        }
        try {
            CellView rowView = destSheet.getRowView(targetRowNum);
            if (rowData != null) {
                rowView.setSize((int)((short)rowData.getHeight()));
            } else {
                rowView.setAutosize(true);
            }
            destSheet.setRowView(targetRowNum, rowView);
        }
        catch (RowsExceededException e) {
            logger.error("Could not set Row View for row {}", (Object)targetRowNum, (Object)e);
        }
    }

    private Integer findSheetIndex(String sheetName) {
        Integer index = null;
        Sheet[] sheets = this.workbook.getSheets();
        for (int i = 0; i < sheets.length && index == null; ++i) {
            if (!sheets[i].getName().equals(sheetName)) continue;
            index = i;
        }
        return index;
    }

    public void adjustTableSize(CellRef ref, Size size) {
    }

    public void mergeCells(CellRef cellRef, int rows, int cols) {
        try {
            this.getWritableWorkbook().getSheet(cellRef.getSheetName()).mergeCells(cellRef.getCol(), cellRef.getRow(), cellRef.getCol() + cols - 1, cellRef.getRow() + rows - 1);
        }
        catch (WriteException e) {
            logger.error("Failed to merge cells, cell = {}, merge {} rows and {} columns", new Object[]{cellRef.getCellName(), rows, cols, e});
            throw new IllegalStateException("Failed to merge cells", e);
        }
    }
}

