/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.token;

import javax.ws.rs.BadRequestException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.admin.client.Config;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.BasicAuthFilter;
import org.keycloak.admin.client.token.TokenService;
import org.keycloak.common.util.Time;
import org.keycloak.representations.AccessTokenResponse;

public class TokenManager {
    private static final long DEFAULT_MIN_VALIDITY = 30L;
    private AccessTokenResponse currentToken;
    private long expirationTime;
    private long minTokenValidity = 30L;
    private final Config config;
    private final TokenService tokenService;
    private final String accessTokenGrantType;

    public TokenManager(Config config, Client client) {
        this.config = config;
        WebTarget target = client.target(config.getServerUrl());
        if (!config.isPublicClient()) {
            target.register((Object)new BasicAuthFilter(config.getClientId(), config.getClientSecret()));
        }
        this.tokenService = Keycloak.getClientProvider().targetProxy(target, TokenService.class);
        this.accessTokenGrantType = config.getGrantType();
        if ("client_credentials".equals(this.accessTokenGrantType) && config.isPublicClient()) {
            throw new IllegalArgumentException("Can't use grant_type=client_credentials with public client");
        }
    }

    public String getAccessTokenString() {
        return this.getAccessToken().getToken();
    }

    public synchronized AccessTokenResponse getAccessToken() {
        if (this.currentToken == null) {
            this.grantToken();
        } else if (this.tokenExpired()) {
            this.refreshToken();
        }
        return this.currentToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTokenResponse grantToken() {
        Form form = new Form().param("grant_type", this.accessTokenGrantType);
        if ("password".equals(this.accessTokenGrantType)) {
            form.param("username", this.config.getUsername()).param("password", this.config.getPassword());
        }
        if (this.config.getScope() != null) {
            form.param("scope", this.config.getScope());
        }
        if (this.config.isPublicClient()) {
            form.param("client_id", this.config.getClientId());
        }
        int requestTime = Time.currentTime();
        TokenManager tokenManager = this;
        synchronized (tokenManager) {
            this.currentToken = this.tokenService.grantToken(this.config.getRealm(), (MultivaluedMap<String, String>)form.asMap());
            this.expirationTime = (long)requestTime + this.currentToken.getExpiresIn();
        }
        return this.currentToken;
    }

    public synchronized AccessTokenResponse refreshToken() {
        if (this.currentToken.getRefreshToken() == null) {
            return this.grantToken();
        }
        Form form = new Form().param("grant_type", "refresh_token").param("refresh_token", this.currentToken.getRefreshToken());
        if (this.config.isPublicClient()) {
            form.param("client_id", this.config.getClientId());
        }
        try {
            int requestTime = Time.currentTime();
            this.currentToken = this.tokenService.refreshToken(this.config.getRealm(), (MultivaluedMap<String, String>)form.asMap());
            this.expirationTime = (long)requestTime + this.currentToken.getExpiresIn();
            return this.currentToken;
        }
        catch (BadRequestException e) {
            return this.grantToken();
        }
    }

    public synchronized void setMinTokenValidity(long minTokenValidity) {
        this.minTokenValidity = minTokenValidity;
    }

    private synchronized boolean tokenExpired() {
        return (long)Time.currentTime() + this.minTokenValidity >= this.expirationTime;
    }

    public synchronized void invalidate(String token) {
        if (this.currentToken == null) {
            return;
        }
        if (token.equals(this.currentToken.getToken())) {
            this.expirationTime = -1L;
        }
    }
}

