/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.profile;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.common.Profile;
import org.keycloak.common.profile.ProfileConfigResolver;

public class CommaSeparatedListProfileConfigResolver
implements ProfileConfigResolver {
    private Set<String> enabledFeatures;
    private Set<String> disabledFeatures;

    public CommaSeparatedListProfileConfigResolver(String enabledFeatures, String disabledFeatures) {
        if (enabledFeatures != null) {
            this.enabledFeatures = Arrays.stream(enabledFeatures.split(",")).collect(Collectors.toSet());
        }
        if (disabledFeatures != null) {
            this.disabledFeatures = Arrays.stream(disabledFeatures.split(",")).collect(Collectors.toSet());
        }
    }

    @Override
    public Profile.ProfileName getProfileName() {
        if (this.enabledFeatures != null && this.enabledFeatures.contains(Profile.ProfileName.PREVIEW.name().toLowerCase())) {
            return Profile.ProfileName.PREVIEW;
        }
        return null;
    }

    @Override
    public ProfileConfigResolver.FeatureConfig getFeatureConfig(Profile.Feature feature) {
        String key = feature.getKey();
        if (this.enabledFeatures != null && this.enabledFeatures.contains(key)) {
            return ProfileConfigResolver.FeatureConfig.ENABLED;
        }
        if (this.disabledFeatures != null && this.disabledFeatures.contains(key)) {
            return ProfileConfigResolver.FeatureConfig.DISABLED;
        }
        return ProfileConfigResolver.FeatureConfig.UNCONFIGURED;
    }
}

