/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwe;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.jose.JOSE;
import org.keycloak.jose.JOSEHeader;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.JWERegistry;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import org.keycloak.util.JsonSerialization;

public class JWE
implements JOSE {
    private JWEHeader header;
    private String base64Header;
    private JWEKeyStorage keyStorage = new JWEKeyStorage();
    private String base64Cek;
    private byte[] initializationVector;
    private byte[] content;
    private byte[] encryptedContent;
    private byte[] authenticationTag;

    public JWE() {
    }

    public JWE(String jwt) {
        this.setupJWEHeader(jwt);
    }

    public JWE header(JWEHeader header) {
        this.header = header;
        this.base64Header = null;
        return this;
    }

    public JOSEHeader getHeader() {
        if (this.header == null && this.base64Header != null) {
            try {
                byte[] decodedHeader = Base64Url.decode((String)this.base64Header);
                this.header = JsonSerialization.readValue(decodedHeader, JWEHeader.class);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.header;
    }

    public String getBase64Header() throws IOException {
        if (this.base64Header == null && this.header != null) {
            byte[] contentBytes = JsonSerialization.writeValueAsBytes(this.header);
            this.base64Header = Base64Url.encode((byte[])contentBytes);
        }
        return this.base64Header;
    }

    public JWEKeyStorage getKeyStorage() {
        return this.keyStorage;
    }

    public byte[] getInitializationVector() {
        return this.initializationVector;
    }

    public JWE content(byte[] content) {
        this.content = content;
        return this;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getEncryptedContent() {
        return this.encryptedContent;
    }

    public byte[] getAuthenticationTag() {
        return this.authenticationTag;
    }

    public void setEncryptedContentInfo(byte[] initializationVector, byte[] encryptedContent, byte[] authenticationTag) {
        this.initializationVector = initializationVector;
        this.encryptedContent = encryptedContent;
        this.authenticationTag = authenticationTag;
    }

    public String encodeJwe() throws JWEException {
        try {
            if (this.header == null) {
                throw new IllegalStateException("Header must be set");
            }
            return this.encodeJwe(JWERegistry.getAlgProvider(this.header.getAlgorithm()), JWERegistry.getEncProvider(this.header.getEncryptionAlgorithm()));
        }
        catch (Exception e) {
            throw new JWEException(e);
        }
    }

    public String encodeJwe(JWEAlgorithmProvider algorithmProvider, JWEEncryptionProvider encryptionProvider) throws JWEException {
        try {
            if (this.header == null) {
                throw new IllegalStateException("Header must be set");
            }
            if (this.content == null) {
                throw new IllegalStateException("Content must be set");
            }
            if (algorithmProvider == null) {
                throw new IllegalArgumentException("No provider for alg '" + this.header.getAlgorithm() + "'");
            }
            if (encryptionProvider == null) {
                throw new IllegalArgumentException("No provider for enc '" + this.header.getEncryptionAlgorithm() + "'");
            }
            this.keyStorage.setEncryptionProvider(encryptionProvider);
            this.keyStorage.getCEKKey(JWEKeyStorage.KeyUse.ENCRYPTION, true);
            byte[] encodedCEK = algorithmProvider.encodeCek(encryptionProvider, this.keyStorage, this.keyStorage.getEncryptionKey());
            this.base64Cek = Base64Url.encode((byte[])encodedCEK);
            encryptionProvider.encodeJwe(this);
            return this.getEncodedJweString();
        }
        catch (Exception e) {
            throw new JWEException(e);
        }
    }

    private String getEncodedJweString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.base64Header).append(".").append(this.base64Cek).append(".").append(Base64Url.encode((byte[])this.initializationVector)).append(".").append(Base64Url.encode((byte[])this.encryptedContent)).append(".").append(Base64Url.encode((byte[])this.authenticationTag));
        return builder.toString();
    }

    private void setupJWEHeader(String jweStr) throws IllegalStateException {
        String[] parts = jweStr.split("\\.");
        if (parts.length != 5) {
            throw new IllegalStateException("Not a JWE String");
        }
        this.base64Header = parts[0];
        this.base64Cek = parts[1];
        this.initializationVector = Base64Url.decode((String)parts[2]);
        this.encryptedContent = Base64Url.decode((String)parts[3]);
        this.authenticationTag = Base64Url.decode((String)parts[4]);
        this.header = (JWEHeader)this.getHeader();
    }

    private JWE getProcessedJWE(JWEAlgorithmProvider algorithmProvider, JWEEncryptionProvider encryptionProvider) throws Exception {
        if (algorithmProvider == null) {
            throw new IllegalArgumentException("No provider for alg ");
        }
        if (encryptionProvider == null) {
            throw new IllegalArgumentException("No provider for enc ");
        }
        this.keyStorage.setEncryptionProvider(encryptionProvider);
        byte[] decodedCek = algorithmProvider.decodeCek(Base64Url.decode((String)this.base64Cek), this.keyStorage.getDecryptionKey());
        this.keyStorage.setCEKBytes(decodedCek);
        encryptionProvider.verifyAndDecodeJwe(this);
        return this;
    }

    public JWE verifyAndDecodeJwe(String jweStr) throws JWEException {
        try {
            this.setupJWEHeader(jweStr);
            return this.verifyAndDecodeJwe();
        }
        catch (Exception e) {
            throw new JWEException(e);
        }
    }

    public JWE verifyAndDecodeJwe(String jweStr, JWEAlgorithmProvider algorithmProvider, JWEEncryptionProvider encryptionProvider) throws JWEException {
        try {
            this.setupJWEHeader(jweStr);
            return this.getProcessedJWE(algorithmProvider, encryptionProvider);
        }
        catch (Exception e) {
            throw new JWEException(e);
        }
    }

    public JWE verifyAndDecodeJwe() throws JWEException {
        try {
            return this.getProcessedJWE(JWERegistry.getAlgProvider(this.header.getAlgorithm()), JWERegistry.getEncProvider(this.header.getEncryptionAlgorithm()));
        }
        catch (Exception e) {
            throw new JWEException(e);
        }
    }

    public static String encryptUTF8(String password, String saltString, String payload) {
        byte[] bytes = payload.getBytes(StandardCharsets.UTF_8);
        return JWE.encrypt(password, saltString, bytes);
    }

    public static String encrypt(String password, String saltString, byte[] payload) {
        try {
            byte[] salt = Base64.decode((String)saltString);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 100, 128);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec aesKey = new SecretKeySpec(tmp.getEncoded(), "AES");
            JWEHeader jweHeader = new JWEHeader("A128KW", "A128CBC-HS256", null);
            JWE jwe = new JWE().header(jweHeader).content(payload);
            jwe.getKeyStorage().setEncryptionKey(aesKey);
            return jwe.encodeJwe();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decrypt(String password, String saltString, String encodedJwe) {
        try {
            byte[] salt = Base64.decode((String)saltString);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 100, 128);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec aesKey = new SecretKeySpec(tmp.getEncoded(), "AES");
            JWE jwe = new JWE();
            jwe.getKeyStorage().setDecryptionKey(aesKey);
            jwe.verifyAndDecodeJwe(encodedJwe);
            return jwe.getContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptUTF8(String password, String saltString, String encodedJwe) {
        byte[] payload = JWE.decrypt(password, saltString, encodedJwe);
        return new String(payload, StandardCharsets.UTF_8);
    }

    static {
        BouncyIntegration.init();
    }
}

