/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.fips;

import java.security.Provider;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.jboss.logging.Logger;

public class KeycloakFipsSecurityProvider
extends Provider {
    protected static final Logger logger = Logger.getLogger(KeycloakFipsSecurityProvider.class);
    private final BouncyCastleFipsProvider bcFipsProvider;

    public KeycloakFipsSecurityProvider(BouncyCastleFipsProvider bcFipsProvider) {
        super("KC(" + bcFipsProvider.toString() + (CryptoServicesRegistrar.isInApprovedOnlyMode() ? " Approved Mode" : "") + ")", 1.0, "Keycloak pseudo provider");
        this.bcFipsProvider = bcFipsProvider;
    }

    @Override
    public final synchronized Provider.Service getService(String type, String algorithm) {
        if ("SHA1PRNG".equals(algorithm) && "SecureRandom".equals(type)) {
            logger.debug((Object)"Returning DEFAULT algorithm of BCFIPS provider instead of SHA1PRNG");
            return this.bcFipsProvider.getService("SecureRandom", "DEFAULT");
        }
        return null;
    }
}

