/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Random;
import org.keycloak.forms.UserBean;
import org.keycloak.models.utils.Base32;

public class TotpBean {
    private UserBean user;
    private String totpSecret;
    private String totpSecretEncoded;
    private String contextUrl;

    public TotpBean(UserBean user, String contextUrl) {
        this.user = user;
        this.contextUrl = contextUrl;
        this.totpSecret = TotpBean.randomString(20);
        this.totpSecretEncoded = Base32.encode((byte[])this.totpSecret.getBytes());
    }

    private static String randomString(int length) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVW1234567890";
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(r.nextInt(chars.length()));
            sb.append(c);
        }
        return sb.toString();
    }

    public boolean isEnabled() {
        return this.user.getUser().isTotp();
    }

    public String getTotpSecret() {
        return this.totpSecret;
    }

    public String getTotpSecretEncoded() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.totpSecretEncoded.length(); i += 4) {
            sb.append(this.totpSecretEncoded.substring(i, i + 4 < this.totpSecretEncoded.length() ? i + 4 : this.totpSecretEncoded.length()));
            if (i + 4 >= this.totpSecretEncoded.length()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getTotpSecretQrCodeUrl() throws UnsupportedEncodingException {
        String contents = URLEncoder.encode("otpauth://totp/keycloak?secret=" + this.totpSecretEncoded, "utf-8");
        return this.contextUrl + "/rest/qrcode" + "?size=246x246&contents=" + contents;
    }

    public UserBean getUser() {
        return this.user;
    }

    public void setUser(UserBean user) {
        this.user = user;
    }
}

