/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms;

import java.net.URI;
import org.keycloak.forms.RealmBean;
import org.keycloak.services.resources.flows.Urls;

public class UrlBean {
    private URI baseURI;
    private RealmBean realm;
    private boolean socialRegistration;
    private String referrerURI;

    public boolean isSocialRegistration() {
        return this.socialRegistration;
    }

    public void setSocialRegistration(boolean socialRegistration) {
        this.socialRegistration = socialRegistration;
    }

    public UrlBean(RealmBean realm, URI baseURI, String referrerURI) {
        this.realm = realm;
        this.baseURI = baseURI;
        this.referrerURI = referrerURI;
    }

    public RealmBean getRealm() {
        return this.realm;
    }

    public void setRealm(RealmBean realm) {
        this.realm = realm;
    }

    public String getAccessUrl() {
        return Urls.accountAccessPage((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getAccountUrl() {
        return Urls.accountPage((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    URI getBaseURI() {
        return this.baseURI;
    }

    public String getLoginAction() {
        return Urls.realmLoginAction((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getLoginUrl() {
        return Urls.realmLoginPage((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getPasswordUrl() {
        return Urls.accountPasswordPage((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getRegistrationAction() {
        if (this.realm.isSaas()) {
            return Urls.saasRegisterAction((URI)this.baseURI).toString();
        }
        if (this.socialRegistration) {
            return Urls.socialRegisterAction((URI)this.baseURI, (String)this.realm.getId()).toString();
        }
        return Urls.realmRegisterAction((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getRegistrationUrl() {
        if (this.realm.isSaas()) {
            return Urls.saasRegisterPage((URI)this.baseURI).toString();
        }
        return Urls.realmRegisterPage((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getLoginUpdatePasswordUrl() {
        return Urls.loginActionUpdatePassword((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getLoginUpdateTotpUrl() {
        return Urls.loginActionUpdateTotp((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getLoginUpdateProfileUrl() {
        return Urls.loginActionUpdateProfile((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getSocialUrl() {
        return Urls.accountSocialPage((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getTotpUrl() {
        return Urls.accountTotpPage((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getTotpRemoveUrl() {
        return Urls.accountTotpRemove((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getLogoutUrl() {
        return Urls.accountLogout((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getLoginPasswordResetUrl() {
        return Urls.loginPasswordReset((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getLoginEmailVerificationUrl() {
        return Urls.loginActionEmailVerification((URI)this.baseURI, (String)this.realm.getId()).toString();
    }

    public String getReferrerURI() {
        return this.referrerURI;
    }
}

