/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jboss;

import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.keycloak.adapters.spi.KeycloakAccount;

public class KeycloakLoginModule
extends AbstractServerLoginModule {
    protected static Logger log = Logger.getLogger(KeycloakLoginModule.class);
    protected Set<String> roleSet;
    protected Principal identity;

    public boolean login() throws LoginException {
        log.debug((Object)"KeycloakLoginModule.login()");
        if (super.login()) {
            log.debug((Object)"super.login()==true");
            return true;
        }
        Object credential = this.getCredential();
        if (credential != null && credential instanceof KeycloakAccount) {
            log.debug((Object)"Found Account");
            KeycloakAccount account = (KeycloakAccount)credential;
            this.roleSet = account.getRoles();
            this.identity = account.getPrincipal();
            this.sharedState.put("javax.security.auth.login.name", this.identity);
            this.sharedState.put("javax.security.auth.login.password", credential);
            this.loginOk = true;
            return true;
        }
        return false;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected SimpleGroup[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        SimpleGroup[] roleSets = new SimpleGroup[]{roles};
        for (String role : this.roleSet) {
            roles.addMember((Principal)new SimplePrincipal(role));
        }
        return roleSets;
    }

    protected Object getCredential() throws LoginException {
        NameCallback nc = new NameCallback("Alias: ");
        ObjectCallback oc = new ObjectCallback("Credential: ");
        Callback[] callbacks = new Callback[]{nc, oc};
        try {
            this.callbackHandler.handle(callbacks);
            return oc.getCredential();
        }
        catch (IOException ioe) {
            LoginException le = new LoginException();
            le.initCause(ioe);
            throw le;
        }
        catch (UnsupportedCallbackException uce) {
            LoginException le = new LoginException();
            le.initCause(uce);
            throw le;
        }
    }
}

