/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@SerializeWith(value=ExternalizerImpl.class)
public class InitializerState
extends SessionEntity {
    private static final Logger log = Logger.getLogger(InitializerState.class);
    private final int segmentsCount;
    private final BitSet segments;

    public InitializerState(int segmentsCount) {
        this.segmentsCount = segmentsCount;
        this.segments = new BitSet(segmentsCount);
        log.debugf("segmentsCount: %d", segmentsCount);
    }

    private InitializerState(String realmId, int segmentsCount, BitSet segments) {
        super(realmId);
        this.segmentsCount = segmentsCount;
        this.segments = segments;
        log.debugf("segmentsCount: %d", segmentsCount);
    }

    public int getSegmentsCount() {
        return this.segmentsCount;
    }

    public boolean isFinished() {
        return this.segments.cardinality() == this.segmentsCount;
    }

    public int getProgressIndicator() {
        return this.segments.hashCode();
    }

    public List<Integer> getSegmentsToLoad(int segmentToLoad, int maxSegmentCount) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        for (int i = segmentToLoad; i < segmentToLoad + maxSegmentCount && i < this.segmentsCount; ++i) {
            if (this.segments.get(i)) continue;
            result.add(i);
        }
        return result;
    }

    public void markSegmentFinished(int index) {
        this.segments.set(index);
    }

    public String toString() {
        int finished = this.segments.cardinality();
        int nonFinished = this.segmentsCount - finished;
        return "finished segments count: " + finished + ", non-finished segments count: " + nonFinished;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.segmentsCount;
        hash = 97 * hash + Objects.hashCode(this.segments);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitializerState other = (InitializerState)obj;
        if (this.segmentsCount != other.segmentsCount) {
            return false;
        }
        return Objects.equals(this.segments, other.segments);
    }

    public static class ExternalizerImpl
    implements Externalizer<InitializerState> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, InitializerState value) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)value.getRealmId(), (ObjectOutput)output);
            output.writeInt(value.segmentsCount);
            MarshallUtil.marshallByteArray((byte[])value.segments.toByteArray(), (ObjectOutput)output);
        }

        public InitializerState readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public InitializerState readObjectVersion1(ObjectInput input) throws IOException {
            return new InitializerState(MarshallUtil.unmarshallString((ObjectInput)input), input.readInt(), BitSet.valueOf(MarshallUtil.unmarshallByteArray((ObjectInput)input)));
        }
    }
}

