/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ExpirationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ManagedCacheManagerProvider;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProviderFactory;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.connections.infinispan.RemoteCacheProvider;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.connections.infinispan.remote.RemoteInfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.infinispan.ClearCacheEvent;
import org.keycloak.models.cache.infinispan.events.RealmRemovedEvent;
import org.keycloak.models.cache.infinispan.events.RealmUpdatedEvent;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.InvalidationHandler;

public class DefaultInfinispanConnectionProviderFactory
implements InfinispanConnectionProviderFactory {
    private static final ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private static final Logger logger = Logger.getLogger(DefaultInfinispanConnectionProviderFactory.class);
    private Config.Scope config;
    private volatile EmbeddedCacheManager cacheManager;
    private volatile RemoteCacheProvider remoteCacheProvider;
    protected volatile boolean containerManaged;
    private volatile TopologyInfo topologyInfo;
    private volatile RemoteCacheManager remoteCacheManager;

    public InfinispanConnectionProvider create(KeycloakSession session) {
        this.lazyInit();
        return InfinispanUtils.isRemoteInfinispan() ? new RemoteInfinispanConnectionProvider(this.cacheManager, this.remoteCacheManager, this.topologyInfo) : new DefaultInfinispanConnectionProvider(this.cacheManager, this.remoteCacheProvider, this.topologyInfo);
    }

    public static void runWithReadLockOnCacheManager(Runnable task) {
        Lock lock = READ_WRITE_LOCK.readLock();
        lock.lock();
        try {
            task.run();
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T runWithReadLockOnCacheManager(Supplier<T> task) {
        Lock lock = READ_WRITE_LOCK.readLock();
        lock.lock();
        try {
            T t = task.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public static void runWithWriteLockOnCacheManager(Runnable task) {
        Lock lock = READ_WRITE_LOCK.writeLock();
        lock.lock();
        try {
            task.run();
        }
        finally {
            lock.unlock();
        }
    }

    public void close() {
        logger.debug((Object)"Closing provider");
        DefaultInfinispanConnectionProviderFactory.runWithWriteLockOnCacheManager(() -> {
            if (this.cacheManager != null && !this.containerManaged) {
                this.cacheManager.stop();
            }
            if (this.remoteCacheProvider != null) {
                this.remoteCacheProvider.stop();
            }
            if (this.remoteCacheManager != null && !this.containerManaged) {
                this.remoteCacheManager.stop();
            }
        });
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof PostMigrationEvent) {
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, this::registerSystemWideListeners);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInit() {
        if (this.cacheManager == null) {
            DefaultInfinispanConnectionProviderFactory defaultInfinispanConnectionProviderFactory = this;
            synchronized (defaultInfinispanConnectionProviderFactory) {
                if (this.cacheManager == null) {
                    EmbeddedCacheManager localCacheManager;
                    EmbeddedCacheManager managedCacheManager = null;
                    RemoteCacheManager rcm = null;
                    Iterator<ManagedCacheManagerProvider> providers = ServiceLoader.load(ManagedCacheManagerProvider.class, DefaultInfinispanConnectionProvider.class.getClassLoader()).iterator();
                    if (providers.hasNext()) {
                        ManagedCacheManagerProvider provider = providers.next();
                        if (providers.hasNext()) {
                            throw new RuntimeException("Multiple " + ManagedCacheManagerProvider.class + " providers found.");
                        }
                        managedCacheManager = (EmbeddedCacheManager)provider.getEmbeddedCacheManager(this.config);
                        if (InfinispanUtils.isRemoteInfinispan()) {
                            rcm = (RemoteCacheManager)provider.getRemoteCacheManager(this.config);
                        }
                    }
                    if (managedCacheManager == null) {
                        if (!this.config.getBoolean("embedded", Boolean.valueOf(false)).booleanValue()) {
                            throw new RuntimeException("No " + ManagedCacheManagerProvider.class.getName() + " found. If running in embedded mode set the [embedded] property to this provider.");
                        }
                        localCacheManager = this.initEmbedded();
                        if (InfinispanUtils.isRemoteInfinispan()) {
                            rcm = this.initRemote();
                        }
                    } else {
                        localCacheManager = this.initContainerManaged(managedCacheManager);
                    }
                    logger.infof(this.topologyInfo.toString(), new Object[0]);
                    this.remoteCacheProvider = new RemoteCacheProvider(this.config, localCacheManager);
                    this.cacheManager = localCacheManager;
                    this.remoteCacheManager = rcm;
                }
            }
        }
    }

    private RemoteCacheManager initRemote() {
        String host = this.config.get("remoteStoreHost", "127.0.0.1");
        Integer port = this.config.getInt("remoteStorePort", Integer.valueOf(11222));
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host(host).port(port.intValue());
        builder.connectionPool().maxActive(16).exhaustedAction(ExhaustedAction.CREATE_NEW);
        Marshalling.configure(builder);
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(builder.build());
        InfinispanConnectionProvider.skipSessionsCacheIfRequired(Arrays.stream(InfinispanConnectionProvider.CLUSTERED_CACHE_NAMES)).forEach(arg_0 -> ((RemoteCacheManager)remoteCacheManager).getCache(arg_0));
        return remoteCacheManager;
    }

    protected EmbeddedCacheManager initContainerManaged(EmbeddedCacheManager cacheManager) {
        this.containerManaged = true;
        this.defineRevisionCache(cacheManager, "realms", "realmRevisions", 20000L);
        this.defineRevisionCache(cacheManager, "users", "userRevisions", 100000L);
        this.defineRevisionCache(cacheManager, "authorization", "authorizationRevisions", 20000L);
        cacheManager.getCache("keys", true);
        this.topologyInfo = new TopologyInfo(cacheManager, this.config, false, this.getId());
        logger.debugv("Using container managed Infinispan cache container, lookup={0}", (Object)cacheManager);
        return cacheManager;
    }

    protected EmbeddedCacheManager initEmbedded() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        boolean clustered = this.config.getBoolean("clustered", Boolean.valueOf(false));
        boolean async = this.config.getBoolean("async", Boolean.valueOf(false));
        boolean useKeycloakTimeService = this.config.getBoolean("useKeycloakTimeService", Boolean.valueOf(false));
        this.topologyInfo = new TopologyInfo(this.cacheManager, this.config, true, this.getId());
        if (clustered) {
            String jgroupsUdpMcastAddr = this.config.get("jgroupsUdpMcastAddr", System.getProperty("jgroups.mcast_addr"));
            String jgroupsBindAddr = this.config.get("jgroupsBindAddr", System.getProperty("jgroups.bind.address"));
            InfinispanUtil.configureTransport(gcb, this.topologyInfo.getMyNodeName(), this.topologyInfo.getMySiteName(), jgroupsUdpMcastAddr, jgroupsBindAddr, "default-configs/default-keycloak-jgroups-udp.xml");
            gcb.jmx().domain("jboss.datagrid-infinispan-" + this.topologyInfo.getMyNodeName()).enable();
        } else {
            gcb.jmx().domain("jboss.datagrid-infinispan").enable();
        }
        Marshalling.configure(gcb);
        if (InfinispanUtils.isRemoteInfinispan()) {
            gcb.nonClusteredDefault();
        }
        DefaultCacheManager cacheManager = new DefaultCacheManager(gcb.build());
        if (useKeycloakTimeService) {
            InfinispanUtil.setTimeServiceToKeycloakTime((EmbeddedCacheManager)cacheManager);
        }
        this.containerManaged = false;
        logger.debug((Object)"Started embedded Infinispan cache container");
        Configuration localConfiguration = InfinispanUtil.createCacheConfigurationBuilder().build();
        this.defineLocalCache((EmbeddedCacheManager)cacheManager, "realms", "realmRevisions", localConfiguration, 20000L);
        this.defineLocalCache((EmbeddedCacheManager)cacheManager, "authorization", "authorizationRevisions", localConfiguration, 20000L);
        this.defineLocalCache((EmbeddedCacheManager)cacheManager, "users", "userRevisions", localConfiguration, 100000L);
        cacheManager.defineConfiguration("keys", this.getKeysCacheConfig());
        cacheManager.getCache("keys", true);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = InfinispanUtil.createCacheConfigurationBuilder();
        if (clustered) {
            builder.simpleCache(false);
            String sessionsMode = this.config.get("sessionsMode", "distributed");
            if (sessionsMode.equalsIgnoreCase("replicated")) {
                builder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
            } else if (sessionsMode.equalsIgnoreCase("distributed")) {
                builder.clustering().cacheMode(async ? CacheMode.DIST_ASYNC : CacheMode.DIST_SYNC);
            } else {
                throw new RuntimeException("Invalid value for sessionsMode");
            }
            int owners = this.config.getInt("sessionsOwners", Integer.valueOf(2));
            logger.debugf("Session owners: %d", owners);
            int l1Lifespan = this.config.getInt("l1Lifespan", Integer.valueOf(600000));
            boolean l1Enabled = l1Lifespan > 0;
            Boolean awaitInitialTransfer = this.config.getBoolean("awaitInitialTransfer", Boolean.valueOf(true));
            builder.clustering().hash().numOwners(owners).numSegments(this.config.getInt("sessionsSegments", Integer.valueOf(60)).intValue()).l1().enabled(l1Enabled).lifespan((long)l1Lifespan).stateTransfer().awaitInitialTransfer(awaitInitialTransfer.booleanValue()).timeout(30L, TimeUnit.SECONDS);
        }
        if (InfinispanUtils.isEmbeddedInfinispan()) {
            Configuration clusteredConfiguration = builder.build();
            this.defineClusteredCache((EmbeddedCacheManager)cacheManager, "sessions", clusteredConfiguration);
            this.defineClusteredCache((EmbeddedCacheManager)cacheManager, "offlineSessions", clusteredConfiguration);
            this.defineClusteredCache((EmbeddedCacheManager)cacheManager, "clientSessions", clusteredConfiguration);
            this.defineClusteredCache((EmbeddedCacheManager)cacheManager, "offlineClientSessions", clusteredConfiguration);
            this.defineClusteredCache((EmbeddedCacheManager)cacheManager, "loginFailures", clusteredConfiguration);
            this.defineClusteredCache((EmbeddedCacheManager)cacheManager, "authenticationSessions", clusteredConfiguration);
            org.infinispan.configuration.cache.ConfigurationBuilder actionTokenBuilder = InfinispanUtil.getActionTokenCacheConfig();
            if (clustered) {
                actionTokenBuilder.simpleCache(false);
                actionTokenBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
            }
            this.defineClusteredCache((EmbeddedCacheManager)cacheManager, "actionTokens", actionTokenBuilder.build());
            ExpirationConfigurationBuilder workBuilder = InfinispanUtil.createCacheConfigurationBuilder().expiration().enableReaper().wakeUpInterval(15L, TimeUnit.SECONDS);
            if (clustered) {
                workBuilder.simpleCache(false);
                workBuilder.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
            }
            this.defineClusteredCache((EmbeddedCacheManager)cacheManager, "work", builder.build());
        }
        return cacheManager;
    }

    private void defineLocalCache(EmbeddedCacheManager cacheManager, String cacheName, String revCacheName, Configuration configuration, long defaultMaxEntries) {
        cacheManager.defineConfiguration(cacheName, configuration);
        this.defineRevisionCache(cacheManager, cacheName, revCacheName, defaultMaxEntries);
    }

    private void defineRevisionCache(EmbeddedCacheManager cacheManager, String cacheName, String revCacheName, long defaultMaxEntries) {
        long maxCount = cacheManager.getCache(cacheName).getCacheConfiguration().memory().maxCount();
        maxCount = maxCount > 0L ? 2L * maxCount : defaultMaxEntries;
        cacheManager.defineConfiguration(revCacheName, this.getRevisionCacheConfig(maxCount));
        cacheManager.getCache(revCacheName);
    }

    private void defineClusteredCache(EmbeddedCacheManager cacheManager, String cacheName, Configuration baseConfiguration) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = InfinispanUtil.createCacheConfigurationBuilder();
        builder.read(baseConfiguration);
        if (this.config.getBoolean("remoteStoreEnabled", Boolean.valueOf(false)).booleanValue()) {
            this.configureRemoteCacheStore(builder, this.config.getBoolean("async", Boolean.valueOf(false)), cacheName);
        }
        cacheManager.defineConfiguration(cacheName, builder.build());
        cacheManager.getCache(cacheName);
    }

    private Configuration getRevisionCacheConfig(long maxEntries) {
        org.infinispan.configuration.cache.ConfigurationBuilder cb = InfinispanUtil.createCacheConfigurationBuilder();
        cb.simpleCache(false);
        cb.invocationBatching().enable().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        cb.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        cb.transaction().lockingMode(LockingMode.PESSIMISTIC);
        if (cb.memory().storage().canStoreReferences()) {
            cb.encoding().mediaType("application/x-java-object");
        }
        cb.memory().whenFull(EvictionStrategy.REMOVE).maxCount(maxEntries);
        return cb.build();
    }

    private void configureRemoteCacheStore(org.infinispan.configuration.cache.ConfigurationBuilder builder, boolean async, String cacheName) {
        String jdgServer = this.config.get("remoteStoreHost", "127.0.0.1");
        Integer jdgPort = this.config.getInt("remoteStorePort", Integer.valueOf(11222));
        boolean segmented = this.config.getBoolean("segmented", Boolean.valueOf(false));
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(RemoteStoreConfigurationBuilder.class)).ignoreModifications(false)).purgeOnStartup(false)).preload(false)).shared(true)).remoteCacheName(cacheName).segmented(segmented)).rawValues(true).forceReturnValues(false).protocolVersion(this.getHotrodVersion()).addServer().host(jdgServer).port(jdgPort.intValue()).async().enabled(async);
    }

    private ProtocolVersion getHotrodVersion() {
        String hotrodVersionStr = this.config.get("hotrodProtocolVersion", ProtocolVersion.DEFAULT_PROTOCOL_VERSION.toString());
        ProtocolVersion hotrodVersion = ProtocolVersion.parseVersion((String)hotrodVersionStr);
        if (hotrodVersion == null) {
            hotrodVersion = ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
        }
        logger.debugf("HotRod protocol version: %s", (Object)hotrodVersion);
        return hotrodVersion;
    }

    protected Configuration getKeysCacheConfig() {
        org.infinispan.configuration.cache.ConfigurationBuilder cb = InfinispanUtil.createCacheConfigurationBuilder();
        cb.memory().whenFull(EvictionStrategy.REMOVE).maxCount(1000L);
        cb.expiration().maxIdle(3600L, TimeUnit.SECONDS);
        return cb.build();
    }

    private void registerSystemWideListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener("REALM_CLEAR_CACHE_EVENTS", event -> {
            if (event instanceof ClearCacheEvent) {
                sessionFactory.invalidate(null, (InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType._ALL_, new Object[0]);
            }
        });
        cluster.registerListener("REALM_INVALIDATION_EVENTS", event -> {
            if (event instanceof RealmUpdatedEvent) {
                RealmUpdatedEvent rr = (RealmUpdatedEvent)event;
                sessionFactory.invalidate(null, (InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType.REALM, new Object[]{rr.getId()});
            } else if (event instanceof RealmRemovedEvent) {
                RealmRemovedEvent rr = (RealmRemovedEvent)event;
                sessionFactory.invalidate(null, (InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType.REALM, new Object[]{rr.getId()});
            }
        });
    }
}

