/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@ProtoTypeId(value=65600)
@Indexed
public class RootAuthenticationSessionEntity
extends SessionEntity {
    private final String id;
    private int timestamp;
    private Map<String, AuthenticationSessionEntity> authenticationSessions = new ConcurrentHashMap<String, AuthenticationSessionEntity>();

    public RootAuthenticationSessionEntity(String id) {
        this.id = id;
    }

    protected RootAuthenticationSessionEntity(String realmId, String id, int timestamp, Map<String, AuthenticationSessionEntity> authenticationSessions) {
        super(realmId);
        this.id = id;
        this.timestamp = timestamp;
        this.authenticationSessions = authenticationSessions;
    }

    @ProtoFactory
    static RootAuthenticationSessionEntity protoFactory(String realmId, String id, int timestamp, Map<String, AuthenticationSessionEntity> authenticationSessions) {
        return new RootAuthenticationSessionEntity(realmId, id, timestamp, authenticationSessions);
    }

    @ProtoField(value=2)
    public String getId() {
        return this.id;
    }

    @ProtoField(value=3)
    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    @ProtoField(value=4, mapImplementation=ConcurrentHashMap.class)
    public Map<String, AuthenticationSessionEntity> getAuthenticationSessions() {
        return this.authenticationSessions;
    }

    public void setAuthenticationSessions(Map<String, AuthenticationSessionEntity> authenticationSessions) {
        this.authenticationSessions = authenticationSessions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RootAuthenticationSessionEntity)) return false;
        RootAuthenticationSessionEntity that = (RootAuthenticationSessionEntity)o;
        if (!Objects.equals(this.id, that.id)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return String.format("RootAuthenticationSessionEntity [ id=%s, realm=%s ]", this.getId(), this.getRealmId());
    }
}

