/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.module.configuration.global;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.keycloak.infinispan.module.certificates.JGroupsCertificateHolder;
import org.keycloak.infinispan.module.configuration.global.KeycloakConfiguration;
import org.keycloak.models.KeycloakSessionFactory;

public class KeycloakConfigurationBuilder
implements Builder<KeycloakConfiguration> {
    private final AttributeSet attributes = KeycloakConfiguration.attributeSet();

    public KeycloakConfigurationBuilder(GlobalConfigurationBuilder unused) {
    }

    public KeycloakConfiguration create() {
        return new KeycloakConfiguration(this.attributes.protect());
    }

    public Builder<?> read(KeycloakConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public void validate() {
    }

    public KeycloakConfigurationBuilder setKeycloakSessionFactory(KeycloakSessionFactory keycloakSessionFactory) {
        this.attributes.attribute(KeycloakConfiguration.KEYCLOAK_SESSION_FACTORY).set((Object)keycloakSessionFactory);
        return this;
    }

    public KeycloakConfigurationBuilder setJGroupCertificateHolder(JGroupsCertificateHolder jGroupsCertificateHolder) {
        this.attributes.attribute(KeycloakConfiguration.JGROUPS_CERTIFICATE_HOLDER).set((Object)jGroupsCertificateHolder);
        return this;
    }

    public KeycloakConfigurationBuilder setJGroupsCertificateRotation(int days) {
        this.attributes.attribute(KeycloakConfiguration.JGROUPS_CERTIFICATE_ROTATION).set((Object)days);
        return this;
    }
}

