/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class GroupAddedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String groupId;
    private String realmId;
    private String parentId;

    public static GroupAddedEvent create(String groupId, String parentId, String realmId) {
        GroupAddedEvent event = new GroupAddedEvent();
        event.realmId = realmId;
        event.parentId = parentId;
        event.groupId = groupId;
        return event;
    }

    @Override
    public String getId() {
        return this.groupId;
    }

    public String toString() {
        return String.format("GroupAddedEvent [ realmId=%s, groupId=%s ]", this.realmId, this.groupId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.groupQueriesInvalidations(this.realmId, invalidations);
        if (this.parentId != null) {
            invalidations.add(this.parentId);
        }
    }

    public static class ExternalizerImpl
    implements Externalizer<GroupAddedEvent> {
        private static final int VERSION_1 = 1;
        private static final int VERSION_2 = 2;

        public void writeObject(ObjectOutput output, GroupAddedEvent obj) throws IOException {
            output.writeByte(2);
            MarshallUtil.marshallString((String)obj.groupId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.parentId, (ObjectOutput)output);
        }

        public GroupAddedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
                case 2: {
                    return this.readObjectVersion2(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public GroupAddedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            GroupAddedEvent res = new GroupAddedEvent();
            res.groupId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }

        public GroupAddedEvent readObjectVersion2(ObjectInput input) throws IOException, ClassNotFoundException {
            GroupAddedEvent res = new GroupAddedEvent();
            res.groupId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.parentId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

