/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.GroupModel;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class GroupMovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String groupId;
    private String newParentId;
    private String oldParentId;
    private String realmId;

    public static GroupMovedEvent create(GroupModel group, GroupModel toParent, String realmId) {
        GroupMovedEvent event = new GroupMovedEvent();
        event.realmId = realmId;
        event.groupId = group.getId();
        event.oldParentId = group.getParentId();
        event.newParentId = toParent == null ? null : toParent.getId();
        return event;
    }

    @Override
    public String getId() {
        return this.groupId;
    }

    public String toString() {
        return String.format("GroupMovedEvent [ realmId=%s, groupId=%s, newParentId=%s, oldParentId=%s ]", this.realmId, this.groupId, this.newParentId, this.oldParentId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.groupQueriesInvalidations(this.realmId, invalidations);
        if (this.newParentId != null) {
            invalidations.add(this.newParentId);
        }
        if (this.oldParentId != null) {
            invalidations.add(this.oldParentId);
        }
    }

    public static class ExternalizerImpl
    implements Externalizer<GroupMovedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, GroupMovedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.groupId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.newParentId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.oldParentId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
        }

        public GroupMovedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public GroupMovedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            GroupMovedEvent res = new GroupMovedEvent();
            res.groupId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.newParentId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.oldParentId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

