/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.distexec.DistributedCallable;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;
import org.keycloak.models.utils.KeycloakModelUtils;

public class SessionInitializerWorker
implements DistributedCallable<String, Serializable, SessionLoader.WorkerResult>,
Serializable {
    private static final Logger log = Logger.getLogger(SessionInitializerWorker.class);
    private SessionLoader.LoaderContext loaderCtx;
    private SessionLoader.WorkerContext workerCtx;
    private SessionLoader sessionLoader;
    private transient Cache<String, Serializable> workCache;

    public void setWorkerEnvironment(SessionLoader.LoaderContext loaderCtx, SessionLoader.WorkerContext workerCtx, SessionLoader sessionLoader) {
        this.loaderCtx = loaderCtx;
        this.workerCtx = workerCtx;
        this.sessionLoader = sessionLoader;
    }

    public void setEnvironment(Cache<String, Serializable> workCache, Set<String> inputKeys) {
        this.workCache = workCache;
    }

    public SessionLoader.WorkerResult call() throws Exception {
        KeycloakSessionFactory sessionFactory;
        if (log.isTraceEnabled()) {
            log.tracef("Running computation for segment: %s", (Object)this.workerCtx.toString());
        }
        if ((sessionFactory = (KeycloakSessionFactory)this.workCache.getAdvancedCache().getComponentRegistry().getComponent(KeycloakSessionFactory.class)) == null) {
            log.debugf("KeycloakSessionFactory not yet set in cache. Worker skipped", new Object[0]);
            return this.sessionLoader.createFailedWorkerResult(this.loaderCtx, this.workerCtx);
        }
        final SessionLoader.WorkerResult[] ref = new SessionLoader.WorkerResult[1];
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                ref[0] = SessionInitializerWorker.this.sessionLoader.loadSessions(session, SessionInitializerWorker.this.loaderCtx, SessionInitializerWorker.this.workerCtx);
            }
        });
        return ref[0];
    }
}

