/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import liquibase.exception.CustomChangeException;
import liquibase.statement.core.RawSqlStatement;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate26_0_0_OrganizationGroupType
extends CustomKeycloakTask {
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String groupTable = this.getTableName("KEYCLOAK_GROUP");
        String orgTable = this.getTableName("ORG");
        if ("mariadb".equals(this.database.getShortName())) {
            this.statements.add(new RawSqlStatement("UPDATE " + groupTable + " SET TYPE = 1 WHERE CONVERT(NAME USING utf8) IN (SELECT CONVERT(ID USING utf8) FROM " + orgTable + ")"));
        } else {
            this.statements.add(new RawSqlStatement("UPDATE " + groupTable + " SET TYPE = 1 WHERE NAME IN (SELECT ID FROM " + orgTable + ")"));
        }
    }

    @Override
    protected String getTaskId() {
        return "Update type and id for organization groups";
    }
}

