/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.migration.MigrationModel;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.ClientAdapter;
import org.keycloak.models.jpa.ClientScopeAdapter;
import org.keycloak.models.jpa.GroupAdapter;
import org.keycloak.models.jpa.MigrationModelAdapter;
import org.keycloak.models.jpa.RealmAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.ClientInitialAccessEntity;
import org.keycloak.models.jpa.entities.ClientScopeEntity;
import org.keycloak.models.jpa.entities.GroupEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class JpaRealmProvider
implements RealmProvider {
    protected static final Logger logger = Logger.getLogger(JpaRealmProvider.class);
    private final KeycloakSession session;
    protected EntityManager em;

    public JpaRealmProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public MigrationModel getMigrationModel() {
        return new MigrationModelAdapter(this.em);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        RealmEntity realm = new RealmEntity();
        realm.setName(name);
        realm.setId(id);
        this.em.persist((Object)realm);
        this.em.flush();
        final RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmCreationEvent(){

            public RealmModel getCreatedRealm() {
                return adapter;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        });
        return adapter;
    }

    public RealmModel getRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return null;
        }
        RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        return adapter;
    }

    public List<RealmModel> getRealmsWithProviderType(Class<?> providerType) {
        TypedQuery query = this.em.createNamedQuery("getRealmIdsWithProviderType", String.class);
        query.setParameter("providerType", (Object)providerType.getName());
        return this.getRealms((TypedQuery<String>)query);
    }

    public List<RealmModel> getRealms() {
        TypedQuery query = this.em.createNamedQuery("getAllRealmIds", String.class);
        return this.getRealms((TypedQuery<String>)query);
    }

    private List<RealmModel> getRealms(TypedQuery<String> query) {
        List entities = query.getResultList();
        ArrayList<RealmModel> realms = new ArrayList<RealmModel>();
        for (String id : entities) {
            RealmModel realm = this.session.realms().getRealm(id);
            if (realm != null) {
                realms.add(realm);
            }
            this.em.flush();
        }
        return realms;
    }

    public RealmModel getRealmByName(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmIdByName", String.class);
        query.setParameter("name", (Object)name);
        List entities = query.getResultList();
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() > 1) {
            throw new IllegalStateException("Should not be more than one realm with same name");
        }
        String id = (String)query.getResultList().get(0);
        return this.session.realms().getRealm(id);
    }

    public boolean removeRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (realm == null) {
            return false;
        }
        this.em.refresh((Object)realm);
        final RealmAdapter adapter = new RealmAdapter(this.session, this.em, realm);
        this.session.users().preRemove((RealmModel)adapter);
        realm.getDefaultGroups().clear();
        this.em.flush();
        int num = this.em.createNamedQuery("deleteGroupRoleMappingsByRealm").setParameter("realm", (Object)realm).executeUpdate();
        TypedQuery query = this.em.createNamedQuery("getClientIdsByRealm", String.class);
        query.setParameter("realm", (Object)realm.getId());
        List clients = query.getResultList();
        for (String client : clients) {
            this.removeClient(client, adapter);
        }
        num = this.em.createNamedQuery("deleteDefaultClientScopeRealmMappingByRealm").setParameter("realm", (Object)realm).executeUpdate();
        for (ClientScopeEntity a : new LinkedList<ClientScopeEntity>(realm.getClientScopes())) {
            adapter.removeClientScope(a.getId());
        }
        for (RoleModel role : adapter.getRoles()) {
            this.removeRole(adapter, role);
        }
        for (GroupModel group : adapter.getGroups()) {
            this.session.realms().removeGroup((RealmModel)adapter, group);
        }
        num = this.em.createNamedQuery("removeClientInitialAccessByRealm").setParameter("realm", (Object)realm).executeUpdate();
        this.em.remove((Object)realm);
        this.em.flush();
        this.em.clear();
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmRemovedEvent(){

            public RealmModel getRealm() {
                return adapter;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        });
        return true;
    }

    public void close() {
    }

    public RoleModel addRealmRole(RealmModel realm, String name) {
        return this.addRealmRole(realm, KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        if (this.getRealmRole(realm, name) != null) {
            throw new ModelDuplicateException();
        }
        RoleEntity entity = new RoleEntity();
        entity.setId(id);
        entity.setName(name);
        RealmEntity ref = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        entity.setRealm(ref);
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        RoleAdapter adapter = new RoleAdapter(this.session, realm, this.em, entity);
        return adapter;
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoleIdByName", String.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)realm.getId());
        List roles = query.getResultList();
        if (roles.isEmpty()) {
            return null;
        }
        return this.session.realms().getRoleById((String)roles.get(0), realm);
    }

    public RoleModel addClientRole(RealmModel realm, ClientModel client, String name) {
        return this.addClientRole(realm, client, KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addClientRole(RealmModel realm, ClientModel client, String id, String name) {
        if (this.getClientRole(realm, client, name) != null) {
            throw new ModelDuplicateException();
        }
        ClientEntity clientEntity = (ClientEntity)this.em.getReference(ClientEntity.class, (Object)client.getId());
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setClient(clientEntity);
        roleEntity.setClientRole(true);
        roleEntity.setRealmId(realm.getId());
        this.em.persist((Object)roleEntity);
        RoleAdapter adapter = new RoleAdapter(this.session, realm, this.em, roleEntity);
        return adapter;
    }

    public Set<RoleModel> getRealmRoles(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoleIds", String.class);
        query.setParameter("realm", (Object)realm.getId());
        List roles = query.getResultList();
        if (roles.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        for (String id : roles) {
            list.add(this.session.realms().getRoleById(id, realm));
        }
        return Collections.unmodifiableSet(list);
    }

    public RoleModel getClientRole(RealmModel realm, ClientModel client, String name) {
        TypedQuery query = this.em.createNamedQuery("getClientRoleIdByName", String.class);
        query.setParameter("name", (Object)name);
        query.setParameter("client", (Object)client.getId());
        List roles = query.getResultList();
        if (roles.isEmpty()) {
            return null;
        }
        return this.session.realms().getRoleById((String)roles.get(0), realm);
    }

    public Set<RoleModel> getClientRoles(RealmModel realm, ClientModel client) {
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        TypedQuery query = this.em.createNamedQuery("getClientRoleIds", String.class);
        query.setParameter("client", (Object)client.getId());
        List roles = query.getResultList();
        for (String id : roles) {
            list.add(this.session.realms().getRoleById(id, realm));
        }
        return list;
    }

    public Set<RoleModel> getRealmRoles(RealmModel realm, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoles", RoleEntity.class);
        query.setParameter("realm", (Object)realm.getId());
        return this.getRoles((TypedQuery<RoleEntity>)query, realm, first, max);
    }

    public Set<RoleModel> getClientRoles(RealmModel realm, ClientModel client, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("getClientRoles", RoleEntity.class);
        query.setParameter("client", (Object)client.getId());
        return this.getRoles((TypedQuery<RoleEntity>)query, realm, first, max);
    }

    protected Set<RoleModel> getRoles(TypedQuery<RoleEntity> query, RealmModel realm, Integer first, Integer max) {
        if (Objects.nonNull(first) && Objects.nonNull(max) && first >= 0 && max >= 0) {
            query = query.setFirstResult(first.intValue()).setMaxResults(max.intValue());
        }
        List results = query.getResultList();
        return results.stream().map(role -> new RoleAdapter(this.session, realm, this.em, (RoleEntity)role)).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    public Set<RoleModel> searchForClientRoles(RealmModel realm, ClientModel client, String search, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("searchForClientRoles", RoleEntity.class);
        query.setParameter("client", (Object)client.getId());
        return this.searchForRoles((TypedQuery<RoleEntity>)query, realm, search, first, max);
    }

    public Set<RoleModel> searchForRoles(RealmModel realm, String search, Integer first, Integer max) {
        TypedQuery query = this.em.createNamedQuery("searchForRealmRoles", RoleEntity.class);
        query.setParameter("realm", (Object)realm.getId());
        return this.searchForRoles((TypedQuery<RoleEntity>)query, realm, search, first, max);
    }

    protected Set<RoleModel> searchForRoles(TypedQuery<RoleEntity> query, RealmModel realm, String search, Integer first, Integer max) {
        query.setParameter("search", (Object)("%" + search.trim().toLowerCase() + "%"));
        if (Objects.nonNull(first) && Objects.nonNull(max) && first >= 0 && max >= 0) {
            query = query.setFirstResult(first.intValue()).setMaxResults(max.intValue());
        }
        List results = query.getResultList();
        return results.stream().map(role -> new RoleAdapter(this.session, realm, this.em, (RoleEntity)role)).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public boolean removeRole(RealmModel realm, final RoleModel role) {
        this.session.users().preRemove(realm, role);
        RoleContainerModel container = role.getContainer();
        if (container.getDefaultRoles().contains(role.getName())) {
            container.removeDefaultRoles(new String[]{role.getName()});
        }
        RoleEntity roleEntity = (RoleEntity)this.em.getReference(RoleEntity.class, (Object)role.getId());
        String compositeRoleTable = JpaUtils.getTableNameForNativeQuery("COMPOSITE_ROLE", this.em);
        this.em.createNativeQuery("delete from " + compositeRoleTable + " where CHILD_ROLE = :role").setParameter("role", (Object)roleEntity).executeUpdate();
        realm.getClients().forEach(c -> c.deleteScopeMapping(role));
        this.em.createNamedQuery("deleteClientScopeRoleMappingByRole").setParameter("role", (Object)roleEntity).executeUpdate();
        int val = this.em.createNamedQuery("deleteGroupRoleMappingsByRole").setParameter("roleId", (Object)roleEntity.getId()).executeUpdate();
        this.em.flush();
        this.em.remove((Object)roleEntity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RoleContainerModel.RoleRemovedEvent(){

            public RoleModel getRole() {
                return role;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        });
        this.em.flush();
        return true;
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!realm.getId().equals(entity.getRealmId())) {
            return null;
        }
        RoleAdapter adapter = new RoleAdapter(this.session, realm, this.em, entity);
        return adapter;
    }

    public GroupModel getGroupById(String id, RealmModel realm) {
        GroupEntity groupEntity = (GroupEntity)this.em.find(GroupEntity.class, (Object)id);
        if (groupEntity == null) {
            return null;
        }
        if (!groupEntity.getRealm().getId().equals(realm.getId())) {
            return null;
        }
        GroupAdapter adapter = new GroupAdapter(realm, this.em, groupEntity);
        return adapter;
    }

    public void moveGroup(RealmModel realm, GroupModel group, GroupModel toParent) {
        if (toParent != null && group.getId().equals(toParent.getId())) {
            return;
        }
        if (group.getParentId() != null) {
            group.getParent().removeChild(group);
        }
        group.setParent(toParent);
        if (toParent != null) {
            toParent.addChild(group);
        } else {
            this.session.realms().addTopLevelGroup(realm, group);
        }
    }

    public List<GroupModel> getGroups(RealmModel realm) {
        RealmEntity ref = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        return ref.getGroups().stream().map(g -> this.session.realms().getGroupById(g.getId(), realm)).sorted(Comparator.comparing(GroupModel::getName)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        if (Objects.equals(onlyTopGroups, Boolean.TRUE)) {
            return (Long)this.em.createNamedQuery("getTopLevelGroupCount", Long.class).setParameter("realm", (Object)realm.getId()).setParameter("parent", (Object)GroupEntity.TOP_PARENT_ID).getSingleResult();
        }
        return (Long)this.em.createNamedQuery("getGroupCount", Long.class).setParameter("realm", (Object)realm.getId()).getSingleResult();
    }

    public Long getClientsCount(RealmModel realm) {
        return (Long)this.em.createNamedQuery("getRealmClientsCount", Long.class).setParameter("realm", (Object)realm.getId()).getSingleResult();
    }

    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        return this.searchForGroupByName(realm, search, null, null).size();
    }

    public List<GroupModel> getGroupsByRole(RealmModel realm, RoleModel role, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("groupsInRole", GroupEntity.class);
        query.setParameter("roleId", (Object)role.getId());
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        return results.stream().map(g -> new GroupAdapter(realm, this.em, (GroupEntity)g)).sorted(Comparator.comparing(GroupModel::getName)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<GroupModel> getTopLevelGroups(RealmModel realm) {
        RealmEntity ref = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        return ref.getGroups().stream().filter(g -> GroupEntity.TOP_PARENT_ID.equals(g.getParentId())).map(g -> this.session.realms().getGroupById(g.getId(), realm)).sorted(Comparator.comparing(GroupModel::getName)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<GroupModel> getTopLevelGroups(RealmModel realm, Integer first, Integer max) {
        List groupIds = this.em.createNamedQuery("getTopLevelGroupIds", String.class).setParameter("realm", (Object)realm.getId()).setParameter("parent", (Object)GroupEntity.TOP_PARENT_ID).setFirstResult(first.intValue()).setMaxResults(max.intValue()).getResultList();
        ArrayList<GroupModel> list = new ArrayList<GroupModel>();
        if (Objects.nonNull(groupIds) && !groupIds.isEmpty()) {
            for (String id : groupIds) {
                GroupModel group = this.getGroupById(id, realm);
                list.add(group);
            }
        }
        return Collections.unmodifiableList(list);
    }

    public boolean removeGroup(final RealmModel realm, final GroupModel group) {
        if (group == null) {
            return false;
        }
        GroupModel.GroupRemovedEvent event = new GroupModel.GroupRemovedEvent(){

            public RealmModel getRealm() {
                return realm;
            }

            public GroupModel getGroup() {
                return group;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        };
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)event);
        this.session.users().preRemove(realm, group);
        realm.removeDefaultGroup(group);
        for (GroupModel subGroup : group.getSubGroups()) {
            this.session.realms().removeGroup(realm, subGroup);
        }
        GroupEntity groupEntity = (GroupEntity)this.em.find(GroupEntity.class, (Object)group.getId(), LockModeType.PESSIMISTIC_WRITE);
        if (groupEntity == null || !groupEntity.getRealm().getId().equals(realm.getId())) {
            return false;
        }
        this.em.createNamedQuery("deleteGroupRoleMappingsByGroup").setParameter("group", (Object)groupEntity).executeUpdate();
        RealmEntity realmEntity = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        realmEntity.getGroups().remove(groupEntity);
        this.em.remove((Object)groupEntity);
        return true;
    }

    public GroupModel createGroup(RealmModel realm, String id, String name, GroupModel toParent) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        } else if (GroupEntity.TOP_PARENT_ID.equals(id)) {
            throw new ModelException("The ID of the new group is equals to the tag used for top level groups");
        }
        GroupEntity groupEntity = new GroupEntity();
        groupEntity.setId(id);
        groupEntity.setName(name);
        RealmEntity realmEntity = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        groupEntity.setRealm(realmEntity);
        groupEntity.setParentId(toParent == null ? GroupEntity.TOP_PARENT_ID : toParent.getId());
        this.em.persist((Object)groupEntity);
        this.em.flush();
        realmEntity.getGroups().add(groupEntity);
        GroupAdapter adapter = new GroupAdapter(realm, this.em, groupEntity);
        return adapter;
    }

    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        subGroup.setParent(null);
    }

    public ClientModel addClient(RealmModel realm, String clientId) {
        return this.addClient(realm, KeycloakModelUtils.generateId(), clientId);
    }

    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        if (clientId == null) {
            clientId = id;
        }
        ClientEntity entity = new ClientEntity();
        entity.setId(id);
        entity.setClientId(clientId);
        entity.setEnabled(true);
        entity.setStandardFlowEnabled(true);
        RealmEntity realmRef = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        entity.setRealm(realmRef);
        this.em.persist((Object)entity);
        this.em.flush();
        final ClientAdapter resource = new ClientAdapter(realm, this.em, this.session, entity);
        this.em.flush();
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.ClientCreationEvent(){

            public ClientModel getCreatedClient() {
                return resource;
            }
        });
        return resource;
    }

    public List<ClientModel> getClients(RealmModel realm, Integer firstResult, Integer maxResults) {
        TypedQuery query = this.em.createNamedQuery("getClientIdsByRealm", String.class);
        if (firstResult != null && firstResult > 0) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null && maxResults > 0) {
            query.setMaxResults(maxResults.intValue());
        }
        query.setParameter("realm", (Object)realm.getId());
        List clients = query.getResultList();
        if (clients.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<ClientModel> list = new LinkedList<ClientModel>();
        for (String id : clients) {
            ClientModel client = this.session.realms().getClientById(id, realm);
            if (client == null) continue;
            list.add(client);
        }
        return Collections.unmodifiableList(list);
    }

    public List<ClientModel> getClients(RealmModel realm) {
        return this.getClients(realm, null, null);
    }

    public List<ClientModel> getAlwaysDisplayInConsoleClients(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getAlwaysDisplayInConsoleClients", String.class);
        query.setParameter("realm", (Object)realm.getId());
        List clients = query.getResultList();
        if (clients.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<ClientModel> list = new LinkedList<ClientModel>();
        for (String id : clients) {
            ClientModel client = this.session.realms().getClientById(id, realm);
            if (client == null) continue;
            list.add(client);
        }
        return Collections.unmodifiableList(list);
    }

    public ClientModel getClientById(String id, RealmModel realm) {
        ClientEntity app = (ClientEntity)this.em.find(ClientEntity.class, (Object)id);
        if (app == null || !realm.getId().equals(app.getRealm().getId())) {
            return null;
        }
        ClientAdapter client = new ClientAdapter(realm, this.em, this.session, app);
        return client;
    }

    public ClientModel getClientByClientId(String clientId, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findClientIdByClientId", String.class);
        query.setParameter("clientId", (Object)clientId);
        query.setParameter("realm", (Object)realm.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        String id = (String)results.get(0);
        return this.session.realms().getClientById(id, realm);
    }

    public List<ClientModel> searchClientsByClientId(String clientId, Integer firstResult, Integer maxResults, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("searchClientsByClientId", String.class);
        if (firstResult != null && firstResult > 0) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null && maxResults > 0) {
            query.setMaxResults(maxResults.intValue());
        }
        query.setParameter("clientId", (Object)clientId);
        query.setParameter("realm", (Object)realm.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return results.stream().map(id -> this.session.realms().getClientById(id, realm)).collect(Collectors.toList());
    }

    public boolean removeClient(String id, RealmModel realm) {
        final ClientModel client = this.getClientById(id, realm);
        if (client == null) {
            return false;
        }
        this.session.users().preRemove(realm, client);
        for (RoleModel role : client.getRoles()) {
            this.removeRole(realm, role);
        }
        ClientEntity clientEntity = (ClientEntity)this.em.find(ClientEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.ClientRemovedEvent(){

            public ClientModel getClient() {
                return client;
            }

            public KeycloakSession getKeycloakSession() {
                return JpaRealmProvider.this.session;
            }
        });
        int countRemoved = this.em.createNamedQuery("deleteClientScopeClientMappingByClient").setParameter("client", (Object)clientEntity).executeUpdate();
        this.em.remove((Object)clientEntity);
        try {
            this.em.flush();
        }
        catch (RuntimeException e) {
            logger.errorv("Unable to delete client entity: {0} from realm {1}", (Object)client.getClientId(), (Object)realm.getName());
            throw e;
        }
        return true;
    }

    public ClientScopeModel getClientScopeById(String id, RealmModel realm) {
        ClientScopeEntity app = (ClientScopeEntity)this.em.find(ClientScopeEntity.class, (Object)id);
        if (app == null || !realm.getId().equals(app.getRealm().getId())) {
            return null;
        }
        ClientScopeAdapter adapter = new ClientScopeAdapter(realm, this.em, this.session, app);
        return adapter;
    }

    public List<GroupModel> searchForGroupByName(RealmModel realm, String search, Integer first, Integer max) {
        List groups;
        TypedQuery query = this.em.createNamedQuery("getGroupIdsByNameContaining", String.class).setParameter("realm", (Object)realm.getId()).setParameter("search", (Object)search);
        if (Objects.nonNull(first) && Objects.nonNull(max)) {
            query = query.setFirstResult(first.intValue()).setMaxResults(max.intValue());
        }
        if (Objects.isNull(groups = query.getResultList())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<GroupModel> list = new ArrayList<GroupModel>();
        for (String id : groups) {
            GroupModel groupById = this.session.realms().getGroupById(id, realm);
            while (Objects.nonNull(groupById.getParentId())) {
                groupById = this.session.realms().getGroupById(groupById.getParentId(), realm);
            }
            if (list.contains(groupById)) continue;
            list.add(groupById);
        }
        list.sort(Comparator.comparing(GroupModel::getName));
        return Collections.unmodifiableList(list);
    }

    public ClientInitialAccessModel createClientInitialAccessModel(RealmModel realm, int expiration, int count) {
        RealmEntity realmEntity = (RealmEntity)this.em.find(RealmEntity.class, (Object)realm.getId());
        ClientInitialAccessEntity entity = new ClientInitialAccessEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setRealm(realmEntity);
        entity.setCount(count);
        entity.setRemainingCount(count);
        int currentTime = Time.currentTime();
        entity.setTimestamp(currentTime);
        entity.setExpiration(expiration);
        this.em.persist((Object)entity);
        return this.entityToModel(entity);
    }

    public ClientInitialAccessModel getClientInitialAccessModel(RealmModel realm, String id) {
        ClientInitialAccessEntity entity = (ClientInitialAccessEntity)this.em.find(ClientInitialAccessEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public void removeClientInitialAccessModel(RealmModel realm, String id) {
        ClientInitialAccessEntity entity = (ClientInitialAccessEntity)this.em.find(ClientInitialAccessEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (entity != null) {
            this.em.remove((Object)entity);
            this.em.flush();
        }
    }

    public List<ClientInitialAccessModel> listClientInitialAccess(RealmModel realm) {
        RealmEntity realmEntity = (RealmEntity)this.em.find(RealmEntity.class, (Object)realm.getId());
        TypedQuery query = this.em.createNamedQuery("findClientInitialAccessByRealm", ClientInitialAccessEntity.class);
        query.setParameter("realm", (Object)realmEntity);
        List entities = query.getResultList();
        return entities.stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public void removeExpiredClientInitialAccess() {
        int currentTime = Time.currentTime();
        this.em.createNamedQuery("removeExpiredClientInitialAccess").setParameter("currentTime", (Object)currentTime).executeUpdate();
    }

    public void decreaseRemainingCount(RealmModel realm, ClientInitialAccessModel clientInitialAccess) {
        this.em.createNamedQuery("decreaseClientInitialAccessRemainingCount").setParameter("id", (Object)clientInitialAccess.getId()).executeUpdate();
    }

    private ClientInitialAccessModel entityToModel(ClientInitialAccessEntity entity) {
        ClientInitialAccessModel model = new ClientInitialAccessModel();
        model.setId(entity.getId());
        model.setCount(entity.getCount());
        model.setRemainingCount(entity.getRemainingCount());
        model.setExpiration(entity.getExpiration());
        model.setTimestamp(entity.getTimestamp());
        return model;
    }
}

