/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.UsersExportStrategy;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.storage.UserStorageUtil;

public abstract class MultipleStepsExportProvider<T extends MultipleStepsExportProvider<?>>
implements ExportProvider {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final KeycloakSessionFactory factory;
    private String realmId;
    private int usersPerFile;
    private UsersExportStrategy usersExportStrategy;

    public MultipleStepsExportProvider(KeycloakSessionFactory factory) {
        this.factory = factory;
    }

    public void exportModel() {
        if (this.realmId != null) {
            ServicesLogger.LOGGER.realmExportRequested(this.realmId);
            this.exportRealm(this.realmId);
        } else {
            ServicesLogger.LOGGER.fullModelExportRequested();
            List realms = (List)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.factory, session -> session.realms().getRealmsStream().collect(Collectors.toList()));
            for (RealmModel realm : realms) {
                this.exportRealmImpl(realm.getName());
            }
        }
        ServicesLogger.LOGGER.exportSuccess();
    }

    public T withRealmName(String realmName) {
        this.realmId = realmName;
        return (T)this;
    }

    public T withUsersPerFile(int usersPerFile) {
        this.usersPerFile = usersPerFile;
        return (T)this;
    }

    public T withUsersExportStrategy(UsersExportStrategy usersExportStrategy) {
        this.usersExportStrategy = usersExportStrategy;
        return (T)this;
    }

    public void exportRealm(String realmName) {
        this.exportRealmImpl(realmName);
    }

    protected void exportRealmImpl(final String realmName) {
        int countPerPage;
        final UsersHolder usersHolder = new UsersHolder();
        final boolean exportUsersIntoRealmFile = this.usersExportStrategy == UsersExportStrategy.REALM_FILE;
        final FederatedUsersHolder federatedUsersHolder = new FederatedUsersHolder();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, (KeycloakSessionTask)new ExportImportSessionTask(){

            @Override
            protected void runExportImportTask(KeycloakSession session) throws IOException {
                RealmModel realm = session.realms().getRealmByName(realmName);
                RealmRepresentation rep = ExportUtils.exportRealm((KeycloakSession)session, (RealmModel)realm, (boolean)exportUsersIntoRealmFile, (boolean)true);
                MultipleStepsExportProvider.this.writeRealm(realmName + "-realm.json", rep);
                MultipleStepsExportProvider.this.logger.info((Object)("Realm '" + realmName + "' - data exported"));
                if (!exportUsersIntoRealmFile) {
                    usersHolder.totalCount = session.users().getUsersCount(realm, true);
                    federatedUsersHolder.totalCount = UserStorageUtil.userFederatedStorage((KeycloakSession)session) != null ? UserStorageUtil.userFederatedStorage((KeycloakSession)session).getStoredUsersCount(realm) : 0;
                }
            }
        });
        if (this.usersExportStrategy != UsersExportStrategy.SKIP && !exportUsersIntoRealmFile) {
            usersHolder.currentPageStart = 0;
            int n = countPerPage = this.usersExportStrategy == UsersExportStrategy.SAME_FILE ? usersHolder.totalCount : this.usersPerFile;
            while (usersHolder.currentPageStart < usersHolder.totalCount) {
                usersHolder.currentPageEnd = usersHolder.currentPageStart + countPerPage < usersHolder.totalCount ? usersHolder.currentPageStart + countPerPage : usersHolder.totalCount;
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, (KeycloakSessionTask)new ExportImportSessionTask(){

                    @Override
                    protected void runExportImportTask(KeycloakSession session) throws IOException {
                        RealmModel realm = session.realms().getRealmByName(realmName);
                        usersHolder.users = session.users().searchForUserStream(realm, Collections.emptyMap(), Integer.valueOf(usersHolder.currentPageStart), Integer.valueOf(usersHolder.currentPageEnd - usersHolder.currentPageStart)).collect(Collectors.toList());
                        MultipleStepsExportProvider.this.writeUsers(realmName + "-users-" + usersHolder.currentPageStart / countPerPage + ".json", session, realm, usersHolder.users);
                        MultipleStepsExportProvider.this.logger.info((Object)("Users " + usersHolder.currentPageStart + "-" + (usersHolder.currentPageEnd - 1) + " exported"));
                    }
                });
                usersHolder.currentPageStart = usersHolder.currentPageEnd;
            }
        }
        if (this.usersExportStrategy != UsersExportStrategy.SKIP && !exportUsersIntoRealmFile) {
            federatedUsersHolder.currentPageStart = 0;
            int n = countPerPage = this.usersExportStrategy == UsersExportStrategy.SAME_FILE ? federatedUsersHolder.totalCount : this.usersPerFile;
            while (federatedUsersHolder.currentPageStart < federatedUsersHolder.totalCount) {
                federatedUsersHolder.currentPageEnd = federatedUsersHolder.currentPageStart + countPerPage < federatedUsersHolder.totalCount ? federatedUsersHolder.currentPageStart + countPerPage : federatedUsersHolder.totalCount;
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.factory, (KeycloakSessionTask)new ExportImportSessionTask(){

                    @Override
                    protected void runExportImportTask(KeycloakSession session) throws IOException {
                        RealmModel realm = session.realms().getRealmByName(realmName);
                        federatedUsersHolder.users = UserStorageUtil.userFederatedStorage((KeycloakSession)session).getStoredUsersStream(realm, Integer.valueOf(federatedUsersHolder.currentPageStart), Integer.valueOf(federatedUsersHolder.currentPageEnd - federatedUsersHolder.currentPageStart)).collect(Collectors.toList());
                        MultipleStepsExportProvider.this.writeFederatedUsers(realmName + "-federated-users-" + federatedUsersHolder.currentPageStart / countPerPage + ".json", session, realm, federatedUsersHolder.users);
                        MultipleStepsExportProvider.this.logger.info((Object)("Users " + federatedUsersHolder.currentPageStart + "-" + (federatedUsersHolder.currentPageEnd - 1) + " exported"));
                    }
                });
                federatedUsersHolder.currentPageStart = federatedUsersHolder.currentPageEnd;
            }
        }
    }

    protected abstract void writeRealm(String var1, RealmRepresentation var2) throws IOException;

    protected abstract void writeUsers(String var1, KeycloakSession var2, RealmModel var3, List<UserModel> var4) throws IOException;

    protected abstract void writeFederatedUsers(String var1, KeycloakSession var2, RealmModel var3, List<String> var4) throws IOException;

    public static class UsersHolder {
        List<UserModel> users;
        int totalCount;
        int currentPageStart;
        int currentPageEnd;
    }

    public static class FederatedUsersHolder {
        List<String> users;
        int totalCount;
        int currentPageStart;
        int currentPageEnd;
    }
}

