/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Objects;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authorization.adapter.MapResourceServerAdapter;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntity;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.HasRealmId;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.storage.StorageId;

public class MapResourceServerStore
implements ResourceServerStore {
    private static final Logger LOG = Logger.getLogger(MapResourceServerStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapStorage<MapResourceServerEntity, ResourceServer> store;
    private final boolean storeHasRealmId;

    public MapResourceServerStore(MapStorage<MapResourceServerEntity, ResourceServer> resourceServerStore, AuthorizationProvider provider) {
        this.authorizationProvider = provider;
        this.store = resourceServerStore;
        this.storeHasRealmId = this.store instanceof HasRealmId;
    }

    private Function<MapResourceServerEntity, ResourceServer> entityToAdapterFunc(RealmModel realmModel) {
        return origEntity -> new MapResourceServerAdapter(realmModel, (MapResourceServerEntity)origEntity, this.authorizationProvider.getStoreFactory());
    }

    private MapStorage<MapResourceServerEntity, ResourceServer> storeWithRealm(RealmModel realm) {
        if (this.storeHasRealmId) {
            ((HasRealmId)((Object)this.store)).setRealmId(realm == null ? null : realm.getId());
        }
        return this.store;
    }

    public ResourceServer create(ClientModel client) {
        LOG.tracef("create(%s)%s", (Object)client.getClientId(), StackUtil.getShortStackTrace());
        String clientId = client.getId();
        if (clientId == null) {
            return null;
        }
        if (!StorageId.isLocalStorage((String)clientId)) {
            throw new ModelException("Creating resource server from federated ClientModel not supported");
        }
        if (this.findByClient(client) != null) {
            throw new ModelDuplicateException("Resource server assiciated with client : " + client.getClientId() + " already exists.");
        }
        MapResourceServerEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapResourceServerEntity.class);
        RealmModel realm = client.getRealm();
        entity.setClientId(clientId);
        entity.setRealmId(realm.getId());
        entity = this.storeWithRealm(realm).create(entity);
        return entity == null ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public void delete(ClientModel client) {
        LOG.tracef("delete(%s)%s", (Object)client.getClientId(), StackUtil.getShortStackTrace());
        ResourceServer resourceServer = this.findByClient(client);
        if (resourceServer == null) {
            return;
        }
        RealmModel realm = client.getRealm();
        this.authorizationProvider.getKeycloakSession().invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.RESOURCE_SERVER_BEFORE_REMOVE, new Object[]{realm, resourceServer});
        this.storeWithRealm(realm).delete(resourceServer.getId());
        this.authorizationProvider.getKeycloakSession().invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.RESOURCE_SERVER_AFTER_REMOVE, new Object[]{resourceServer});
    }

    public ResourceServer findById(RealmModel realm, String id) {
        LOG.tracef("findById(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        if (id == null) {
            return null;
        }
        MapResourceServerEntity entity = this.storeWithRealm(realm).read(id);
        return entity == null || !Objects.equals(realm.getId(), entity.getRealmId()) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public ResourceServer findByClient(ClientModel client) {
        LOG.tracef("findByClient(%s) in realm(%s)%s", (Object)client.getClientId(), (Object)client.getRealm().getName(), StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(ResourceServer.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        mcb = (DefaultModelCriteria)mcb.compare(ResourceServer.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getRealm().getId()});
        RealmModel realm = client.getRealm();
        return this.storeWithRealm(realm).read(QueryParameters.withCriteria(mcb)).map(this.entityToAdapterFunc(client.getRealm())).findFirst().orElse(null);
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(ResourceServer.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.storeWithRealm(realm).delete(QueryParameters.withCriteria(mcb));
    }
}

