/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ReadOnlyUserModelDelegate;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.AbstractStorageManager;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.OnCreateComponent;
import org.keycloak.storage.OnUpdateComponent;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.UserStorageUtil;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.datastore.DefaultDatastoreProvider;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.storage.managers.UserStorageSyncManager;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserBulkUpdateProvider;
import org.keycloak.storage.user.UserCountMethodsProvider;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryMethodsProvider;
import org.keycloak.storage.user.UserRegistrationProvider;
import org.keycloak.userprofile.UserProfileDecorator;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.utils.StreamsUtil;

public class UserStorageManager
extends AbstractStorageManager<UserStorageProvider, UserStorageProviderModel>
implements UserProvider,
OnUserCache,
OnCreateComponent,
OnUpdateComponent,
UserProfileDecorator {
    private static final Logger logger = Logger.getLogger(UserStorageManager.class);

    public UserStorageManager(KeycloakSession session) {
        super(session, UserStorageProviderFactory.class, UserStorageProvider.class, UserStorageProviderModel::new, "user");
    }

    protected UserProvider localStorage() {
        return ((DefaultDatastoreProvider)this.session.getProvider(DatastoreProvider.class)).userLocalStorage();
    }

    private UserFederatedStorageProvider getFederatedStorage() {
        return UserStorageUtil.userFederatedStorage((KeycloakSession)this.session);
    }

    protected UserModel importValidation(RealmModel realm, UserModel user) {
        if (user == null || user.getFederationLink() == null) {
            return user;
        }
        UserStorageProviderModel model = (UserStorageProviderModel)this.getStorageProviderModel(realm, user.getFederationLink());
        if (model == null) {
            logger.debugf("Removed user with federation link of unknown storage provider '%s'", (Object)user.getUsername());
            this.deleteInvalidUser(realm, user);
            return null;
        }
        if (!model.isEnabled()) {
            return new ReadOnlyUserModelDelegate(user){

                public boolean isEnabled() {
                    return false;
                }
            };
        }
        ImportedUserValidation importedUserValidation = (ImportedUserValidation)this.getStorageProviderInstance((CacheableStorageProviderModel)model, ImportedUserValidation.class, true);
        if (importedUserValidation == null) {
            return user;
        }
        UserModel validated = importedUserValidation.validate(realm, user);
        if (validated == null) {
            this.deleteInvalidUser(realm, user);
            return null;
        }
        return validated;
    }

    private static <T> Stream<T> getCredentialProviders(KeycloakSession session, Class<T> type) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(CredentialProvider.class).filter(f -> Types.supports((Class)type, (Object)f, CredentialProviderFactory.class)).map(f -> session.getProvider(CredentialProvider.class, f.getId()));
    }

    public CredentialValidationOutput getUserByCredential(RealmModel realm, CredentialInput input) {
        Stream<CredentialAuthentication> credentialAuthenticationStream = this.getEnabledStorageProviders(realm, CredentialAuthentication.class);
        credentialAuthenticationStream = Stream.concat(credentialAuthenticationStream, UserStorageManager.getCredentialProviders(this.session, CredentialAuthentication.class));
        CredentialValidationOutput result = null;
        for (CredentialAuthentication credentialAuthentication2 : credentialAuthenticationStream.filter(credentialAuthentication -> credentialAuthentication.supportsCredentialAuthenticationFor(input.getType())).collect(Collectors.toList())) {
            CredentialValidationOutput.Status status;
            CredentialValidationOutput validationOutput = credentialAuthentication2.authenticate(realm, input);
            if (Objects.nonNull(validationOutput) && ((status = validationOutput.getAuthStatus()) == CredentialValidationOutput.Status.AUTHENTICATED || status == CredentialValidationOutput.Status.CONTINUE || status == CredentialValidationOutput.Status.FAILED)) {
                logger.tracef("Attempt to authenticate credential '%s' with provider '%s' finished with '%s'.", (Object)input.getType(), (Object)credentialAuthentication2, (Object)status);
                if (status == CredentialValidationOutput.Status.AUTHENTICATED) {
                    logger.tracef("Authenticated user is '%s'", (Object)validationOutput.getAuthenticatedUser().getUsername());
                }
                result = validationOutput;
                break;
            }
            logger.tracef("Did not authenticate user by provider '%s' with the credential type '%s'. Will try to fallback to other user storage providers", (Object)credentialAuthentication2, (Object)input.getType());
        }
        return result;
    }

    protected void deleteInvalidUser(RealmModel realm, UserModel user) {
        String userId = user.getId();
        String userName = user.getUsername();
        UserCache userCache = UserStorageUtil.userCache((KeycloakSession)this.session);
        if (userCache != null) {
            userCache.evict(realm, user);
        }
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), session -> {
            RealmModel realmModel = session.realms().getRealm(realm.getId());
            if (realmModel == null) {
                return;
            }
            UserModel deletedUser = UserStoragePrivateUtil.userLocalStorage(session).getUserById(realmModel, userId);
            if (deletedUser != null) {
                try {
                    new UserManager(session).removeUser(realmModel, deletedUser, UserStoragePrivateUtil.userLocalStorage(session));
                    logger.debugf("Removed invalid user '%s'", (Object)userName);
                }
                catch (ModelException ex) {
                    logger.debugf((Throwable)ex, "ModelException thrown during deleteInvalidUser with username '%s'", (Object)userName);
                }
            }
        });
    }

    protected Stream<UserModel> importValidation(RealmModel realm, Stream<UserModel> users) {
        return users.map(user -> this.importValidation(realm, (UserModel)user)).filter(Objects::nonNull);
    }

    protected Stream<UserModel> query(PaginatedQuery pagedQuery, RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.query(pagedQuery, (provider, first, max) -> (int)pagedQuery.query(provider, first, max).count(), realm, firstResult, maxResults);
    }

    protected Stream<UserModel> query(PaginatedQuery pagedQuery, CountQuery countQuery, RealmModel realm, Integer firstResult, Integer maxResults) {
        AtomicInteger currentMax;
        AtomicInteger currentFirst;
        if (maxResults != null && maxResults == 0) {
            return Stream.empty();
        }
        Stream<Object> providersStream = Stream.concat(Stream.of(this.localStorage()), this.getEnabledStorageProviders(realm, UserQueryMethodsProvider.class));
        UserFederatedStorageProvider federatedStorageProvider = this.getFederatedStorage();
        if (federatedStorageProvider != null) {
            providersStream = Stream.concat(providersStream, Stream.of(federatedStorageProvider));
        }
        AtomicBoolean needsAdditionalFirstResultFiltering = new AtomicBoolean(false);
        if (firstResult == null || firstResult <= 0) {
            currentFirst = new AtomicInteger(0);
        } else {
            AtomicBoolean droppingProviders = new AtomicBoolean(true);
            currentFirst = new AtomicInteger(firstResult);
            providersStream = providersStream.filter(provider -> {
                if (!droppingProviders.get()) {
                    return true;
                }
                if (!(provider instanceof UserCountMethodsProvider)) {
                    logger.tracef("We encountered a provider (%s) that does not implement count queries therefore we can't say how many users it can provide.", (Object)provider.getClass().getSimpleName());
                    droppingProviders.set(false);
                    needsAdditionalFirstResultFiltering.set(true);
                    return true;
                }
                long expectedNumberOfUsersForProvider = countQuery.query(provider, 0, currentFirst.get() + 1);
                logger.tracef("This provider (%s) is able to return %d users.", (Object)provider.getClass().getSimpleName(), (Object)expectedNumberOfUsersForProvider);
                if (expectedNumberOfUsersForProvider == (long)currentFirst.get()) {
                    currentFirst.set(0);
                    droppingProviders.set(false);
                    return false;
                }
                if (expectedNumberOfUsersForProvider > (long)currentFirst.get()) {
                    droppingProviders.set(false);
                    return true;
                }
                logger.tracef("This provider (%s) cannot provide enough users to pass firstResult so we are going to filter it out and change firstResult for next provider: %d - %d = %d", new Object[]{provider.getClass().getSimpleName(), currentFirst.get(), expectedNumberOfUsersForProvider, (long)currentFirst.get() - expectedNumberOfUsersForProvider});
                currentFirst.set((int)((long)currentFirst.get() - expectedNumberOfUsersForProvider));
                return false;
            }).collect(Collectors.toList()).stream();
        }
        if (needsAdditionalFirstResultFiltering.get() && currentFirst.get() > 0) {
            logger.tracef("In the providerStream there is a provider that does not support count queries and we need to skip some users.", new Object[0]);
            if (maxResults == null || maxResults < 0) {
                return StreamsUtil.paginatedStream(providersStream.flatMap(provider -> pagedQuery.query(provider, null, null)), (Integer)currentFirst.get(), null);
            }
            currentMax = new AtomicInteger(currentFirst.get() + maxResults);
            return StreamsUtil.paginatedStream(providersStream.flatMap(provider -> pagedQuery.query(provider, null, currentMax.get())).peek(userModel -> currentMax.updateAndGet(i -> i > 0 ? i - 1 : i)), (Integer)currentFirst.get(), (Integer)maxResults);
        }
        if (maxResults == null || maxResults < 0) {
            return providersStream.flatMap(provider -> pagedQuery.query(provider, currentFirst.getAndSet(0), null));
        }
        currentMax = new AtomicInteger(maxResults);
        return providersStream.filter(provider -> currentMax.get() != 0).flatMap(provider -> pagedQuery.query(provider, currentFirst.getAndSet(0), currentMax.get())).peek(userModel -> currentMax.updateAndGet(i -> i > 0 ? i - 1 : i));
    }

    private static Stream<UserModel> removeDuplicates(Stream<UserModel> withDuplicates) {
        return withDuplicates.filter(StreamsUtil.distinctByKey(UserModel::getId));
    }

    public UserModel addUser(RealmModel realm, String username) {
        if (username.startsWith("service-account-")) {
            return this.localStorage().addUser(realm, username);
        }
        return this.getEnabledStorageProviders(realm, UserRegistrationProvider.class).map(provider -> provider.addUser(realm, username)).filter(Objects::nonNull).findFirst().orElseGet(() -> this.localStorage().addUser(realm, username.toLowerCase()));
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        StorageId storageId;
        if (this.getFederatedStorage() != null && user.getServiceAccountClientLink() == null) {
            this.getFederatedStorage().preRemove(realm, user);
        }
        if ((storageId = new StorageId(user.getId())).getProviderId() == null) {
            String federationLink = user.getFederationLink();
            boolean linkRemoved = federationLink == null || Optional.ofNullable((UserRegistrationProvider)this.getStorageProviderInstance(realm, federationLink, UserRegistrationProvider.class)).map(provider -> provider.removeUser(realm, user)).orElse(false) != false;
            return this.localStorage().removeUser(realm, user) && linkRemoved;
        }
        UserRegistrationProvider registry = (UserRegistrationProvider)this.getStorageProviderInstance(realm, storageId.getProviderId(), UserRegistrationProvider.class);
        if (registry == null) {
            throw new ModelException("Could not resolve UserRegistrationProvider: " + storageId.getProviderId());
        }
        return registry.removeUser(realm, user);
    }

    public UserModel getUserById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            UserModel user = this.localStorage().getUserById(realm, id);
            return this.importValidation(realm, user);
        }
        UserLookupProvider provider = (UserLookupProvider)this.getStorageProviderInstance(realm, storageId.getProviderId(), UserLookupProvider.class);
        if (provider == null) {
            return null;
        }
        return provider.getUserById(realm, id);
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        UserModel user = this.localStorage().getUserByUsername(realm, username);
        if (user != null) {
            return this.importValidation(realm, user);
        }
        return this.mapEnabledStorageProvidersWithTimeout(realm, UserLookupProvider.class, provider -> provider.getUserByUsername(realm, username)).findFirst().orElse(null);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        UserModel user = this.localStorage().getUserByEmail(realm, email);
        if (user != null && (user = this.importValidation(realm, user)) != null && email.equalsIgnoreCase(user.getEmail())) {
            return user;
        }
        return this.mapEnabledStorageProvidersWithTimeout(realm, UserLookupProvider.class, provider -> provider.getUserByEmail(realm, email)).findFirst().orElse(null);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query((provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserQueryMethodsProvider) {
                return ((UserQueryMethodsProvider)provider).getGroupMembersStream(realm, group, firstResultInQuery, maxResultsInQuery);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                return ((UserFederatedStorageProvider)provider).getMembershipStream(realm, group, firstResultInQuery, maxResultsInQuery).map(id -> this.getUserById(realm, (String)id));
            }
            return Stream.empty();
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query((provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserQueryMethodsProvider) {
                return ((UserQueryMethodsProvider)provider).getRoleMembersStream(realm, role, firstResultInQuery, maxResultsInQuery);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                return ((UserFederatedStorageProvider)provider).getRoleMembersStream(realm, role, firstResultInQuery, maxResultsInQuery).map(id -> this.getUserById(realm, (String)id));
            }
            return Stream.empty();
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        int localStorageUsersCount = this.localStorage().getUsersCount(realm, includeServiceAccount);
        int storageProvidersUsersCount = this.mapEnabledStorageProvidersWithTimeout(realm, UserCountMethodsProvider.class, userQueryProvider -> userQueryProvider.getUsersCount(realm)).reduce(0, Integer::sum);
        return localStorageUsersCount + storageProvidersUsersCount;
    }

    public int getUsersCount(RealmModel realm) {
        return this.getUsersCount(realm, false);
    }

    public int getUsersCount(RealmModel realm, Set<String> groupIds) {
        return this.localStorage().getUsersCount(realm, groupIds);
    }

    public int getUsersCount(RealmModel realm, String search) {
        return this.localStorage().getUsersCount(realm, search);
    }

    public int getUsersCount(RealmModel realm, String search, Set<String> groupIds) {
        return this.localStorage().getUsersCount(realm, search, groupIds);
    }

    public int getUsersCount(RealmModel realm, Map<String, String> params) {
        return this.localStorage().getUsersCount(realm, params);
    }

    public int getUsersCount(RealmModel realm, Map<String, String> params, Set<String> groupIds) {
        return this.localStorage().getUsersCount(realm, params, groupIds);
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query((provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserQueryMethodsProvider) {
                return ((UserQueryMethodsProvider)provider).searchForUserStream(realm, attributes, firstResultInQuery, maxResultsInQuery);
            }
            return Stream.empty();
        }, (provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserCountMethodsProvider) {
                return ((UserCountMethodsProvider)provider).getUsersCount(realm, attributes);
            }
            return 0;
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        Stream<UserModel> results = this.query((provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserQueryMethodsProvider) {
                return StreamsUtil.paginatedStream((Stream)((UserQueryMethodsProvider)provider).searchForUserByUserAttributeStream(realm, attrName, attrValue), (Integer)firstResultInQuery, (Integer)maxResultsInQuery);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                return StreamsUtil.paginatedStream(((UserFederatedStorageProvider)provider).getUsersByUserAttributeStream(realm, attrName, attrValue).map(id -> this.getUserById(realm, (String)id)).filter(Objects::nonNull), (Integer)firstResultInQuery, (Integer)maxResultsInQuery);
            }
            return Stream.empty();
        }, realm, null, null);
        results = UserStorageManager.removeDuplicates(results);
        return this.importValidation(realm, results);
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        this.localStorage().grantToAllUsers(realm, role);
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserBulkUpdateProvider.class, provider -> provider.grantToAllUsers(realm, role));
    }

    public void preRemove(RealmModel realm) {
        this.localStorage().preRemove(realm);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm);
        }
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserStorageProvider.class, provider -> provider.preRemove(realm));
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.localStorage().preRemove(realm, group);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, group);
        }
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserStorageProvider.class, provider -> provider.preRemove(realm, group));
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.localStorage().preRemove(realm, role);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, role);
        }
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserStorageProvider.class, provider -> provider.preRemove(realm, role));
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        return this.localStorage().addUser(realm, id, username.toLowerCase(), addDefaultRoles, addDefaultRequiredActions);
    }

    public void addFederatedIdentity(final RealmModel realm, final UserModel user, final FederatedIdentityModel socialLink) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            this.localStorage().addFederatedIdentity(realm, user, socialLink);
        } else {
            this.getFederatedStorage().addFederatedIdentity(realm, user.getId(), socialLink);
        }
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new FederatedIdentityModel.FederatedIdentityCreatedEvent(){

            public KeycloakSession getKeycloakSession() {
                return UserStorageManager.this.session;
            }

            public RealmModel getRealm() {
                return realm;
            }

            public UserModel getUser() {
                return user;
            }

            public FederatedIdentityModel getFederatedIdentity() {
                return socialLink;
            }
        });
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        if (StorageId.isLocalStorage((UserModel)federatedUser)) {
            this.localStorage().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
        } else {
            this.getFederatedStorage().updateFederatedIdentity(realm, federatedUser.getId(), federatedIdentityModel);
        }
    }

    public boolean removeFederatedIdentity(final RealmModel realm, final UserModel user, String socialProvider) {
        FederatedIdentityModel federatedIdentityModel;
        if (StorageId.isLocalStorage((UserModel)user)) {
            UserProvider localStorage = this.localStorage();
            federatedIdentityModel = localStorage.getFederatedIdentity(realm, user, socialProvider);
            localStorage.removeFederatedIdentity(realm, user, socialProvider);
        } else {
            UserFederatedStorageProvider federatedStorage = this.getFederatedStorage();
            federatedIdentityModel = federatedStorage.getFederatedIdentity(user.getId(), socialProvider, realm);
            federatedStorage.removeFederatedIdentity(realm, user.getId(), socialProvider);
        }
        if (federatedIdentityModel == null) {
            return false;
        }
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new FederatedIdentityModel.FederatedIdentityRemovedEvent(){

            public KeycloakSession getKeycloakSession() {
                return UserStorageManager.this.session;
            }

            public RealmModel getRealm() {
                return realm;
            }

            public UserModel getUser() {
                return user;
            }

            public FederatedIdentityModel getFederatedIdentity() {
                return federatedIdentityModel;
            }
        });
        return true;
    }

    public void preRemove(RealmModel realm, IdentityProviderModel provider) {
        this.localStorage().preRemove(realm, provider);
        this.getFederatedStorage().preRemove(realm, provider);
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        if (StorageId.isLocalStorage((String)userId)) {
            this.localStorage().addConsent(realm, userId, consent);
        } else {
            this.getFederatedStorage().addConsent(realm, userId, consent);
        }
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().getConsentByClient(realm, userId, clientInternalId);
        }
        return this.getFederatedStorage().getConsentByClient(realm, userId, clientInternalId);
    }

    public Stream<UserConsentModel> getConsentsStream(RealmModel realm, String userId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().getConsentsStream(realm, userId);
        }
        return this.getFederatedStorage().getConsentsStream(realm, userId);
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        if (StorageId.isLocalStorage((String)userId)) {
            this.localStorage().updateConsent(realm, userId, consent);
        } else {
            this.getFederatedStorage().updateConsent(realm, userId, consent);
        }
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().revokeConsentForClient(realm, userId, clientInternalId);
        }
        return this.getFederatedStorage().revokeConsentForClient(realm, userId, clientInternalId);
    }

    public void setNotBeforeForUser(RealmModel realm, UserModel user, int notBefore) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            this.localStorage().setNotBeforeForUser(realm, user, notBefore);
        } else {
            this.getFederatedStorage().setNotBeforeForUser(realm, user.getId(), notBefore);
        }
    }

    public int getNotBeforeOfUser(RealmModel realm, UserModel user) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return this.localStorage().getNotBeforeOfUser(realm, user);
        }
        return this.getFederatedStorage().getNotBeforeOfUser(realm, user.getId());
    }

    public UserModel getUserByFederatedIdentity(RealmModel realm, FederatedIdentityModel socialLink) {
        UserModel user = this.localStorage().getUserByFederatedIdentity(realm, socialLink);
        if (user != null) {
            return this.importValidation(realm, user);
        }
        if (this.getFederatedStorage() == null) {
            return null;
        }
        String id = this.getFederatedStorage().getUserByFederatedIdentity(socialLink, realm);
        if (id != null) {
            return this.getUserById(realm, id);
        }
        return null;
    }

    public UserModel getServiceAccount(ClientModel client) {
        return this.localStorage().getServiceAccount(client);
    }

    public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(RealmModel realm, UserModel user) {
        Stream stream;
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        Stream stream2 = stream = StorageId.isLocalStorage((UserModel)user) ? this.localStorage().getFederatedIdentitiesStream(realm, user) : Stream.empty();
        if (this.getFederatedStorage() != null) {
            stream = Stream.concat(stream, this.getFederatedStorage().getFederatedIdentitiesStream(user.getId(), realm));
        }
        return stream.distinct();
    }

    public FederatedIdentityModel getFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        FederatedIdentityModel model;
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        if (StorageId.isLocalStorage((UserModel)user) && (model = this.localStorage().getFederatedIdentity(realm, user, socialProvider)) != null) {
            return model;
        }
        if (this.getFederatedStorage() != null) {
            return this.getFederatedStorage().getFederatedIdentity(user.getId(), socialProvider, realm);
        }
        return null;
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.localStorage().preRemove(realm, client);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, client);
        }
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.localStorage().preRemove(protocolMapper);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(protocolMapper);
        }
    }

    public void preRemove(ClientScopeModel clientScope) {
        this.localStorage().preRemove(clientScope);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(clientScope);
        }
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        if (component.getProviderType().equals(ClientStorageProvider.class.getName())) {
            this.localStorage().preRemove(realm, component);
            if (this.getFederatedStorage() != null) {
                this.getFederatedStorage().preRemove(realm, component);
            }
            return;
        }
        if (!component.getProviderType().equals(UserStorageProvider.class.getName())) {
            return;
        }
        this.localStorage().preRemove(realm, component);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, component);
        }
        UserStorageSyncManager.notifyToRefreshPeriodicSync(this.session, realm, new UserStorageProviderModel(component), true);
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        this.localStorage().removeImportedUsers(realm, storageProviderId);
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        this.localStorage().unlinkUsers(realm, storageProviderId);
    }

    public void close() {
    }

    public void onCreate(final KeycloakSession session, final RealmModel realm, final ComponentModel model) {
        ComponentFactory factory = ComponentUtil.getComponentFactory((KeycloakSession)session, (ComponentModel)model);
        if (!(factory instanceof UserStorageProviderFactory)) {
            return;
        }
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)new AbstractKeycloakTransaction(){

            protected void commitImpl() {
                UserStorageSyncManager.notifyToRefreshPeriodicSync(session, realm, new UserStorageProviderModel(model), false);
            }

            protected void rollbackImpl() {
            }
        });
    }

    public void onUpdate(KeycloakSession session, RealmModel realm, ComponentModel oldModel, ComponentModel newModel) {
        ComponentFactory factory = ComponentUtil.getComponentFactory((KeycloakSession)session, (ComponentModel)newModel);
        if (!(factory instanceof UserStorageProviderFactory)) {
            return;
        }
        UserStorageProviderModel old = new UserStorageProviderModel(oldModel);
        UserStorageProviderModel newP = new UserStorageProviderModel(newModel);
        if (old.getChangedSyncPeriod() != newP.getChangedSyncPeriod() || old.getFullSyncPeriod() != newP.getFullSyncPeriod() || old.isImportEnabled() != newP.isImportEnabled()) {
            UserStorageSyncManager.notifyToRefreshPeriodicSync(session, realm, new UserStorageProviderModel(newModel), false);
        }
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            if (UserStoragePrivateUtil.userLocalStorage(this.session) instanceof OnUserCache) {
                ((OnUserCache)UserStoragePrivateUtil.userLocalStorage(this.session)).onCache(realm, user, delegate);
            }
        } else {
            OnUserCache provider = (OnUserCache)this.getStorageProviderInstance(realm, StorageId.resolveProviderId((UserModel)user), OnUserCache.class);
            if (provider != null) {
                provider.onCache(realm, user, delegate);
            }
        }
    }

    public void decorateUserProfile(RealmModel realm, UserProfileMetadata metadata) {
        for (UserProfileDecorator decorator : this.getEnabledStorageProviders(this.session.getContext().getRealm(), UserProfileDecorator.class).collect(Collectors.toList())) {
            decorator.decorateUserProfile(realm, metadata);
        }
    }

    @FunctionalInterface
    static interface PaginatedQuery {
        public Stream<UserModel> query(Object var1, Integer var2, Integer var3);
    }

    @FunctionalInterface
    static interface CountQuery {
        public int query(Object var1, Integer var2, Integer var3);
    }
}

