/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.datastore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.deployment.DeployedConfigurationsManager;
import org.keycloak.exportimport.ExportAdapter;
import org.keycloak.exportimport.ExportOptions;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.keys.KeyProvider;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.migrators.MigrateTo8_0_0;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OAuth2DeviceConfig;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.ParConfig;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.models.utils.DefaultKeyProviders;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClaimRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.representations.idm.ComponentExportRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.UserConsentRepresentation;
import org.keycloak.representations.idm.UserFederationMapperRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.ExportImportManager;
import org.keycloak.storage.ImportRealmFromRepresentationEvent;
import org.keycloak.storage.PartialImportRealmFromRepresentationEvent;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.UserStorageUtil;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;
import org.keycloak.validation.ValidationUtil;

public class DefaultExportImportManager
implements ExportImportManager {
    private final KeycloakSession session;
    private static final Logger logger = Logger.getLogger(DefaultExportImportManager.class);

    public DefaultExportImportManager(KeycloakSession session) {
        this.session = session;
    }

    public void exportRealm(RealmModel realm, ExportOptions options, ExportAdapter callback) {
        callback.setType("application/json");
        callback.writeToOutputStream(outputStream -> {
            RealmRepresentation rep = ExportUtils.exportRealm(this.session, realm, options, false);
            StripSecretsUtils.stripSecrets((KeycloakSession)this.session, (Object)rep);
            JsonSerialization.writeValueToStream((OutputStream)outputStream, (Object)rep);
            outputStream.close();
        });
    }

    public RealmModel importRealm(InputStream requestBody) {
        RealmRepresentation rep;
        try {
            rep = (RealmRepresentation)JsonSerialization.readValue((InputStream)requestBody, RealmRepresentation.class);
        }
        catch (IOException e) {
            throw new ModelException("unable to read contents from stream", (Throwable)e);
        }
        logger.debugv("importRealm: {0}", (Object)rep.getRealm());
        return ImportRealmFromRepresentationEvent.fire((KeycloakSession)this.session, (RealmRepresentation)rep);
    }

    /*
     * WARNING - void declaration
     */
    public void importRealm(RealmRepresentation rep, RealmModel newRealm, boolean skipUserDependent) {
        void var7_12;
        DefaultExportImportManager.convertDeprecatedSocialProviders(rep);
        DefaultExportImportManager.convertDeprecatedApplications(this.session, rep);
        DefaultExportImportManager.convertDeprecatedClientTemplates(rep);
        newRealm.setName(rep.getRealm());
        if (rep.getDisplayName() != null) {
            newRealm.setDisplayName(rep.getDisplayName());
        }
        if (rep.getDisplayNameHtml() != null) {
            newRealm.setDisplayNameHtml(rep.getDisplayNameHtml());
        }
        if (rep.isEnabled() != null) {
            newRealm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isUserManagedAccessAllowed() != null) {
            newRealm.setUserManagedAccessAllowed(rep.isUserManagedAccessAllowed().booleanValue());
        }
        if (rep.isBruteForceProtected() != null) {
            newRealm.setBruteForceProtected(rep.isBruteForceProtected().booleanValue());
        }
        if (rep.isPermanentLockout() != null) {
            newRealm.setPermanentLockout(rep.isPermanentLockout().booleanValue());
        }
        if (rep.getMaxTemporaryLockouts() != null) {
            newRealm.setMaxTemporaryLockouts(rep.getMaxTemporaryLockouts().intValue());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            newRealm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds().intValue());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            newRealm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds().intValue());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            newRealm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds().intValue());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            newRealm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds().longValue());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            newRealm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds().intValue());
        }
        if (rep.getFailureFactor() != null) {
            newRealm.setFailureFactor(rep.getFailureFactor().intValue());
        }
        if (rep.isEventsEnabled() != null) {
            newRealm.setEventsEnabled(rep.isEventsEnabled().booleanValue());
        }
        if (rep.getEnabledEventTypes() != null) {
            newRealm.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
        if (rep.getEventsExpiration() != null) {
            newRealm.setEventsExpiration(rep.getEventsExpiration().longValue());
        }
        if (rep.getEventsListeners() != null) {
            newRealm.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.isAdminEventsEnabled() != null) {
            newRealm.setAdminEventsEnabled(rep.isAdminEventsEnabled().booleanValue());
        }
        if (rep.isAdminEventsDetailsEnabled() != null) {
            newRealm.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled().booleanValue());
        }
        if (rep.getNotBefore() != null) {
            newRealm.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getDefaultSignatureAlgorithm() != null) {
            newRealm.setDefaultSignatureAlgorithm(rep.getDefaultSignatureAlgorithm());
        } else {
            newRealm.setDefaultSignatureAlgorithm("RS256");
        }
        if (rep.getRevokeRefreshToken() != null) {
            newRealm.setRevokeRefreshToken(rep.getRevokeRefreshToken().booleanValue());
        } else {
            newRealm.setRevokeRefreshToken(false);
        }
        if (rep.getRefreshTokenMaxReuse() != null) {
            newRealm.setRefreshTokenMaxReuse(rep.getRefreshTokenMaxReuse().intValue());
        } else {
            newRealm.setRefreshTokenMaxReuse(0);
        }
        if (rep.getAccessTokenLifespan() != null) {
            newRealm.setAccessTokenLifespan(rep.getAccessTokenLifespan().intValue());
        } else {
            newRealm.setAccessTokenLifespan(300);
        }
        if (rep.getAccessTokenLifespanForImplicitFlow() != null) {
            newRealm.setAccessTokenLifespanForImplicitFlow(rep.getAccessTokenLifespanForImplicitFlow().intValue());
        } else {
            newRealm.setAccessTokenLifespanForImplicitFlow(900);
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            newRealm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout().intValue());
        } else {
            newRealm.setSsoSessionIdleTimeout(1800);
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            newRealm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan().intValue());
        } else {
            newRealm.setSsoSessionMaxLifespan(36000);
        }
        if (rep.getSsoSessionMaxLifespanRememberMe() != null) {
            newRealm.setSsoSessionMaxLifespanRememberMe(rep.getSsoSessionMaxLifespanRememberMe().intValue());
        }
        if (rep.getSsoSessionIdleTimeoutRememberMe() != null) {
            newRealm.setSsoSessionIdleTimeoutRememberMe(rep.getSsoSessionIdleTimeoutRememberMe().intValue());
        }
        if (rep.getOfflineSessionIdleTimeout() != null) {
            newRealm.setOfflineSessionIdleTimeout(rep.getOfflineSessionIdleTimeout().intValue());
        } else {
            newRealm.setOfflineSessionIdleTimeout(2592000);
        }
        if (rep.getOfflineSessionMaxLifespanEnabled() != null) {
            newRealm.setOfflineSessionMaxLifespanEnabled(rep.getOfflineSessionMaxLifespanEnabled().booleanValue());
        } else {
            newRealm.setOfflineSessionMaxLifespanEnabled(false);
        }
        if (rep.getOfflineSessionMaxLifespan() != null) {
            newRealm.setOfflineSessionMaxLifespan(rep.getOfflineSessionMaxLifespan().intValue());
        } else {
            newRealm.setOfflineSessionMaxLifespan(5184000);
        }
        if (rep.getClientSessionIdleTimeout() != null) {
            newRealm.setClientSessionIdleTimeout(rep.getClientSessionIdleTimeout().intValue());
        }
        if (rep.getClientSessionMaxLifespan() != null) {
            newRealm.setClientSessionMaxLifespan(rep.getClientSessionMaxLifespan().intValue());
        }
        if (rep.getClientOfflineSessionIdleTimeout() != null) {
            newRealm.setClientOfflineSessionIdleTimeout(rep.getClientOfflineSessionIdleTimeout().intValue());
        }
        if (rep.getClientOfflineSessionMaxLifespan() != null) {
            newRealm.setClientOfflineSessionMaxLifespan(rep.getClientOfflineSessionMaxLifespan().intValue());
        }
        if (rep.getAccessCodeLifespan() != null) {
            newRealm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        } else {
            newRealm.setAccessCodeLifespan(60);
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            newRealm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        } else {
            newRealm.setAccessCodeLifespanUserAction(300);
        }
        if (rep.getAccessCodeLifespanLogin() != null) {
            newRealm.setAccessCodeLifespanLogin(rep.getAccessCodeLifespanLogin().intValue());
        } else {
            newRealm.setAccessCodeLifespanLogin(1800);
        }
        if (rep.getActionTokenGeneratedByAdminLifespan() != null) {
            newRealm.setActionTokenGeneratedByAdminLifespan(rep.getActionTokenGeneratedByAdminLifespan().intValue());
        } else {
            newRealm.setActionTokenGeneratedByAdminLifespan(43200);
        }
        if (rep.getActionTokenGeneratedByUserLifespan() != null) {
            newRealm.setActionTokenGeneratedByUserLifespan(rep.getActionTokenGeneratedByUserLifespan().intValue());
        } else {
            newRealm.setActionTokenGeneratedByUserLifespan(newRealm.getAccessCodeLifespanUserAction());
        }
        OAuth2DeviceConfig deviceConfig = newRealm.getOAuth2DeviceConfig();
        deviceConfig.setOAuth2DeviceCodeLifespan(newRealm, rep.getOAuth2DeviceCodeLifespan());
        deviceConfig.setOAuth2DevicePollingInterval(newRealm, rep.getOAuth2DevicePollingInterval());
        if (rep.getSslRequired() != null) {
            newRealm.setSslRequired(SslRequired.valueOf((String)rep.getSslRequired().toUpperCase()));
        }
        if (rep.isRegistrationAllowed() != null) {
            newRealm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isRegistrationEmailAsUsername() != null) {
            newRealm.setRegistrationEmailAsUsername(rep.isRegistrationEmailAsUsername().booleanValue());
        }
        if (rep.isRememberMe() != null) {
            newRealm.setRememberMe(rep.isRememberMe().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            newRealm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isLoginWithEmailAllowed() != null) {
            newRealm.setLoginWithEmailAllowed(rep.isLoginWithEmailAllowed().booleanValue());
        }
        if (rep.isDuplicateEmailsAllowed() != null) {
            newRealm.setDuplicateEmailsAllowed(rep.isDuplicateEmailsAllowed().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            newRealm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isEditUsernameAllowed() != null) {
            newRealm.setEditUsernameAllowed(rep.isEditUsernameAllowed().booleanValue());
        }
        if (rep.isOrganizationsEnabled() != null) {
            newRealm.setOrganizationsEnabled(rep.isOrganizationsEnabled().booleanValue());
        }
        if (rep.getLoginTheme() != null) {
            newRealm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            newRealm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            newRealm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            newRealm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.getLocalizationTexts() != null) {
            Map localizationTexts = rep.getLocalizationTexts();
            for (Map.Entry entry : localizationTexts.entrySet()) {
                newRealm.createOrUpdateRealmLocalizationTexts((String)entry.getKey(), (Map)entry.getValue());
            }
        }
        if (rep.getRequiredCredentials() != null) {
            for (String requiredCred : rep.getRequiredCredentials()) {
                newRealm.addRequiredCredential(requiredCred);
            }
        } else {
            newRealm.addRequiredCredential("password");
        }
        if (rep.getPasswordPolicy() != null) {
            newRealm.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)this.session, (String)rep.getPasswordPolicy()));
        }
        if (rep.getOtpPolicyType() != null) {
            newRealm.setOTPPolicy(DefaultExportImportManager.toPolicy(rep));
        } else {
            newRealm.setOTPPolicy(OTPPolicy.DEFAULT_POLICY);
        }
        WebAuthnPolicy webAuthnPolicy = DefaultExportImportManager.getWebAuthnPolicyTwoFactor(rep);
        newRealm.setWebAuthnPolicy(webAuthnPolicy);
        webAuthnPolicy = DefaultExportImportManager.getWebAuthnPolicyPasswordless(rep);
        newRealm.setWebAuthnPolicyPasswordless(webAuthnPolicy);
        DefaultExportImportManager.updateCibaSettings(rep, newRealm);
        DefaultExportImportManager.updateParSettings(rep, newRealm);
        Map<String, String> mappedFlows = DefaultExportImportManager.importAuthenticationFlows(this.session, newRealm, rep);
        if (rep.getRequiredActions() != null) {
            for (Object action : rep.getRequiredActions()) {
                RequiredActionProviderModel model = DefaultExportImportManager.toModel((RequiredActionProviderRepresentation)action);
                MigrationUtils.updateOTPRequiredAction((RequiredActionProviderModel)model);
                newRealm.addRequiredActionProvider(model);
            }
            DefaultRequiredActions.addDeleteAccountAction((RealmModel)newRealm);
        } else {
            DefaultRequiredActions.addActions((RealmModel)newRealm);
        }
        DefaultExportImportManager.importIdentityProviders(rep, newRealm, this.session);
        DefaultExportImportManager.importIdentityProviderMappers(rep, newRealm);
        HashMap hashMap = new HashMap();
        if (rep.getClientScopes() != null) {
            Map<String, ClientScopeModel> map = DefaultExportImportManager.createClientScopes(this.session, rep.getClientScopes(), newRealm);
        }
        if (rep.getDefaultDefaultClientScopes() != null) {
            for (Object clientScopeName : rep.getDefaultDefaultClientScopes()) {
                ClientScopeModel clientScopeModel = (ClientScopeModel)var7_12.get(clientScopeName);
                if (clientScopeModel != null) {
                    newRealm.addDefaultClientScope(clientScopeModel, true);
                    continue;
                }
                logger.warnf("Referenced client scope '%s' doesn't exist", clientScopeName);
            }
        }
        if (rep.getDefaultOptionalClientScopes() != null) {
            for (Object clientScopeName : rep.getDefaultOptionalClientScopes()) {
                ClientScopeModel clientScopeModel = (ClientScopeModel)var7_12.get(clientScopeName);
                if (clientScopeModel != null) {
                    newRealm.addDefaultClientScope(clientScopeModel, false);
                    continue;
                }
                logger.warnf("Referenced client scope '%s' doesn't exist", clientScopeName);
            }
        }
        Map<Object, Object> createdClients = new HashMap();
        if (rep.getClients() != null) {
            createdClients = DefaultExportImportManager.createClients(this.session, rep, newRealm, mappedFlows);
        }
        RepresentationToModel.importRoles((RolesRepresentation)rep.getRoles(), (RealmModel)newRealm);
        DefaultExportImportManager.convertDeprecatedDefaultRoles(rep, newRealm);
        if (rep.getClientScopeMappings() != null) {
            for (Map.Entry entry : rep.getClientScopeMappings().entrySet()) {
                ClientModel app = createdClients.computeIfAbsent((String)entry.getKey(), k -> newRealm.getClientByClientId((String)entry.getKey()));
                if (app == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                DefaultExportImportManager.createClientScopeMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getScopeMappings() != null) {
            Map roleModelMap = newRealm.getRolesStream().collect(Collectors.toMap(RoleModel::getId, Function.identity()));
            for (ScopeMappingRepresentation scope : rep.getScopeMappings()) {
                ScopeContainerModel scopeContainer = DefaultExportImportManager.getScopeContainerHavingScope(newRealm, scope);
                for (String roleString : scope.getRoles()) {
                    String roleStringTrimmed = roleString.trim();
                    RoleModel role = roleModelMap.computeIfAbsent(roleStringTrimmed, k -> newRealm.getRole(roleStringTrimmed));
                    if (role == null) {
                        role = newRealm.addRole(roleString);
                        roleModelMap.put(role.getId(), role);
                    }
                    scopeContainer.addScopeMapping(role);
                }
            }
        }
        if (rep.getSmtpServer() != null) {
            newRealm.setSmtpConfig(new HashMap(rep.getSmtpServer()));
        }
        if (rep.getBrowserSecurityHeaders() != null) {
            newRealm.setBrowserSecurityHeaders(rep.getBrowserSecurityHeaders());
        } else {
            newRealm.setBrowserSecurityHeaders(BrowserSecurityHeaders.realmDefaultHeaders);
        }
        if (rep.getComponents() != null) {
            MultivaluedHashMap components = rep.getComponents();
            String string = newRealm.getId();
            DefaultExportImportManager.importComponents(newRealm, (MultivaluedHashMap<String, ComponentExportRepresentation>)components, string);
        }
        DefaultExportImportManager.importUserFederationProvidersAndMappers(this.session, rep, newRealm);
        if (rep.getGroups() != null) {
            DefaultExportImportManager.importGroups(newRealm, rep);
            if (rep.getDefaultGroups() != null) {
                KeycloakModelUtils.setDefaultGroups((KeycloakSession)this.session, (RealmModel)newRealm, rep.getDefaultGroups().stream());
            }
        }
        if (rep.getUsers() != null) {
            for (UserRepresentation userRepresentation : rep.getUsers()) {
                this.createUser(newRealm, userRepresentation);
            }
        }
        if (rep.getFederatedUsers() != null) {
            for (UserRepresentation userRepresentation : rep.getFederatedUsers()) {
                DefaultExportImportManager.importFederatedUser(this.session, newRealm, userRepresentation);
            }
        }
        if (!skipUserDependent) {
            DefaultExportImportManager.importRealmAuthorizationSettings(rep, newRealm, this.session);
        }
        if (rep.isInternationalizationEnabled() != null) {
            newRealm.setInternationalizationEnabled(rep.isInternationalizationEnabled().booleanValue());
        }
        if (rep.getSupportedLocales() != null) {
            newRealm.setSupportedLocales(new HashSet(rep.getSupportedLocales()));
        }
        if (rep.getDefaultLocale() != null) {
            newRealm.setDefaultLocale(rep.getDefaultLocale());
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                newRealm.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (newRealm.getComponentsStream(newRealm.getId(), KeyProvider.class.getName()).count() == 0L) {
            if (rep.getPrivateKey() != null) {
                DefaultKeyProviders.createProviders((RealmModel)newRealm, (String)rep.getPrivateKey(), (String)rep.getCertificate());
            } else {
                DefaultKeyProviders.createProviders((RealmModel)newRealm);
            }
        }
        this.importOrganizations(rep, newRealm);
    }

    public PartialImportResults partialImportRealm(RealmModel realm, InputStream requestBody) {
        PartialImportRepresentation rep;
        try {
            rep = (PartialImportRepresentation)JsonSerialization.readValue((InputStream)requestBody, PartialImportRepresentation.class);
        }
        catch (IOException e) {
            throw new ModelException("unable to read contents from stream", (Throwable)e);
        }
        return PartialImportRealmFromRepresentationEvent.fire((KeycloakSession)this.session, (PartialImportRepresentation)rep, (RealmModel)realm);
    }

    private static RoleModel getOrAddRealmRole(RealmModel realm, String name) {
        RoleModel role = realm.getRole(name);
        if (role == null) {
            role = realm.addRole(name);
        }
        return role;
    }

    private static void convertDeprecatedDefaultRoles(RealmRepresentation rep, RealmModel newRealm) {
        if (rep.getDefaultRole() == null) {
            if (rep.getDefaultRoles() != null) {
                rep.getDefaultRoles().stream().map(String::trim).map(name -> DefaultExportImportManager.getOrAddRealmRole(newRealm, name)).forEach(role -> newRealm.getDefaultRole().addCompositeRole(role));
            }
            if (rep.getClients() != null) {
                for (ClientRepresentation clientRep : rep.getClients()) {
                    if (clientRep.getDefaultRoles() == null) continue;
                    Arrays.stream(clientRep.getDefaultRoles()).map(String::trim).map(name -> DefaultExportImportManager.getOrAddClientRole(newRealm.getClientById(clientRep.getId()), name)).forEach(role -> newRealm.getDefaultRole().addCompositeRole(role));
                }
            }
        }
    }

    private static RoleModel getOrAddClientRole(ClientModel client, String name) {
        RoleModel role = client.getRole(name);
        if (role == null) {
            role = client.addRole(name);
        }
        return role;
    }

    private static Map<String, ClientModel> createClients(KeycloakSession session, RealmRepresentation rep, RealmModel realm, Map<String, String> mappedFlows) {
        HashMap<String, ClientModel> appMap = new HashMap<String, ClientModel>();
        for (ClientRepresentation resourceRep : rep.getClients()) {
            ClientModel app = RepresentationToModel.createClient((KeycloakSession)session, (RealmModel)realm, (ClientRepresentation)resourceRep, mappedFlows);
            String postLogoutRedirectUris = app.getAttribute("post.logout.redirect.uris");
            if (postLogoutRedirectUris == null) {
                app.setAttribute("post.logout.redirect.uris", "+");
            }
            appMap.put(app.getClientId(), app);
            ValidationUtil.validateClient((KeycloakSession)session, (ClientModel)app, (boolean)false, r -> {
                throw new RuntimeException("Invalid client " + app.getClientId() + ": " + r.getAllErrorsAsString());
            });
        }
        return appMap;
    }

    private static Map<String, ClientScopeModel> createClientScopes(KeycloakSession session, List<ClientScopeRepresentation> clientScopes, RealmModel realm) {
        HashMap<String, ClientScopeModel> appMap = new HashMap<String, ClientScopeModel>();
        for (ClientScopeRepresentation resourceRep : clientScopes) {
            ClientScopeModel app = RepresentationToModel.createClientScope((KeycloakSession)session, (RealmModel)realm, (ClientScopeRepresentation)resourceRep);
            appMap.put(app.getName(), app);
        }
        return appMap;
    }

    private static void importIdentityProviders(RealmRepresentation rep, RealmModel newRealm, KeycloakSession session) {
        if (rep.getIdentityProviders() != null) {
            for (IdentityProviderRepresentation representation : rep.getIdentityProviders()) {
                newRealm.addIdentityProvider(RepresentationToModel.toModel((RealmModel)newRealm, (IdentityProviderRepresentation)representation, (KeycloakSession)session));
            }
        }
    }

    private static void importIdentityProviderMappers(RealmRepresentation rep, RealmModel newRealm) {
        if (rep.getIdentityProviderMappers() != null) {
            for (IdentityProviderMapperRepresentation representation : rep.getIdentityProviderMappers()) {
                newRealm.addIdentityProviderMapper(RepresentationToModel.toModel((IdentityProviderMapperRepresentation)representation));
            }
        }
    }

    public static long getClaimsMask(ClaimRepresentation rep) {
        long mask = 1023L;
        mask = rep.getAddress() ? (mask |= 0x100L) : (mask &= 0xFFFFFFFFFFFFFEFFL);
        mask = rep.getEmail() ? (mask |= 0x20L) : (mask &= 0xFFFFFFFFFFFFFFDFL);
        mask = rep.getGender() ? (mask |= 0x40L) : (mask &= 0xFFFFFFFFFFFFFFBFL);
        mask = rep.getLocale() ? (mask |= 0x80L) : (mask &= 0xFFFFFFFFFFFFFF7FL);
        mask = rep.getName() ? (mask |= 1L) : (mask &= 0xFFFFFFFFFFFFFFFEL);
        mask = rep.getPhone() ? (mask |= 0x200L) : (mask &= 0xFFFFFFFFFFFFFDFFL);
        mask = rep.getPicture() ? (mask |= 8L) : (mask &= 0xFFFFFFFFFFFFFFF7L);
        mask = rep.getProfile() ? (mask |= 4L) : (mask &= 0xFFFFFFFFFFFFFFFBL);
        mask = rep.getUsername() ? (mask |= 2L) : (mask &= 0xFFFFFFFFFFFFFFFDL);
        mask = rep.getWebsite() ? (mask |= 0x10L) : (mask &= 0xFFFFFFFFFFFFFFEFL);
        return mask;
    }

    public static void createClientScopeMappings(RealmModel realm, ClientModel clientModel, List<ScopeMappingRepresentation> mappings) {
        for (ScopeMappingRepresentation mapping : mappings) {
            ScopeContainerModel scopeContainer = DefaultExportImportManager.getScopeContainerHavingScope(realm, mapping);
            for (String roleString : mapping.getRoles()) {
                RoleModel role = clientModel.getRole(roleString.trim());
                if (role == null) {
                    role = clientModel.addRole(roleString.trim());
                }
                scopeContainer.addScopeMapping(role);
            }
        }
    }

    private static ScopeContainerModel getScopeContainerHavingScope(RealmModel realm, ScopeMappingRepresentation scope) {
        if (scope.getClient() != null) {
            ClientModel client = realm.getClientByClientId(scope.getClient());
            if (client == null) {
                throw new RuntimeException("Unknown client specification in scope mappings: " + scope.getClient());
            }
            return client;
        }
        if (scope.getClientScope() != null) {
            ClientScopeModel clientScope = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)scope.getClientScope());
            if (clientScope == null) {
                throw new RuntimeException("Unknown clientScope specification in scope mappings: " + scope.getClientScope());
            }
            return clientScope;
        }
        if (scope.getClientTemplate() != null) {
            String templateName = KeycloakModelUtils.convertClientScopeName((String)scope.getClientTemplate());
            ClientScopeModel clientTemplate = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)templateName);
            if (clientTemplate == null) {
                throw new RuntimeException("Unknown clientScope specification in scope mappings: " + templateName);
            }
            return clientTemplate;
        }
        throw new RuntimeException("Either client or clientScope needs to be specified in scope mappings");
    }

    public static void renameRealm(RealmModel realm, String name) {
        ClientModel accountConsoleClient;
        ClientModel accountClient;
        if (name.equals(realm.getName())) {
            return;
        }
        if (StringUtil.isBlank((String)name)) {
            throw new ModelException("Realm name cannot be empty");
        }
        String oldName = realm.getName();
        ClientModel masterApp = realm.getMasterAdminClient();
        masterApp.setClientId(KeycloakModelUtils.getMasterRealmAdminApplicationClientId((String)name));
        realm.setName(name);
        ClientModel adminClient = realm.getClientByClientId("security-admin-console");
        if (adminClient != null) {
            if (adminClient.getBaseUrl() != null) {
                adminClient.setBaseUrl(adminClient.getBaseUrl().replace("/admin/" + oldName + "/", "/admin/" + name + "/"));
            }
            HashSet<String> adminRedirectUris = new HashSet<String>();
            for (Object r : adminClient.getRedirectUris()) {
                adminRedirectUris.add(DefaultExportImportManager.replace((String)r, "/admin/" + oldName + "/", "/admin/" + name + "/"));
            }
            adminClient.setRedirectUris(adminRedirectUris);
        }
        if ((accountClient = realm.getClientByClientId("account")) != null) {
            if (accountClient.getBaseUrl() != null) {
                accountClient.setBaseUrl(accountClient.getBaseUrl().replace("/realms/" + oldName + "/", "/realms/" + name + "/"));
            }
            HashSet<String> accountRedirectUris = new HashSet<String>();
            for (String r : accountClient.getRedirectUris()) {
                accountRedirectUris.add(DefaultExportImportManager.replace(r, "/realms/" + oldName + "/", "/realms/" + name + "/"));
            }
            accountClient.setRedirectUris(accountRedirectUris);
        }
        if ((accountConsoleClient = realm.getClientByClientId("account-console")) != null) {
            if (accountConsoleClient.getBaseUrl() != null) {
                accountConsoleClient.setBaseUrl(accountConsoleClient.getBaseUrl().replace("/realms/" + oldName + "/", "/realms/" + name + "/"));
            }
            HashSet<String> accountConsoleRedirectUris = new HashSet<String>();
            for (String r : accountConsoleClient.getRedirectUris()) {
                accountConsoleRedirectUris.add(DefaultExportImportManager.replace(r, "/realms/" + oldName + "/", "/realms/" + name + "/"));
            }
            accountConsoleClient.setRedirectUris(accountConsoleRedirectUris);
        }
    }

    private static String replace(String url, String target, String replacement) {
        return url != null ? url.replace(target, replacement) : null;
    }

    public void updateRealm(RealmRepresentation rep, RealmModel realm) {
        WebAuthnPolicy webAuthnPolicy;
        if (rep.getRealm() != null) {
            DefaultExportImportManager.renameRealm(realm, rep.getRealm());
        }
        if (rep.getAttributes() != null) {
            HashSet attrsToRemove = new HashSet(realm.getAttributes().keySet());
            attrsToRemove.removeAll(rep.getAttributes().keySet());
            attrsToRemove.removeAll(ModelToRepresentation.REALM_EXCLUDED_ATTRIBUTES);
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                realm.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            for (String attr : attrsToRemove) {
                realm.removeAttribute(attr);
            }
        }
        if (rep.getDefaultGroups() != null) {
            KeycloakModelUtils.setDefaultGroups((KeycloakSession)this.session, (RealmModel)realm, rep.getDefaultGroups().stream());
        }
        if (rep.getDisplayName() != null) {
            realm.setDisplayName(rep.getDisplayName());
        }
        if (rep.getDisplayNameHtml() != null) {
            realm.setDisplayNameHtml(rep.getDisplayNameHtml());
        }
        if (rep.isEnabled() != null) {
            realm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isUserManagedAccessAllowed() != null) {
            realm.setUserManagedAccessAllowed(rep.isUserManagedAccessAllowed().booleanValue());
        }
        if (rep.isBruteForceProtected() != null) {
            realm.setBruteForceProtected(rep.isBruteForceProtected().booleanValue());
        }
        if (rep.isPermanentLockout() != null) {
            realm.setPermanentLockout(rep.isPermanentLockout().booleanValue());
        }
        if (rep.getMaxTemporaryLockouts() != null) {
            realm.setMaxTemporaryLockouts(rep.getMaxTemporaryLockouts().intValue());
        }
        if (rep.getMaxFailureWaitSeconds() != null) {
            realm.setMaxFailureWaitSeconds(rep.getMaxFailureWaitSeconds().intValue());
        }
        if (rep.getMinimumQuickLoginWaitSeconds() != null) {
            realm.setMinimumQuickLoginWaitSeconds(rep.getMinimumQuickLoginWaitSeconds().intValue());
        }
        if (rep.getWaitIncrementSeconds() != null) {
            realm.setWaitIncrementSeconds(rep.getWaitIncrementSeconds().intValue());
        }
        if (rep.getQuickLoginCheckMilliSeconds() != null) {
            realm.setQuickLoginCheckMilliSeconds(rep.getQuickLoginCheckMilliSeconds().longValue());
        }
        if (rep.getMaxDeltaTimeSeconds() != null) {
            realm.setMaxDeltaTimeSeconds(rep.getMaxDeltaTimeSeconds().intValue());
        }
        if (rep.getFailureFactor() != null) {
            realm.setFailureFactor(rep.getFailureFactor().intValue());
        }
        if (rep.isRegistrationAllowed() != null) {
            realm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isRegistrationEmailAsUsername() != null) {
            realm.setRegistrationEmailAsUsername(rep.isRegistrationEmailAsUsername().booleanValue());
        }
        if (rep.isRememberMe() != null) {
            realm.setRememberMe(rep.isRememberMe().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            realm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isLoginWithEmailAllowed() != null) {
            realm.setLoginWithEmailAllowed(rep.isLoginWithEmailAllowed().booleanValue());
        }
        if (rep.isDuplicateEmailsAllowed() != null) {
            realm.setDuplicateEmailsAllowed(rep.isDuplicateEmailsAllowed().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            realm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isEditUsernameAllowed() != null) {
            realm.setEditUsernameAllowed(rep.isEditUsernameAllowed().booleanValue());
        }
        if (rep.isOrganizationsEnabled() != null) {
            realm.setOrganizationsEnabled(rep.isOrganizationsEnabled().booleanValue());
        }
        if (rep.getSslRequired() != null) {
            realm.setSslRequired(SslRequired.valueOf((String)rep.getSslRequired().toUpperCase()));
        }
        if (rep.getAccessCodeLifespan() != null) {
            realm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            realm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        }
        if (rep.getAccessCodeLifespanLogin() != null) {
            realm.setAccessCodeLifespanLogin(rep.getAccessCodeLifespanLogin().intValue());
        }
        if (rep.getActionTokenGeneratedByAdminLifespan() != null) {
            realm.setActionTokenGeneratedByAdminLifespan(rep.getActionTokenGeneratedByAdminLifespan().intValue());
        }
        if (rep.getActionTokenGeneratedByUserLifespan() != null) {
            realm.setActionTokenGeneratedByUserLifespan(rep.getActionTokenGeneratedByUserLifespan().intValue());
        }
        OAuth2DeviceConfig deviceConfig = realm.getOAuth2DeviceConfig();
        deviceConfig.setOAuth2DeviceCodeLifespan(realm, rep.getOAuth2DeviceCodeLifespan());
        deviceConfig.setOAuth2DevicePollingInterval(realm, rep.getOAuth2DevicePollingInterval());
        if (rep.getNotBefore() != null) {
            realm.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getDefaultSignatureAlgorithm() != null) {
            realm.setDefaultSignatureAlgorithm(rep.getDefaultSignatureAlgorithm());
        }
        if (rep.getRevokeRefreshToken() != null) {
            realm.setRevokeRefreshToken(rep.getRevokeRefreshToken().booleanValue());
        }
        if (rep.getRefreshTokenMaxReuse() != null) {
            realm.setRefreshTokenMaxReuse(rep.getRefreshTokenMaxReuse().intValue());
        }
        if (rep.getAccessTokenLifespan() != null) {
            realm.setAccessTokenLifespan(rep.getAccessTokenLifespan().intValue());
        }
        if (rep.getAccessTokenLifespanForImplicitFlow() != null) {
            realm.setAccessTokenLifespanForImplicitFlow(rep.getAccessTokenLifespanForImplicitFlow().intValue());
        }
        if (rep.getSsoSessionIdleTimeout() != null) {
            realm.setSsoSessionIdleTimeout(rep.getSsoSessionIdleTimeout().intValue());
        }
        if (rep.getSsoSessionMaxLifespan() != null) {
            realm.setSsoSessionMaxLifespan(rep.getSsoSessionMaxLifespan().intValue());
        }
        if (rep.getSsoSessionIdleTimeoutRememberMe() != null) {
            realm.setSsoSessionIdleTimeoutRememberMe(rep.getSsoSessionIdleTimeoutRememberMe().intValue());
        }
        if (rep.getSsoSessionMaxLifespanRememberMe() != null) {
            realm.setSsoSessionMaxLifespanRememberMe(rep.getSsoSessionMaxLifespanRememberMe().intValue());
        }
        if (rep.getOfflineSessionIdleTimeout() != null) {
            realm.setOfflineSessionIdleTimeout(rep.getOfflineSessionIdleTimeout().intValue());
        }
        if (rep.getOfflineSessionMaxLifespanEnabled() != null) {
            realm.setOfflineSessionMaxLifespanEnabled(rep.getOfflineSessionMaxLifespanEnabled().booleanValue());
        }
        if (rep.getOfflineSessionMaxLifespan() != null) {
            realm.setOfflineSessionMaxLifespan(rep.getOfflineSessionMaxLifespan().intValue());
        }
        if (rep.getClientSessionIdleTimeout() != null) {
            realm.setClientSessionIdleTimeout(rep.getClientSessionIdleTimeout().intValue());
        }
        if (rep.getClientSessionMaxLifespan() != null) {
            realm.setClientSessionMaxLifespan(rep.getClientSessionMaxLifespan().intValue());
        }
        if (rep.getClientOfflineSessionIdleTimeout() != null) {
            realm.setClientOfflineSessionIdleTimeout(rep.getClientOfflineSessionIdleTimeout().intValue());
        }
        if (rep.getClientOfflineSessionMaxLifespan() != null) {
            realm.setClientOfflineSessionMaxLifespan(rep.getClientOfflineSessionMaxLifespan().intValue());
        }
        if (rep.getRequiredCredentials() != null) {
            realm.updateRequiredCredentials(rep.getRequiredCredentials());
        }
        if (rep.getLoginTheme() != null) {
            realm.setLoginTheme(rep.getLoginTheme());
        }
        if (rep.getAccountTheme() != null) {
            realm.setAccountTheme(rep.getAccountTheme());
        }
        if (rep.getAdminTheme() != null) {
            realm.setAdminTheme(rep.getAdminTheme());
        }
        if (rep.getEmailTheme() != null) {
            realm.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.isEventsEnabled() != null) {
            realm.setEventsEnabled(rep.isEventsEnabled().booleanValue());
        }
        if (rep.getEventsExpiration() != null) {
            realm.setEventsExpiration(rep.getEventsExpiration().longValue());
        }
        if (rep.getEventsListeners() != null) {
            realm.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.getEnabledEventTypes() != null) {
            realm.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
        if (rep.isAdminEventsEnabled() != null) {
            realm.setAdminEventsEnabled(rep.isAdminEventsEnabled().booleanValue());
        }
        if (rep.isAdminEventsDetailsEnabled() != null) {
            realm.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled().booleanValue());
        }
        if (rep.getPasswordPolicy() != null) {
            realm.setPasswordPolicy(PasswordPolicy.parse((KeycloakSession)this.session, (String)rep.getPasswordPolicy()));
        }
        if (rep.getOtpPolicyType() != null) {
            realm.setOTPPolicy(DefaultExportImportManager.toPolicy(rep));
        }
        if (rep.getWebAuthnPolicyRpEntityName() != null && !rep.getWebAuthnPolicyRpEntityName().isEmpty()) {
            webAuthnPolicy = DefaultExportImportManager.getWebAuthnPolicyTwoFactor(rep);
            realm.setWebAuthnPolicy(webAuthnPolicy);
        }
        if (rep.getWebAuthnPolicyPasswordlessRpEntityName() != null && !rep.getWebAuthnPolicyPasswordlessRpEntityName().isEmpty()) {
            webAuthnPolicy = DefaultExportImportManager.getWebAuthnPolicyPasswordless(rep);
            realm.setWebAuthnPolicyPasswordless(webAuthnPolicy);
        }
        DefaultExportImportManager.updateCibaSettings(rep, realm);
        DefaultExportImportManager.updateParSettings(rep, realm);
        this.session.clientPolicy().updateRealmModelFromRepresentation(realm, rep);
        if (rep.getSmtpServer() != null) {
            HashMap<String, String> config = new HashMap<String, String>(rep.getSmtpServer());
            if (rep.getSmtpServer().containsKey("password") && "**********".equals(rep.getSmtpServer().get("password"))) {
                String passwordValue = realm.getSmtpConfig() != null ? (String)realm.getSmtpConfig().get("password") : null;
                config.put("password", passwordValue);
            }
            realm.setSmtpConfig(config);
        }
        if (rep.getBrowserSecurityHeaders() != null) {
            realm.setBrowserSecurityHeaders(rep.getBrowserSecurityHeaders());
        }
        if (rep.isInternationalizationEnabled() != null) {
            realm.setInternationalizationEnabled(rep.isInternationalizationEnabled().booleanValue());
        }
        if (rep.getSupportedLocales() != null) {
            realm.setSupportedLocales(new HashSet(rep.getSupportedLocales()));
        }
        if (rep.getDefaultLocale() != null) {
            realm.setDefaultLocale(rep.getDefaultLocale());
        }
        if (rep.getBrowserFlow() != null) {
            realm.setBrowserFlow(realm.getFlowByAlias(rep.getBrowserFlow()));
        }
        if (rep.getRegistrationFlow() != null) {
            realm.setRegistrationFlow(realm.getFlowByAlias(rep.getRegistrationFlow()));
        }
        if (rep.getDirectGrantFlow() != null) {
            realm.setDirectGrantFlow(realm.getFlowByAlias(rep.getDirectGrantFlow()));
        }
        if (rep.getResetCredentialsFlow() != null) {
            realm.setResetCredentialsFlow(realm.getFlowByAlias(rep.getResetCredentialsFlow()));
        }
        if (rep.getClientAuthenticationFlow() != null) {
            realm.setClientAuthenticationFlow(realm.getFlowByAlias(rep.getClientAuthenticationFlow()));
        }
        if (rep.getDockerAuthenticationFlow() != null) {
            realm.setDockerAuthenticationFlow(realm.getFlowByAlias(rep.getDockerAuthenticationFlow()));
        }
        if (rep.getFirstBrokerLoginFlow() != null) {
            realm.setFirstBrokerLoginFlow(realm.getFlowByAlias(rep.getFirstBrokerLoginFlow()));
        }
    }

    public UserModel createUser(RealmModel newRealm, UserRepresentation userRep) {
        DefaultExportImportManager.convertDeprecatedSocialProviders(userRep);
        UserModel user = UserStoragePrivateUtil.userLocalStorage(this.session).addUser(newRealm, userRep.getId(), userRep.getUsername(), false, false);
        user.setEnabled(userRep.isEnabled() != null && userRep.isEnabled() != false);
        user.setCreatedTimestamp(userRep.getCreatedTimestamp());
        user.setEmail(userRep.getEmail());
        if (userRep.isEmailVerified() != null) {
            user.setEmailVerified(userRep.isEmailVerified().booleanValue());
        }
        user.setFirstName(userRep.getFirstName());
        user.setLastName(userRep.getLastName());
        user.setFederationLink(userRep.getFederationLink());
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                List value = (List)entry.getValue();
                if (value == null) continue;
                user.setAttribute((String)entry.getKey(), new ArrayList(value));
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String requiredAction : userRep.getRequiredActions()) {
                user.addRequiredAction(DefaultRequiredActions.getDefaultRequiredActionCaseInsensitively((String)requiredAction));
            }
        }
        RepresentationToModel.createCredentials((UserRepresentation)userRep, (KeycloakSession)this.session, (RealmModel)newRealm, (UserModel)user, (boolean)false);
        RepresentationToModel.createFederatedIdentities((UserRepresentation)userRep, (KeycloakSession)this.session, (RealmModel)newRealm, (UserModel)user);
        RepresentationToModel.createRoleMappings((UserRepresentation)userRep, (UserModel)user, (RealmModel)newRealm);
        if (userRep.getClientConsents() != null) {
            for (UserConsentRepresentation consentRep : userRep.getClientConsents()) {
                UserConsentModel consentModel = RepresentationToModel.toModel((RealmModel)newRealm, (UserConsentRepresentation)consentRep);
                this.session.users().addConsent(newRealm, user.getId(), consentModel);
            }
        }
        if (userRep.getNotBefore() != null) {
            this.session.users().setNotBeforeForUser(newRealm, user, userRep.getNotBefore().intValue());
        }
        if (userRep.getServiceAccountClientId() != null) {
            String clientId = userRep.getServiceAccountClientId();
            ClientModel client = newRealm.getClientByClientId(clientId);
            if (client == null) {
                throw new RuntimeException("Unable to find client specified for service account link. Client: " + clientId);
            }
            user.setServiceAccountClientLink(client.getId());
        }
        RepresentationToModel.createGroups((KeycloakSession)this.session, (UserRepresentation)userRep, (RealmModel)newRealm, (UserModel)user);
        return user;
    }

    public static void convertDeprecatedSocialProviders(UserRepresentation user) {
        if (user.getSocialLinks() != null && !user.getSocialLinks().isEmpty() && user.getFederatedIdentities() == null) {
            logger.warnf("Using deprecated 'socialLinks' configuration in JSON representation for user '%s'. It will be removed in future versions", (Object)user.getUsername());
            LinkedList<FederatedIdentityRepresentation> federatedIdentities = new LinkedList<FederatedIdentityRepresentation>();
            for (SocialLinkRepresentation social : user.getSocialLinks()) {
                FederatedIdentityRepresentation federatedIdentity = new FederatedIdentityRepresentation();
                federatedIdentity.setIdentityProvider(social.getSocialProvider());
                federatedIdentity.setUserId(social.getSocialUserId());
                federatedIdentity.setUserName(social.getSocialUsername());
                federatedIdentities.add(federatedIdentity);
            }
            user.setFederatedIdentities(federatedIdentities);
        }
        user.setSocialLinks(null);
    }

    private static void convertDeprecatedApplications(KeycloakSession session, RealmRepresentation realm) {
        if (realm.getApplications() != null || realm.getOauthClients() != null) {
            if (realm.getClients() == null) {
                realm.setClients(new LinkedList());
            }
            LinkedList clients = new LinkedList();
            if (realm.getApplications() != null) {
                clients.addAll(realm.getApplications());
            }
            if (realm.getOauthClients() != null) {
                clients.addAll(realm.getOauthClients());
            }
            for (ApplicationRepresentation app : clients) {
                app.setClientId(app.getName());
                app.setName(null);
                if (app instanceof OAuthClientRepresentation) {
                    app.setConsentRequired(Boolean.valueOf(true));
                    app.setFullScopeAllowed(Boolean.valueOf(false));
                }
                if (app.getProtocolMappers() == null && app.getClaims() != null) {
                    long mask = DefaultExportImportManager.getClaimsMask(app.getClaims());
                    List convertedProtocolMappers = ((MigrationProvider)session.getProvider(MigrationProvider.class)).getMappersForClaimMask(Long.valueOf(mask));
                    app.setProtocolMappers(convertedProtocolMappers);
                    app.setClaims(null);
                }
                realm.getClients().add(app);
            }
        }
        if (realm.getApplicationScopeMappings() != null && realm.getClientScopeMappings() == null) {
            realm.setClientScopeMappings(realm.getApplicationScopeMappings());
        }
        if (realm.getRoles() != null && realm.getRoles().getApplication() != null && realm.getRoles().getClient() == null) {
            realm.getRoles().setClient(realm.getRoles().getApplication());
        }
        if (realm.getUsers() != null) {
            for (UserRepresentation userRepresentation : realm.getUsers()) {
                if (userRepresentation.getApplicationRoles() == null || userRepresentation.getClientRoles() != null) continue;
                userRepresentation.setClientRoles(userRepresentation.getApplicationRoles());
            }
        }
        if (realm.getRoles() != null && realm.getRoles().getRealm() != null) {
            for (RoleRepresentation roleRepresentation : realm.getRoles().getRealm()) {
                if (roleRepresentation.getComposites() == null || roleRepresentation.getComposites().getApplication() == null || roleRepresentation.getComposites().getClient() != null) continue;
                roleRepresentation.getComposites().setClient(roleRepresentation.getComposites().getApplication());
            }
        }
        if (realm.getRoles() != null && realm.getRoles().getClient() != null) {
            for (Map.Entry entry : realm.getRoles().getClient().entrySet()) {
                for (RoleRepresentation role : (List)entry.getValue()) {
                    if (role.getComposites() == null || role.getComposites().getApplication() == null || role.getComposites().getClient() != null) continue;
                    role.getComposites().setClient(role.getComposites().getApplication());
                }
            }
        }
    }

    private static void convertDeprecatedSocialProviders(RealmRepresentation rep) {
        if (rep.isSocial() != null && rep.isSocial().booleanValue() && rep.getSocialProviders() != null && !rep.getSocialProviders().isEmpty() && rep.getIdentityProviders() == null) {
            Boolean updateProfileFirstLogin = rep.isUpdateProfileOnInitialSocialLogin() != null && rep.isUpdateProfileOnInitialSocialLogin() != false;
            if (rep.getSocialProviders() != null) {
                logger.warn((Object)"Using deprecated 'social' configuration in JSON representation. It will be removed in future versions");
                LinkedList<IdentityProviderRepresentation> identityProviders = new LinkedList<IdentityProviderRepresentation>();
                for (String k : rep.getSocialProviders().keySet()) {
                    if (!k.endsWith(".key")) continue;
                    String providerId = k.split("\\.")[0];
                    String key = (String)rep.getSocialProviders().get(k);
                    String secret = (String)rep.getSocialProviders().get(k.replace(".key", ".secret"));
                    IdentityProviderRepresentation identityProvider = new IdentityProviderRepresentation();
                    identityProvider.setAlias(providerId);
                    identityProvider.setProviderId(providerId);
                    identityProvider.setEnabled(true);
                    identityProvider.setLinkOnly(false);
                    identityProvider.setUpdateProfileFirstLogin(updateProfileFirstLogin.booleanValue());
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("clientId", key);
                    config.put("clientSecret", secret);
                    identityProvider.setConfig(config);
                    identityProviders.add(identityProvider);
                }
                rep.setIdentityProviders(identityProviders);
            }
        }
    }

    private static void convertDeprecatedClientTemplates(RealmRepresentation realm) {
        if (realm.getClientTemplates() != null) {
            logger.warnf("Using deprecated 'clientTemplates' configuration in JSON representation for realm '%s'. It will be removed in future versions", (Object)realm.getRealm());
            LinkedList<ClientScopeRepresentation> clientScopes = new LinkedList<ClientScopeRepresentation>();
            for (ClientTemplateRepresentation template : realm.getClientTemplates()) {
                ClientScopeRepresentation scopeRep = new ClientScopeRepresentation();
                scopeRep.setId(template.getId());
                scopeRep.setName(template.getName());
                scopeRep.setProtocol(template.getProtocol());
                scopeRep.setDescription(template.getDescription());
                scopeRep.setAttributes(template.getAttributes());
                scopeRep.setProtocolMappers(template.getProtocolMappers());
                clientScopes.add(scopeRep);
            }
            realm.setClientScopes(clientScopes);
        }
    }

    public static void importUserFederationProvidersAndMappers(KeycloakSession session, RealmRepresentation rep, RealmModel newRealm) {
        HashSet<String> convertSet = new HashSet<String>();
        convertSet.add("ldap");
        convertSet.add("kerberos");
        HashMap<String, String> mapperConvertSet = new HashMap<String, String>();
        mapperConvertSet.put("ldap", "org.keycloak.storage.ldap.mappers.LDAPStorageMapper");
        HashMap<String, ComponentModel> userStorageModels = new HashMap<String, ComponentModel>();
        if (rep.getUserFederationProviders() != null) {
            for (UserFederationProviderRepresentation fedRep : rep.getUserFederationProviders()) {
                if (!convertSet.contains(fedRep.getProviderName())) continue;
                ComponentModel component = DefaultExportImportManager.convertFedProviderToComponent(newRealm.getId(), fedRep);
                userStorageModels.put(fedRep.getDisplayName(), newRealm.importComponentModel(component));
            }
        }
        HashSet storageProvidersWhichShouldImportDefaultMappers = new HashSet(userStorageModels.keySet());
        if (rep.getUserFederationMappers() != null) {
            for (UserFederationMapperRepresentation representation : rep.getUserFederationMappers()) {
                if (!userStorageModels.containsKey(representation.getFederationProviderDisplayName())) continue;
                ComponentModel parent = (ComponentModel)userStorageModels.get(representation.getFederationProviderDisplayName());
                String newMapperType = (String)mapperConvertSet.get(parent.getProviderId());
                ComponentModel mapper = DefaultExportImportManager.convertFedMapperToComponent(newRealm, parent, representation, newMapperType);
                newRealm.importComponentModel(mapper);
                storageProvidersWhichShouldImportDefaultMappers.remove(representation.getFederationProviderDisplayName());
            }
        }
        for (String providerDisplayName : storageProvidersWhichShouldImportDefaultMappers) {
            ComponentUtil.notifyCreated((KeycloakSession)session, (RealmModel)newRealm, (ComponentModel)((ComponentModel)userStorageModels.get(providerDisplayName)));
        }
    }

    public static ComponentModel convertFedMapperToComponent(RealmModel realm, ComponentModel parent, UserFederationMapperRepresentation rep, String newMapperType) {
        ComponentModel mapper = new ComponentModel();
        mapper.setId(rep.getId());
        mapper.setName(rep.getName());
        mapper.setProviderId(rep.getFederationMapperType());
        mapper.setProviderType(newMapperType);
        mapper.setParentId(parent.getId());
        if (rep.getConfig() != null) {
            for (Map.Entry entry : rep.getConfig().entrySet()) {
                mapper.getConfig().putSingle((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
            }
        }
        return mapper;
    }

    public static ComponentModel convertFedProviderToComponent(String realmId, UserFederationProviderRepresentation fedModel) {
        UserStorageProviderModel model = new UserStorageProviderModel();
        model.setId(fedModel.getId());
        model.setName(fedModel.getDisplayName());
        model.setParentId(realmId);
        model.setProviderId(fedModel.getProviderName());
        model.setProviderType(UserStorageProvider.class.getName());
        model.setFullSyncPeriod(fedModel.getFullSyncPeriod());
        model.setPriority(fedModel.getPriority());
        model.setChangedSyncPeriod(fedModel.getChangedSyncPeriod());
        model.setLastSync(fedModel.getLastSync());
        if (fedModel.getConfig() != null) {
            for (Map.Entry entry : fedModel.getConfig().entrySet()) {
                model.getConfig().putSingle((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
            }
        }
        return model;
    }

    protected static void importComponents(RealmModel newRealm, MultivaluedHashMap<String, ComponentExportRepresentation> components, String parentId) {
        for (Map.Entry entry : components.entrySet()) {
            String providerType = (String)entry.getKey();
            for (ComponentExportRepresentation compRep : (List)entry.getValue()) {
                ComponentModel component = new ComponentModel();
                component.setId(compRep.getId());
                component.setName(compRep.getName());
                component.setConfig(compRep.getConfig());
                component.setProviderType(providerType);
                component.setProviderId(compRep.getProviderId());
                component.setSubType(compRep.getSubType());
                component.setParentId(parentId);
                component = newRealm.importComponentModel(component);
                if (compRep.getSubComponents() == null) continue;
                DefaultExportImportManager.importComponents(newRealm, (MultivaluedHashMap<String, ComponentExportRepresentation>)compRep.getSubComponents(), component.getId());
            }
        }
    }

    public static void importGroups(RealmModel realm, RealmRepresentation rep) {
        List groups = rep.getGroups();
        if (groups == null) {
            return;
        }
        GroupModel parent = null;
        for (GroupRepresentation group : groups) {
            RepresentationToModel.importGroup((RealmModel)realm, parent, (GroupRepresentation)group);
        }
    }

    private static WebAuthnPolicy getWebAuthnPolicyTwoFactor(RealmRepresentation rep) {
        List webAuthnPolicyExtraOrigins;
        List webAuthnPolicyAcceptableAaguids;
        WebAuthnPolicy webAuthnPolicy = new WebAuthnPolicy();
        String webAuthnPolicyRpEntityName = rep.getWebAuthnPolicyRpEntityName();
        if (webAuthnPolicyRpEntityName == null || webAuthnPolicyRpEntityName.isEmpty()) {
            webAuthnPolicyRpEntityName = "keycloak";
        }
        webAuthnPolicy.setRpEntityName(webAuthnPolicyRpEntityName);
        List<String> webAuthnPolicySignatureAlgorithms = rep.getWebAuthnPolicySignatureAlgorithms();
        if (webAuthnPolicySignatureAlgorithms == null || webAuthnPolicySignatureAlgorithms.isEmpty()) {
            webAuthnPolicySignatureAlgorithms = Arrays.asList("ES256".split(","));
        }
        webAuthnPolicy.setSignatureAlgorithm(webAuthnPolicySignatureAlgorithms);
        String webAuthnPolicyRpId = rep.getWebAuthnPolicyRpId();
        if (webAuthnPolicyRpId == null || webAuthnPolicyRpId.isEmpty()) {
            webAuthnPolicyRpId = "";
        }
        webAuthnPolicy.setRpId(webAuthnPolicyRpId);
        String webAuthnPolicyAttestationConveyancePreference = rep.getWebAuthnPolicyAttestationConveyancePreference();
        if (webAuthnPolicyAttestationConveyancePreference == null || webAuthnPolicyAttestationConveyancePreference.isEmpty()) {
            webAuthnPolicyAttestationConveyancePreference = "not specified";
        }
        webAuthnPolicy.setAttestationConveyancePreference(webAuthnPolicyAttestationConveyancePreference);
        String webAuthnPolicyAuthenticatorAttachment = rep.getWebAuthnPolicyAuthenticatorAttachment();
        if (webAuthnPolicyAuthenticatorAttachment == null || webAuthnPolicyAuthenticatorAttachment.isEmpty()) {
            webAuthnPolicyAuthenticatorAttachment = "not specified";
        }
        webAuthnPolicy.setAuthenticatorAttachment(webAuthnPolicyAuthenticatorAttachment);
        String webAuthnPolicyRequireResidentKey = rep.getWebAuthnPolicyRequireResidentKey();
        if (webAuthnPolicyRequireResidentKey == null || webAuthnPolicyRequireResidentKey.isEmpty()) {
            webAuthnPolicyRequireResidentKey = "not specified";
        }
        webAuthnPolicy.setRequireResidentKey(webAuthnPolicyRequireResidentKey);
        String webAuthnPolicyUserVerificationRequirement = rep.getWebAuthnPolicyUserVerificationRequirement();
        if (webAuthnPolicyUserVerificationRequirement == null || webAuthnPolicyUserVerificationRequirement.isEmpty()) {
            webAuthnPolicyUserVerificationRequirement = "not specified";
        }
        webAuthnPolicy.setUserVerificationRequirement(webAuthnPolicyUserVerificationRequirement);
        Integer webAuthnPolicyCreateTimeout = rep.getWebAuthnPolicyCreateTimeout();
        if (webAuthnPolicyCreateTimeout != null) {
            webAuthnPolicy.setCreateTimeout(webAuthnPolicyCreateTimeout.intValue());
        } else {
            webAuthnPolicy.setCreateTimeout(0);
        }
        Boolean webAuthnPolicyAvoidSameAuthenticatorRegister = rep.isWebAuthnPolicyAvoidSameAuthenticatorRegister();
        if (webAuthnPolicyAvoidSameAuthenticatorRegister != null) {
            webAuthnPolicy.setAvoidSameAuthenticatorRegister(webAuthnPolicyAvoidSameAuthenticatorRegister.booleanValue());
        }
        if ((webAuthnPolicyAcceptableAaguids = rep.getWebAuthnPolicyAcceptableAaguids()) != null) {
            webAuthnPolicy.setAcceptableAaguids(webAuthnPolicyAcceptableAaguids);
        }
        if ((webAuthnPolicyExtraOrigins = rep.getWebAuthnPolicyExtraOrigins()) != null) {
            webAuthnPolicy.setExtraOrigins(webAuthnPolicyExtraOrigins);
        }
        return webAuthnPolicy;
    }

    private static WebAuthnPolicy getWebAuthnPolicyPasswordless(RealmRepresentation rep) {
        List webAuthnPolicyExtraOrigins;
        List webAuthnPolicyAcceptableAaguids;
        WebAuthnPolicy webAuthnPolicy = new WebAuthnPolicy();
        String webAuthnPolicyRpEntityName = rep.getWebAuthnPolicyPasswordlessRpEntityName();
        if (webAuthnPolicyRpEntityName == null || webAuthnPolicyRpEntityName.isEmpty()) {
            webAuthnPolicyRpEntityName = "keycloak";
        }
        webAuthnPolicy.setRpEntityName(webAuthnPolicyRpEntityName);
        List<String> webAuthnPolicySignatureAlgorithms = rep.getWebAuthnPolicyPasswordlessSignatureAlgorithms();
        if (webAuthnPolicySignatureAlgorithms == null || webAuthnPolicySignatureAlgorithms.isEmpty()) {
            webAuthnPolicySignatureAlgorithms = Arrays.asList("ES256".split(","));
        }
        webAuthnPolicy.setSignatureAlgorithm(webAuthnPolicySignatureAlgorithms);
        String webAuthnPolicyRpId = rep.getWebAuthnPolicyPasswordlessRpId();
        if (webAuthnPolicyRpId == null || webAuthnPolicyRpId.isEmpty()) {
            webAuthnPolicyRpId = "";
        }
        webAuthnPolicy.setRpId(webAuthnPolicyRpId);
        String webAuthnPolicyAttestationConveyancePreference = rep.getWebAuthnPolicyPasswordlessAttestationConveyancePreference();
        if (webAuthnPolicyAttestationConveyancePreference == null || webAuthnPolicyAttestationConveyancePreference.isEmpty()) {
            webAuthnPolicyAttestationConveyancePreference = "not specified";
        }
        webAuthnPolicy.setAttestationConveyancePreference(webAuthnPolicyAttestationConveyancePreference);
        String webAuthnPolicyAuthenticatorAttachment = rep.getWebAuthnPolicyPasswordlessAuthenticatorAttachment();
        if (webAuthnPolicyAuthenticatorAttachment == null || webAuthnPolicyAuthenticatorAttachment.isEmpty()) {
            webAuthnPolicyAuthenticatorAttachment = "not specified";
        }
        webAuthnPolicy.setAuthenticatorAttachment(webAuthnPolicyAuthenticatorAttachment);
        String webAuthnPolicyRequireResidentKey = rep.getWebAuthnPolicyPasswordlessRequireResidentKey();
        if (webAuthnPolicyRequireResidentKey == null || webAuthnPolicyRequireResidentKey.isEmpty()) {
            webAuthnPolicyRequireResidentKey = "not specified";
        }
        webAuthnPolicy.setRequireResidentKey(webAuthnPolicyRequireResidentKey);
        String webAuthnPolicyUserVerificationRequirement = rep.getWebAuthnPolicyPasswordlessUserVerificationRequirement();
        if (webAuthnPolicyUserVerificationRequirement == null || webAuthnPolicyUserVerificationRequirement.isEmpty()) {
            webAuthnPolicyUserVerificationRequirement = "not specified";
        }
        webAuthnPolicy.setUserVerificationRequirement(webAuthnPolicyUserVerificationRequirement);
        Integer webAuthnPolicyCreateTimeout = rep.getWebAuthnPolicyPasswordlessCreateTimeout();
        if (webAuthnPolicyCreateTimeout != null) {
            webAuthnPolicy.setCreateTimeout(webAuthnPolicyCreateTimeout.intValue());
        } else {
            webAuthnPolicy.setCreateTimeout(0);
        }
        Boolean webAuthnPolicyAvoidSameAuthenticatorRegister = rep.isWebAuthnPolicyPasswordlessAvoidSameAuthenticatorRegister();
        if (webAuthnPolicyAvoidSameAuthenticatorRegister != null) {
            webAuthnPolicy.setAvoidSameAuthenticatorRegister(webAuthnPolicyAvoidSameAuthenticatorRegister.booleanValue());
        }
        if ((webAuthnPolicyAcceptableAaguids = rep.getWebAuthnPolicyPasswordlessAcceptableAaguids()) != null) {
            webAuthnPolicy.setAcceptableAaguids(webAuthnPolicyAcceptableAaguids);
        }
        if ((webAuthnPolicyExtraOrigins = rep.getWebAuthnPolicyPasswordlessExtraOrigins()) != null) {
            webAuthnPolicy.setExtraOrigins(webAuthnPolicyExtraOrigins);
        }
        return webAuthnPolicy;
    }

    public static Map<String, String> importAuthenticationFlows(KeycloakSession session, RealmModel newRealm, RealmRepresentation rep) {
        AuthenticationFlowModel defaultFlow;
        AuthenticatorConfigModel model;
        HashMap<String, String> mappedFlows = new HashMap<String, String>();
        if (rep.getAuthenticatorConfig() != null) {
            for (AuthenticatorConfigRepresentation configRep : rep.getAuthenticatorConfig()) {
                if (configRep.getAlias() == null) {
                    throw new IllegalStateException("Provided realm contains authenticator config with null alias. It should be resolved by adding alias to the authenticator config before exporting the realm.");
                }
                model = RepresentationToModel.toModel((AuthenticatorConfigRepresentation)configRep);
                newRealm.addAuthenticatorConfig(model);
            }
        }
        if (rep.getAuthenticationFlows() != null) {
            for (Object flowRep : rep.getAuthenticationFlows()) {
                model = RepresentationToModel.toModel((AuthenticationFlowRepresentation)flowRep);
                String previousId = model.getId();
                model = newRealm.addAuthenticationFlow((AuthenticationFlowModel)model);
                mappedFlows.put(previousId, model.getId());
            }
            for (Object flowRep : rep.getAuthenticationFlows()) {
                model = newRealm.getFlowByAlias(flowRep.getAlias());
                for (AuthenticationExecutionExportRepresentation exeRep : flowRep.getAuthenticationExecutions()) {
                    AuthenticationExecutionModel execution = DefaultExportImportManager.toModel(session, newRealm, (AuthenticationFlowModel)model, exeRep);
                    newRealm.addAuthenticatorExecution(execution);
                }
            }
        }
        DefaultAuthenticationFlows.migrateFlows((RealmModel)newRealm);
        if (rep.getBrowserFlow() == null) {
            defaultFlow = newRealm.getFlowByAlias("browser");
            if (defaultFlow != null) {
                newRealm.setBrowserFlow(defaultFlow);
            }
        } else {
            newRealm.setBrowserFlow(newRealm.getFlowByAlias(rep.getBrowserFlow()));
        }
        if (rep.getRegistrationFlow() == null) {
            defaultFlow = newRealm.getFlowByAlias("registration");
            if (defaultFlow != null) {
                newRealm.setRegistrationFlow(defaultFlow);
            }
        } else {
            newRealm.setRegistrationFlow(newRealm.getFlowByAlias(rep.getRegistrationFlow()));
        }
        if (rep.getDirectGrantFlow() == null) {
            defaultFlow = newRealm.getFlowByAlias("direct grant");
            if (defaultFlow != null) {
                newRealm.setDirectGrantFlow(defaultFlow);
            }
        } else {
            newRealm.setDirectGrantFlow(newRealm.getFlowByAlias(rep.getDirectGrantFlow()));
        }
        if (rep.getResetCredentialsFlow() == null) {
            AuthenticationFlowModel resetFlow = newRealm.getFlowByAlias("reset credentials");
            if (resetFlow == null) {
                DefaultAuthenticationFlows.resetCredentialsFlow((RealmModel)newRealm);
            } else {
                newRealm.setResetCredentialsFlow(resetFlow);
            }
        } else {
            newRealm.setResetCredentialsFlow(newRealm.getFlowByAlias(rep.getResetCredentialsFlow()));
        }
        if (rep.getClientAuthenticationFlow() == null) {
            AuthenticationFlowModel clientFlow = newRealm.getFlowByAlias("clients");
            if (clientFlow == null) {
                DefaultAuthenticationFlows.clientAuthFlow((RealmModel)newRealm);
            } else {
                newRealm.setClientAuthenticationFlow(clientFlow);
            }
        } else {
            newRealm.setClientAuthenticationFlow(newRealm.getFlowByAlias(rep.getClientAuthenticationFlow()));
        }
        if (rep.getFirstBrokerLoginFlow() == null) {
            AuthenticationFlowModel firstBrokerLoginFlow = newRealm.getFlowByAlias("first broker login");
            if (firstBrokerLoginFlow == null) {
                DefaultAuthenticationFlows.firstBrokerLoginFlow((RealmModel)newRealm, (boolean)true);
            } else {
                newRealm.setFirstBrokerLoginFlow(firstBrokerLoginFlow);
            }
        } else {
            newRealm.setFirstBrokerLoginFlow(newRealm.getFlowByAlias(rep.getFirstBrokerLoginFlow()));
        }
        String defaultProvider = null;
        if (rep.getIdentityProviders() != null) {
            for (IdentityProviderRepresentation i : rep.getIdentityProviders()) {
                if (!i.isEnabled() || !i.isAuthenticateByDefault()) continue;
                defaultProvider = i.getProviderId();
                break;
            }
        }
        if (rep.getDockerAuthenticationFlow() == null) {
            AuthenticationFlowModel dockerAuthenticationFlow = newRealm.getFlowByAlias("docker auth");
            if (dockerAuthenticationFlow == null) {
                DefaultAuthenticationFlows.dockerAuthenticationFlow((RealmModel)newRealm);
            } else {
                newRealm.setDockerAuthenticationFlow(dockerAuthenticationFlow);
            }
        } else {
            newRealm.setDockerAuthenticationFlow(newRealm.getFlowByAlias(rep.getDockerAuthenticationFlow()));
        }
        DefaultAuthenticationFlows.addIdentityProviderAuthenticator((RealmModel)newRealm, defaultProvider);
        return mappedFlows;
    }

    private static AuthenticationExecutionModel toModel(KeycloakSession session, RealmModel realm, AuthenticationFlowModel parentFlow, AuthenticationExecutionExportRepresentation rep) {
        AuthenticationExecutionModel model;
        block5: {
            model = new AuthenticationExecutionModel();
            if (rep.getAuthenticatorConfig() != null) {
                AuthenticatorConfigModel config = new DeployedConfigurationsManager(session).getAuthenticatorConfigByAlias(realm, rep.getAuthenticatorConfig());
                model.setAuthenticatorConfig(config.getId());
            }
            model.setAuthenticator(rep.getAuthenticator());
            model.setAuthenticatorFlow(rep.isAuthenticatorFlow());
            if (rep.getFlowAlias() != null) {
                AuthenticationFlowModel flow = realm.getFlowByAlias(rep.getFlowAlias());
                model.setFlowId(flow.getId());
            }
            if (rep.getPriority() != null) {
                model.setPriority(rep.getPriority().intValue());
            }
            try {
                model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf((String)rep.getRequirement()));
                model.setParentFlow(parentFlow.getId());
            }
            catch (IllegalArgumentException iae) {
                if (!"OPTIONAL".equals(rep.getRequirement())) break block5;
                MigrateTo8_0_0.migrateOptionalAuthenticationExecution(realm, parentFlow, model, false);
            }
        }
        return model;
    }

    private static void updateCibaSettings(RealmRepresentation rep, RealmModel realm) {
        Map newAttributes = rep.getAttributesOrEmpty();
        CibaConfig cibaPolicy = realm.getCibaPolicy();
        cibaPolicy.setBackchannelTokenDeliveryMode((String)newAttributes.get("cibaBackchannelTokenDeliveryMode"));
        cibaPolicy.setExpiresIn((String)newAttributes.get("cibaExpiresIn"));
        cibaPolicy.setPoolingInterval((String)newAttributes.get("cibaInterval"));
        cibaPolicy.setAuthRequestedUserHint((String)newAttributes.get("cibaAuthRequestedUserHint"));
    }

    private static void updateParSettings(RealmRepresentation rep, RealmModel realm) {
        Map newAttributes = rep.getAttributesOrEmpty();
        ParConfig parPolicy = realm.getParPolicy();
        parPolicy.setRequestUriLifespan((String)newAttributes.get("parRequestUriLifespan"));
    }

    public static OTPPolicy toPolicy(RealmRepresentation rep) {
        OTPPolicy policy = new OTPPolicy();
        if (rep.getOtpPolicyType() != null) {
            policy.setType(rep.getOtpPolicyType());
        }
        if (rep.getOtpPolicyLookAheadWindow() != null) {
            policy.setLookAheadWindow(rep.getOtpPolicyLookAheadWindow().intValue());
        }
        if (rep.getOtpPolicyInitialCounter() != null) {
            policy.setInitialCounter(rep.getOtpPolicyInitialCounter().intValue());
        }
        if (rep.getOtpPolicyAlgorithm() != null) {
            policy.setAlgorithm(rep.getOtpPolicyAlgorithm());
        }
        if (rep.getOtpPolicyDigits() != null) {
            policy.setDigits(rep.getOtpPolicyDigits().intValue());
        }
        if (rep.getOtpPolicyPeriod() != null) {
            policy.setPeriod(rep.getOtpPolicyPeriod().intValue());
        }
        if (rep.isOtpPolicyCodeReusable() != null) {
            policy.setCodeReusable(rep.isOtpPolicyCodeReusable().booleanValue());
        }
        return policy;
    }

    public static RequiredActionProviderModel toModel(RequiredActionProviderRepresentation rep) {
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setConfig(RepresentationToModel.removeEmptyString((Map)rep.getConfig()));
        model.setPriority(rep.getPriority());
        model.setDefaultAction(rep.isDefaultAction());
        model.setEnabled(rep.isEnabled());
        model.setProviderId(DefaultRequiredActions.getDefaultRequiredActionCaseInsensitively((String)rep.getProviderId()));
        model.setName(rep.getName());
        model.setAlias(DefaultRequiredActions.getDefaultRequiredActionCaseInsensitively((String)rep.getAlias()));
        return model;
    }

    public static void importRealmAuthorizationSettings(RealmRepresentation rep, RealmModel newRealm, KeycloakSession session) {
        if (rep.getClients() != null) {
            rep.getClients().forEach(clientRepresentation -> {
                ClientModel client = newRealm.getClientByClientId(clientRepresentation.getClientId());
                RepresentationToModel.importAuthorizationSettings((ClientRepresentation)clientRepresentation, (ClientModel)client, (KeycloakSession)session);
            });
        }
    }

    public static void importFederatedUser(KeycloakSession session, RealmModel newRealm, UserRepresentation userRep) {
        UserFederatedStorageProvider federatedStorage = UserStorageUtil.userFederatedStorage((KeycloakSession)session);
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                if (value == null) continue;
                federatedStorage.setAttribute(newRealm, userRep.getId(), key, new LinkedList(value));
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String action : userRep.getRequiredActions()) {
                federatedStorage.addRequiredAction(newRealm, userRep.getId(), action);
            }
        }
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                federatedStorage.createCredential(newRealm, userRep.getId(), RepresentationToModel.toModel((CredentialRepresentation)cred));
            }
        }
        DefaultExportImportManager.createFederatedRoleMappings(federatedStorage, userRep, newRealm);
        if (userRep.getGroups() != null) {
            for (String path : userRep.getGroups()) {
                GroupModel group = KeycloakModelUtils.findGroupByPath((KeycloakSession)session, (RealmModel)newRealm, (String)path);
                if (group == null) {
                    throw new RuntimeException("Unable to find group specified by path: " + path);
                }
                federatedStorage.joinGroup(newRealm, userRep.getId(), group);
            }
        }
        if (userRep.getFederatedIdentities() != null) {
            for (FederatedIdentityRepresentation identity : userRep.getFederatedIdentities()) {
                FederatedIdentityModel mappingModel = new FederatedIdentityModel(identity.getIdentityProvider(), identity.getUserId(), identity.getUserName());
                federatedStorage.addFederatedIdentity(newRealm, userRep.getId(), mappingModel);
            }
        }
        if (userRep.getClientConsents() != null) {
            for (UserConsentRepresentation consentRep : userRep.getClientConsents()) {
                UserConsentModel consentModel = RepresentationToModel.toModel((RealmModel)newRealm, (UserConsentRepresentation)consentRep);
                federatedStorage.addConsent(newRealm, userRep.getId(), consentModel);
            }
        }
        if (userRep.getNotBefore() != null) {
            federatedStorage.setNotBeforeForUser(newRealm, userRep.getId(), userRep.getNotBefore().intValue());
        }
    }

    private static void createFederatedRoleMappings(UserFederatedStorageProvider federatedStorage, UserRepresentation userRep, RealmModel realm) {
        if (userRep.getRealmRoles() != null) {
            for (String string : userRep.getRealmRoles()) {
                RoleModel role = realm.getRole(string.trim());
                if (role == null) {
                    role = realm.addRole(string.trim());
                }
                federatedStorage.grantRole(realm, userRep.getId(), role);
            }
        }
        if (userRep.getClientRoles() != null) {
            for (Map.Entry entry : userRep.getClientRoles().entrySet()) {
                ClientModel client = realm.getClientByClientId((String)entry.getKey());
                if (client == null) {
                    throw new RuntimeException("Unable to find client role mappings for client: " + (String)entry.getKey());
                }
                DefaultExportImportManager.createFederatedClientRoleMappings(federatedStorage, realm, client, userRep, (List)entry.getValue());
            }
        }
    }

    private static void createFederatedClientRoleMappings(UserFederatedStorageProvider federatedStorage, RealmModel realm, ClientModel clientModel, UserRepresentation userRep, List<String> roleNames) {
        if (userRep == null) {
            throw new RuntimeException("User not found");
        }
        for (String roleName : roleNames) {
            RoleModel role = clientModel.getRole(roleName.trim());
            if (role == null) {
                role = clientModel.addRole(roleName.trim());
            }
            federatedStorage.grantRole(realm, userRep.getId(), role);
        }
    }

    private void importOrganizations(RealmRepresentation rep, RealmModel newRealm) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            OrganizationProvider provider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
            for (OrganizationRepresentation orgRep : Optional.ofNullable(rep.getOrganizations()).orElse(Collections.emptyList())) {
                OrganizationModel org = provider.create(orgRep.getName());
                org.setDomains(orgRep.getDomains().stream().map(r -> new OrganizationDomainModel(r.getName(), r.isVerified())).collect(Collectors.toSet()));
                for (IdentityProviderRepresentation identityProvider : orgRep.getIdentityProviders()) {
                    IdentityProviderModel idp = newRealm.getIdentityProviderByAlias(identityProvider.getAlias());
                    provider.addIdentityProvider(org, idp);
                }
                for (UserRepresentation member : orgRep.getMembers()) {
                    UserModel m = this.session.users().getUserByUsername(newRealm, member.getUsername());
                    provider.addMember(org, m);
                }
            }
        }
    }
}

