/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization.integration.elytron;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.authorization.TokenPrincipal;
import org.keycloak.adapters.authorization.integration.elytron.ServletHttpRequest;
import org.keycloak.adapters.authorization.integration.elytron.ServletHttpResponse;
import org.keycloak.adapters.authorization.spi.ConfigurationResolver;
import org.keycloak.adapters.authorization.spi.HttpRequest;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcPrincipal;
import org.wildfly.security.http.oidc.RefreshableOidcSecurityContext;

public class PolicyEnforcerFilter
implements Filter,
ServletContextAttributeListener {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final Map<PolicyEnforcerConfig, PolicyEnforcer> policyEnforcer;
    private final ConfigurationResolver configResolver;

    public PolicyEnforcerFilter(ConfigurationResolver configResolver) {
        this.configResolver = configResolver;
        this.policyEnforcer = Collections.synchronizedMap(new HashMap());
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession(false);
        if (session == null) {
            this.logger.debug((Object)"Anonymous request, continuing the filter chain");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        RefreshableOidcSecurityContext securityContext = (RefreshableOidcSecurityContext)((OidcPrincipal)request.getUserPrincipal()).getOidcSecurityContext();
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        final String accessToken = securityContext.getTokenString();
        ServletHttpRequest httpRequest = new ServletHttpRequest(request, new TokenPrincipal(){

            @Override
            public String getRawToken() {
                return accessToken;
            }
        });
        PolicyEnforcer policyEnforcer = this.getOrCreatePolicyEnforcer(httpRequest, securityContext);
        AuthorizationContext authzContext = policyEnforcer.enforce(httpRequest, new ServletHttpResponse(response));
        request.setAttribute(AuthorizationContext.class.getName(), (Object)authzContext);
        if (authzContext.isGranted()) {
            this.logger.debug((Object)"Request authorized, continuing the filter chain");
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            this.logger.debugf("Unauthorized request to path [%s], aborting the filter chain", (Object)request.getRequestURI());
        }
    }

    private PolicyEnforcer getOrCreatePolicyEnforcer(HttpRequest request, final RefreshableOidcSecurityContext securityContext) {
        return this.policyEnforcer.computeIfAbsent(this.configResolver.resolve(request), new Function<PolicyEnforcerConfig, PolicyEnforcer>(){

            @Override
            public PolicyEnforcer apply(PolicyEnforcerConfig enforcerConfig) {
                OidcClientConfiguration configuration = securityContext.getOidcClientConfiguration();
                String authServerUrl = configuration.getAuthServerBaseUrl();
                return PolicyEnforcer.builder().authServerUrl(authServerUrl).realm(configuration.getRealm()).clientId(configuration.getClientId()).credentials(configuration.getResourceCredentials()).bearerOnly(false).enforcerConfig(enforcerConfig).httpClient(configuration.getClient()).build();
            }
        });
    }
}

