/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.database.liquibase;

import java.util.logging.Level;
import liquibase.logging.LogMessageFilter;
import liquibase.logging.core.AbstractLogger;
import liquibase.logging.core.DefaultLogMessageFilter;
import org.jboss.logging.Logger;

public class KeycloakLogger
extends AbstractLogger {
    private final Logger delegate;

    public KeycloakLogger(Class clazz) {
        super((LogMessageFilter)new DefaultLogMessageFilter());
        this.delegate = Logger.getLogger((Class)clazz);
    }

    public void severe(String message) {
        this.delegate.error((Object)message);
    }

    public void severe(String message, Throwable e) {
        this.delegate.error((Object)message, e);
    }

    public void warning(String message) {
        if ("Database does not support drop with cascade".equals(message)) {
            this.delegate.debug((Object)message);
        } else {
            this.delegate.warn((Object)message);
        }
    }

    public void warning(String message, Throwable e) {
        this.delegate.warn((Object)message, e);
    }

    public void info(String message) {
        this.delegate.debug((Object)message);
    }

    public void info(String message, Throwable e) {
        this.delegate.debug((Object)message, e);
    }

    public void debug(String message) {
        if (this.delegate.isTraceEnabled()) {
            this.delegate.trace((Object)message);
        }
    }

    public void debug(String message, Throwable e) {
        this.delegate.trace((Object)message, e);
    }

    public void log(Level level, String message, Throwable e) {
        if (level.equals(Level.OFF)) {
            return;
        }
        if (level.equals(Level.SEVERE)) {
            this.delegate.error((Object)message, e);
        } else if (level.equals(Level.WARNING)) {
            this.delegate.warn((Object)message, e);
        } else if (level.equals(Level.INFO)) {
            this.delegate.debug((Object)message, e);
        } else if (level.equals(Level.FINE) | level.equals(Level.FINER) | level.equals(Level.FINEST) && this.delegate.isTraceEnabled()) {
            this.delegate.trace((Object)message, e);
        }
    }
}

