/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public class PropertyMappingInterceptor
implements ConfigSourceInterceptor {
    private static ThreadLocal<Boolean> disable = new ThreadLocal();

    public static void disable() {
        disable.set(true);
    }

    public static void enable() {
        disable.remove();
    }

    <T> Iterator<T> filterRuntime(Iterator<T> iter, Function<T, String> nameFunc) {
        if (!Environment.isRebuild().booleanValue() && !Environment.isRebuildCheck()) {
            return iter;
        }
        return new FilterIterator(iter, item -> !PropertyMappingInterceptor.isRuntime((String)nameFunc.apply(item)));
    }

    static boolean isRuntime(String name) {
        PropertyMapper<?> mapper = PropertyMappers.getMapper(name);
        return mapper != null && mapper.isRunTime();
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        return this.filterRuntime(context.iterateNames(), Function.identity());
    }

    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        return this.filterRuntime(context.iterateValues(), ConfigValue::getName);
    }

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (Boolean.TRUE.equals(disable.get())) {
            return context.proceed(name);
        }
        ConfigValue value = PropertyMappers.getValue(context, name);
        if (value == null || value.getValue() == null) {
            return null;
        }
        if (!value.getValue().contains("${")) {
            return value;
        }
        return value.withValue(StringPropertyReplacer.replaceProperties((String)value.getValue(), property -> {
            ConfigValue prop = context.proceed(property);
            if (prop == null) {
                return null;
            }
            return prop.getValue();
        }));
    }
}

