/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.keycloak.config.Option;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.utils.StringUtil;

public final class Configuration {
    public static final char OPTION_PART_SEPARATOR_CHAR = '-';
    public static final String OPTION_PART_SEPARATOR = String.valueOf('-');
    private static final String KC_OPTIMIZED = "kc.optimized";

    private Configuration() {
    }

    public static boolean isTrue(Option<Boolean> option) {
        return Configuration.getOptionalBooleanValue("kc." + option.getKey()).orElse(false);
    }

    public static boolean isTrue(String propertyName) {
        return Configuration.getOptionalBooleanValue(propertyName).orElse(false);
    }

    public static boolean isBlank(Option<?> option) {
        return Configuration.getOptionalKcValue(option.getKey()).map(StringUtil::isBlank).orElse(true);
    }

    public static boolean contains(Option<?> option, String value) {
        return Configuration.getOptionalValue("kc." + option.getKey()).filter(f -> f.contains(value)).isPresent();
    }

    public static boolean equals(Option<?> option, String value) {
        return Configuration.getOptionalValue("kc." + option.getKey()).filter(f -> f.equals(value)).isPresent();
    }

    public static synchronized SmallRyeConfig getConfig() {
        return (SmallRyeConfig)ConfigProviderResolver.instance().getConfig();
    }

    public static Optional<String> getBuildTimeProperty(String name) {
        PropertyMapper<?> mapper;
        Optional<String> value = Configuration.getRawPersistedProperty(name);
        if (value.isEmpty() && (mapper = PropertyMappers.getMapper(name)) != null && (value = Configuration.getRawPersistedProperty(mapper.getFrom())).isEmpty() && mapper.getTo() != null) {
            value = Configuration.getRawPersistedProperty(mapper.getTo());
        }
        if (value.isEmpty()) {
            String profile = org.keycloak.common.util.Environment.getProfile();
            if (profile == null) {
                profile = Configuration.getConfig().getRawValue("kc.profile");
            }
            value = Configuration.getRawPersistedProperty("%" + profile + "." + name);
        }
        return value;
    }

    public static Optional<String> getRawPersistedProperty(String name) {
        return Optional.ofNullable(PersistedConfigSource.getInstance().getValue(name));
    }

    public static Map<String, String> getRawPersistedProperties() {
        return PersistedConfigSource.getInstance().getProperties();
    }

    public static String getRawValue(String propertyName) {
        return Configuration.getConfig().getRawValue(propertyName);
    }

    public static Iterable<String> getPropertyNames() {
        return Configuration.getPropertyNames(false);
    }

    public static Iterable<String> getPropertyNames(boolean onlyPersisted) {
        if (onlyPersisted) {
            return PersistedConfigSource.getInstance().getPropertyNames();
        }
        return Configuration.getConfig().getPropertyNames();
    }

    public static ConfigValue getConfigValue(String propertyName) {
        return Configuration.getConfig().getConfigValue(propertyName);
    }

    public static ConfigValue getKcConfigValue(String propertyName) {
        return Configuration.getConfigValue("kc.".concat(propertyName));
    }

    public static Optional<String> getOptionalValue(String name) {
        return Configuration.getConfig().getOptionalValue(name, String.class);
    }

    public static Optional<String> getOptionalKcValue(String propertyName) {
        return Configuration.getOptionalValue("kc.".concat(propertyName));
    }

    public static Optional<String> getOptionalKcValue(Option<?> option) {
        return Configuration.getOptionalKcValue(option.getKey());
    }

    public static Optional<Boolean> getOptionalBooleanKcValue(String propertyName) {
        return Configuration.getOptionalValue("kc.".concat(propertyName)).map(Boolean::parseBoolean);
    }

    public static Optional<Boolean> getOptionalBooleanValue(String name) {
        return Configuration.getOptionalValue(name).map(Boolean::parseBoolean);
    }

    public static String getMappedPropertyName(String key) {
        PropertyMapper<?> mapper = PropertyMappers.getMapper(key);
        if (mapper == null) {
            return key;
        }
        return mapper.getTo() == null ? mapper.getFrom() : mapper.getTo();
    }

    public static Optional<String> getRuntimeProperty(String name) {
        for (ConfigSource configSource : Configuration.getConfig().getConfigSources()) {
            if ("PersistedConfigSource".equals(configSource.getName())) continue;
            String value = Configuration.getValue(configSource, name);
            if (value == null) {
                value = Configuration.getValue(configSource, Configuration.getMappedPropertyName(name));
            }
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static String toEnvVarFormat(String key) {
        return Configuration.replaceNonAlphanumericByUnderscores(key).toUpperCase();
    }

    public static String toCliFormat(String key) {
        return "--" + key;
    }

    public static String toDashCase(String key) {
        StringBuilder sb = new StringBuilder(key.length());
        boolean l = false;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (l && Character.isUpperCase(c)) {
                sb.append('-');
                c = Character.toLowerCase(c);
                l = false;
            } else {
                l = Character.isLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String replaceNonAlphanumericByUnderscores(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (!('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9')) {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String getValue(ConfigSource configSource, String name) {
        String value = configSource.getValue("%".concat(Environment.getProfileOrDefault("prod").concat(".").concat(name)));
        if (value == null) {
            value = configSource.getValue(name);
        }
        return value;
    }

    public static boolean isOptimized() {
        return Configuration.getRawPersistedProperty(KC_OPTIMIZED).isPresent();
    }

    public static void markAsOptimized(Properties properties) {
        properties.put(KC_OPTIMIZED, Boolean.TRUE.toString());
    }

    public static ConfigValue getCurrentBuiltTimeProperty(String name) {
        return PersistedConfigSource.getInstance().runWithDisabled(() -> Configuration.getConfigValue(name));
    }
}

