/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.quarkus.runtime.Environment;
import picocli.CommandLine;

public final class Messages {
    private Messages() {
    }

    public static String httpsConfigurationNotSet() {
        StringBuilder builder = new StringBuilder("Key material not provided to setup HTTPS. Please configure your keys/certificates");
        if (!"dev".equals(org.keycloak.common.util.Environment.getProfile())) {
            builder.append(" or start the server in development mode");
        }
        builder.append(".");
        return builder.toString();
    }

    public static void cliExecutionError(CommandLine cmd, String message, Throwable cause) {
        throw new CommandLine.ExecutionException(cmd, message, cause);
    }

    public static String devProfileNotAllowedError(String cmd) {
        return String.format("You can not '%s' the server in %s mode. Please re-build the server first, using 'kc.sh build' for the default production mode.%n", cmd, Environment.getKeycloakModeFromProfile("dev"));
    }

    public static String optimizedUsedForFirstStartup() {
        return String.format("The '%s' flag was used for first ever server start. Please don't use this flag for the first startup or use '%s %s' to build the server first.", "--optimized", Environment.getCommand(), "build");
    }

    public static String invalidLogLevel(String logLevel) {
        Set values = Arrays.stream(Logger.Level.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toSet());
        return "Invalid log level: " + logLevel + ". Possible values are: " + String.join((CharSequence)", ", values) + ".";
    }

    public static String invalidLogCategoryFormat(String category) {
        return "Invalid log category format: " + category + ". The format is 'category:level' such as 'org.keycloak:debug'.";
    }
}

