/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.Arrays;
import java.util.List;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import picocli.CommandLine;

public abstract class AbstractCommand {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    protected void executionError(CommandLine cmd, String message) {
        this.executionError(cmd, message, null);
    }

    protected void executionError(CommandLine cmd, String message, Throwable cause) {
        Messages.cliExecutionError(cmd, message, cause);
    }

    public boolean includeRuntime() {
        return false;
    }

    public boolean includeBuildTime() {
        return false;
    }

    public List<OptionCategory> getOptionCategories() {
        return Arrays.asList(OptionCategory.values());
    }

    protected void validateConfig() {
        Picocli.validateConfig(ConfigArgsConfigSource.getAllCliArgs(), this);
    }

    public abstract String getName();

    public CommandLine getCommandLine() {
        return this.spec.commandLine();
    }
}

