/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.keycloak.config.CachingOptions;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.MetricsPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

final class CachingPropertyMappers {
    private static final String REMOTE_HOST_SET = "remote host is set";

    private CachingPropertyMappers() {
    }

    public static PropertyMapper<?>[] getClusteringPropertyMappers() {
        List<PropertyMapper> staticMappers = List.of(PropertyMapper.fromOption(CachingOptions.CACHE).paramLabel("type").build(), PropertyMapper.fromOption(CachingOptions.CACHE_STACK).to("kc.spi-connections-infinispan-quarkus-stack").paramLabel("stack").build(), PropertyMapper.fromOption(CachingOptions.CACHE_CONFIG_FILE).mapFrom("cache").to("kc.spi-connections-infinispan-quarkus-config-file").transformer(CachingPropertyMappers::resolveConfigFile).paramLabel("file").build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED).build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE.withRuntimeSpecificDefault((Object)CachingPropertyMappers.getDefaultKeystorePathValue())).paramLabel("file").build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE_PASSWORD).paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE.withRuntimeSpecificDefault((Object)CachingPropertyMappers.getDefaultTruststorePathValue())).paramLabel("file").build(), PropertyMapper.fromOption(CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE_PASSWORD).paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(CachingOptions.CACHE_REMOTE_HOST).paramLabel("hostname").build(), PropertyMapper.fromOption(CachingOptions.CACHE_REMOTE_PORT).isEnabled(CachingPropertyMappers::remoteHostSet, REMOTE_HOST_SET).paramLabel("port").build(), PropertyMapper.fromOption(CachingOptions.CACHE_REMOTE_TLS_ENABLED).isEnabled(CachingPropertyMappers::remoteHostSet, REMOTE_HOST_SET).build(), PropertyMapper.fromOption(CachingOptions.CACHE_REMOTE_USERNAME).isEnabled(CachingPropertyMappers::remoteHostSet, REMOTE_HOST_SET).paramLabel("username").build(), PropertyMapper.fromOption(CachingOptions.CACHE_REMOTE_PASSWORD).isEnabled(CachingPropertyMappers::remoteHostSet, REMOTE_HOST_SET).paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(CachingOptions.CACHE_METRICS_HISTOGRAMS_ENABLED).isEnabled(MetricsPropertyMappers::metricsEnabled, "metrics are enabled").build());
        int numMappers = staticMappers.size() + CachingOptions.LOCAL_MAX_COUNT_CACHES.length + CachingOptions.CLUSTERED_MAX_COUNT_CACHES.length;
        ArrayList mappers = new ArrayList(numMappers);
        mappers.addAll(staticMappers);
        for (String cache : CachingOptions.LOCAL_MAX_COUNT_CACHES) {
            mappers.add(CachingPropertyMappers.maxCountOpt(cache, () -> true, ""));
        }
        for (String cache : CachingOptions.CLUSTERED_MAX_COUNT_CACHES) {
            mappers.add(CachingPropertyMappers.maxCountOpt(cache, InfinispanUtils::isEmbeddedInfinispan, "embedded Infinispan clusters configured"));
        }
        return mappers.toArray(new PropertyMapper[0]);
    }

    private static boolean remoteHostSet() {
        return Configuration.getOptionalKcValue("cache-remote-host").isPresent();
    }

    private static Optional<String> resolveConfigFile(Optional<String> value, ConfigSourceInterceptorContext context) {
        if ("local".equals(value.get())) {
            return Optional.of("cache-local.xml");
        }
        if ("ispn".equals(value.get())) {
            return Optional.of("cache-ispn.xml");
        }
        String homeDir = Environment.getHomeDir();
        Object pathPrefix = homeDir == null ? "" : homeDir + File.separator + "conf" + File.separator;
        return Optional.of((String)pathPrefix + value.get());
    }

    private static String getDefaultKeystorePathValue() {
        File file;
        String homeDir = Environment.getHomeDir();
        if (homeDir != null && (file = Paths.get(homeDir, "conf", "cache-mtls-keystore.p12").toFile()).exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private static String getDefaultTruststorePathValue() {
        File file;
        String homeDir = Environment.getHomeDir();
        if (homeDir != null && (file = Paths.get(homeDir, "conf", "cache-mtls-truststore.p12").toFile()).exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private static PropertyMapper<?> maxCountOpt(String cacheName, BooleanSupplier isEnabled, String enabledWhen) {
        return PropertyMapper.fromOption(CachingOptions.maxCountOption((String)cacheName)).isEnabled(isEnabled, enabledWhen).paramLabel("max-count").build();
    }
}

