/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.infinispan.jgroups.impl;

import java.util.List;
import java.util.Map;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.jgroups.conf.ProtocolConfiguration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.quarkus.runtime.storage.infinispan.CacheManagerFactory;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.JGroupsStackConfigurator;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.JGroupsUtil;

public class KubernetesPatchConfigurator
implements JGroupsStackConfigurator {
    public static final String KUBERNETES_STACK = "kubernetes";
    private static final String KUBERNETES_PATCHED_STACK = "kubernetes-patched";
    public static final KubernetesPatchConfigurator INSTANCE = new KubernetesPatchConfigurator();

    @Override
    public boolean requiresKeycloakSession() {
        return false;
    }

    @Override
    public void configure(ConfigurationBuilderHolder holder, KeycloakSession session) {
        CacheManagerFactory.logger.info((Object)"[PATCH] Patching kubernetes stack.");
        Map<String, String> attributes = Map.of("port_range", "0");
        List<ProtocolConfiguration> patch = List.of(new ProtocolConfiguration("TCP", attributes));
        holder.addJGroupsStack(new EmbeddedJGroupsChannelConfigurator(KUBERNETES_PATCHED_STACK, patch, null), KUBERNETES_STACK);
        JGroupsUtil.transportOf(holder).stack(KUBERNETES_PATCHED_STACK);
    }
}

