/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.RoleMappingsProvider;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.config.parsers.ResourceLoader;

public class PropertiesBasedRoleMapper
implements RoleMappingsProvider {
    private static final Logger logger = Logger.getLogger(PropertiesBasedRoleMapper.class);
    public static final String PROVIDER_ID = "properties-based-role-mapper";
    private static final String PROPERTIES_FILE_LOCATION = "properties.file.location";
    private static final String PROPERTIES_RESOURCE_LOCATION = "properties.resource.location";
    private static final String DEFAULT_RESOURCE_LOCATION = "/WEB-INF/role-mappings.properties";
    private Properties roleMappings;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(SamlDeployment deployment, ResourceLoader loader, Properties config) {
        this.roleMappings = new Properties();
        String path = config.getProperty(PROPERTIES_FILE_LOCATION);
        if (path != null) {
            File file = new File(path);
            if (!file.exists()) throw new RuntimeException("Unable to load role mappings from " + path + ": file does not exist in filesystem");
            try (FileInputStream is = new FileInputStream(file);){
                this.roleMappings.load(is);
                logger.debugf("Successfully loaded role mappings from %s", (Object)path);
                return;
            }
            catch (Exception e) {
                logger.debugv((Throwable)e, "Unable to load role mappings from %s", (Object)path);
            }
            return;
        }
        path = config.getProperty(PROPERTIES_RESOURCE_LOCATION, DEFAULT_RESOURCE_LOCATION);
        InputStream is = loader.getResourceAsStream(path);
        if (is == null) throw new RuntimeException("Unable to load role mappings from " + path + ": file does not exist in the resource");
        try {
            this.roleMappings.load(is);
            logger.debugf("Resource loader successfully loaded role mappings from %s", (Object)path);
            return;
        }
        catch (Exception e) {
            logger.debugv((Throwable)e, "Resource loader unable to load role mappings from %s", (Object)path);
        }
    }

    @Override
    public Set<String> map(String principalName, Set<String> roles) {
        if (this.roleMappings == null || this.roleMappings.isEmpty()) {
            return roles;
        }
        HashSet<String> resolvedRoles = new HashSet<String>();
        for (String role : roles) {
            if (this.roleMappings.containsKey(role)) {
                this.extractRolesIntoSet(role, resolvedRoles);
                continue;
            }
            resolvedRoles.add(role);
        }
        if (this.roleMappings.containsKey(principalName)) {
            this.extractRolesIntoSet(principalName, resolvedRoles);
        }
        return resolvedRoles;
    }

    private void extractRolesIntoSet(String entry, Set<String> roles) {
        String value = this.roleMappings.getProperty(entry);
        if (!value.isEmpty()) {
            String[] mappedRoles;
            for (String mappedRole : mappedRoles = value.split(",")) {
                String trimmedRole = mappedRole.trim();
                if (trimmedRole.isEmpty()) continue;
                roles.add(trimmedRole);
            }
        }
    }
}

