/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;

public interface ResourceStore {
    default public Resource create(String name, ResourceServer resourceServer, String owner) {
        return this.create(null, name, resourceServer, owner);
    }

    public Resource create(String var1, String var2, ResourceServer var3, String var4);

    public void delete(String var1);

    public Resource findById(String var1, String var2);

    default public List<Resource> findByOwner(String ownerId, String resourceServerId) {
        LinkedList<Resource> list = new LinkedList<Resource>();
        this.findByOwner(ownerId, resourceServerId, list::add);
        return list;
    }

    public void findByOwner(String var1, String var2, Consumer<Resource> var3);

    public List<Resource> findByOwner(String var1, String var2, int var3, int var4);

    public List<Resource> findByUri(String var1, String var2);

    public List<Resource> findByResourceServer(String var1);

    public List<Resource> findByResourceServer(Map<Resource.FilterOption, String[]> var1, String var2, int var3, int var4);

    default public List<Resource> findByScope(List<String> id, String resourceServerId) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        this.findByScope(id, resourceServerId, result::add);
        return result;
    }

    public void findByScope(List<String> var1, String var2, Consumer<Resource> var3);

    public Resource findByName(String var1, String var2);

    public Resource findByName(String var1, String var2, String var3);

    default public List<Resource> findByType(String type, String resourceServerId) {
        LinkedList<Resource> list = new LinkedList<Resource>();
        this.findByType(type, resourceServerId, list::add);
        return list;
    }

    default public List<Resource> findByType(String type, String owner, String resourceServerId) {
        LinkedList<Resource> list = new LinkedList<Resource>();
        this.findByType(type, owner, resourceServerId, list::add);
        return list;
    }

    public void findByType(String var1, String var2, Consumer<Resource> var3);

    public void findByType(String var1, String var2, String var3, Consumer<Resource> var4);

    default public List<Resource> findByTypeInstance(String type, String resourceServerId) {
        LinkedList<Resource> list = new LinkedList<Resource>();
        this.findByTypeInstance(type, resourceServerId, list::add);
        return list;
    }

    public void findByTypeInstance(String var1, String var2, Consumer<Resource> var3);
}

