/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.evaluation.DecisionPermissionCollector;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionTicketToken;

public class PermissionTicketAwareDecisionResultCollector
extends DecisionPermissionCollector {
    private final AuthorizationRequest request;
    private PermissionTicketToken ticket;
    private final Identity identity;
    private ResourceServer resourceServer;
    private final AuthorizationProvider authorization;

    public PermissionTicketAwareDecisionResultCollector(AuthorizationRequest request, PermissionTicketToken ticket, Identity identity, ResourceServer resourceServer, AuthorizationProvider authorization) {
        super(authorization, resourceServer, request);
        this.request = request;
        this.ticket = ticket;
        this.identity = identity;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
    }

    @Override
    protected void onGrant(Permission grantedPermission) {
        List permissions = this.ticket.getPermissions();
        Iterator itPermissions = permissions.iterator();
        while (itPermissions.hasNext()) {
            Permission permission = (Permission)itPermissions.next();
            if (permission.getResourceId() != null && !permission.getResourceId().equals(grantedPermission.getResourceId())) continue;
            Set scopes = permission.getScopes();
            Iterator itScopes = scopes.iterator();
            while (itScopes.hasNext()) {
                if (!grantedPermission.getScopes().contains(itScopes.next())) continue;
                itScopes.remove();
            }
            if (!scopes.isEmpty()) continue;
            itPermissions.remove();
        }
    }

    @Override
    public void onComplete() {
        super.onComplete();
        if (this.request.isSubmitRequest()) {
            StoreFactory storeFactory = this.authorization.getStoreFactory();
            ResourceStore resourceStore = storeFactory.getResourceStore();
            List permissions = this.ticket.getPermissions();
            if (permissions != null) {
                for (Permission permission : permissions) {
                    Resource resource = resourceStore.findById(permission.getResourceId(), this.resourceServer.getId());
                    if (resource == null) {
                        resource = resourceStore.findByName(permission.getResourceId(), this.identity.getId(), this.resourceServer.getId());
                    }
                    if (resource == null || !resource.isOwnerManagedAccess() || resource.getOwner().equals(this.identity.getId()) || resource.getOwner().equals(this.resourceServer.getId())) continue;
                    Set scopes = permission.getScopes();
                    if (scopes.isEmpty()) {
                        scopes = resource.getScopes().stream().map(Scope::getName).collect(Collectors.toSet());
                    }
                    if (scopes.isEmpty()) {
                        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
                        filters.put(PermissionTicket.FilterOption.RESOURCE_ID, resource.getId());
                        filters.put(PermissionTicket.FilterOption.REQUESTER, this.identity.getId());
                        filters.put(PermissionTicket.FilterOption.SCOPE_IS_NULL, Boolean.TRUE.toString());
                        List<PermissionTicket> tickets = this.authorization.getStoreFactory().getPermissionTicketStore().find(filters, resource.getResourceServer(), -1, -1);
                        if (!tickets.isEmpty()) continue;
                        this.authorization.getStoreFactory().getPermissionTicketStore().create(resource.getId(), null, this.identity.getId(), this.resourceServer);
                        continue;
                    }
                    ScopeStore scopeStore = this.authorization.getStoreFactory().getScopeStore();
                    for (String scopeId : scopes) {
                        Scope scope = scopeStore.findByName(scopeId, this.resourceServer.getId());
                        if (scope == null) {
                            scope = scopeStore.findById(scopeId, this.resourceServer.getId());
                        }
                        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
                        filters.put(PermissionTicket.FilterOption.RESOURCE_ID, resource.getId());
                        filters.put(PermissionTicket.FilterOption.REQUESTER, this.identity.getId());
                        filters.put(PermissionTicket.FilterOption.SCOPE_ID, scope.getId());
                        List<PermissionTicket> tickets = this.authorization.getStoreFactory().getPermissionTicketStore().find(filters, resource.getResourceServer(), -1, -1);
                        if (!tickets.isEmpty()) continue;
                        this.authorization.getStoreFactory().getPermissionTicketStore().create(resource.getId(), scope.getId(), this.identity.getId(), this.resourceServer);
                    }
                }
            }
        }
    }
}

