/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.Objects;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.RealmModel;

public class DefaultKeyProviders {
    public static void createProviders(RealmModel realm) {
        if (!DefaultKeyProviders.hasProvider(realm, "rsa-generated")) {
            DefaultKeyProviders.createRsaKeyProvider("rsa-generated", realm);
        }
        if (!DefaultKeyProviders.hasProvider(realm, "rsa-enc-generated")) {
            DefaultKeyProviders.createRsaEncKeyProvider("rsa-enc-generated", realm);
        }
        DefaultKeyProviders.createSecretProvider(realm);
        DefaultKeyProviders.createAesProvider(realm);
    }

    private static void createRsaKeyProvider(String name, RealmModel realm) {
        ComponentModel generated = new ComponentModel();
        generated.setName(name);
        generated.setParentId(realm.getId());
        generated.setProviderId("rsa-generated");
        generated.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"priority", (Object)"100");
        config.putSingle((Object)"keyUse", (Object)KeyUse.SIG.name());
        generated.setConfig(config);
        realm.addComponentModel(generated);
    }

    private static void createRsaEncKeyProvider(String name, RealmModel realm) {
        ComponentModel generated = new ComponentModel();
        generated.setName(name);
        generated.setParentId(realm.getId());
        generated.setProviderId("rsa-enc-generated");
        generated.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"priority", (Object)"100");
        config.putSingle((Object)"keyUse", (Object)KeyUse.ENC.name());
        config.putSingle((Object)"algorithm", (Object)"RSA-OAEP");
        generated.setConfig(config);
        realm.addComponentModel(generated);
    }

    public static void createSecretProvider(RealmModel realm) {
        if (DefaultKeyProviders.hasProvider(realm, "hmac-generated")) {
            return;
        }
        ComponentModel generated = new ComponentModel();
        generated.setName("hmac-generated");
        generated.setParentId(realm.getId());
        generated.setProviderId("hmac-generated");
        generated.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"priority", (Object)"100");
        config.putSingle((Object)"algorithm", (Object)"HS256");
        generated.setConfig(config);
        realm.addComponentModel(generated);
    }

    public static void createAesProvider(RealmModel realm) {
        if (DefaultKeyProviders.hasProvider(realm, "aes-generated")) {
            return;
        }
        ComponentModel generated = new ComponentModel();
        generated.setName("aes-generated");
        generated.setParentId(realm.getId());
        generated.setProviderId("aes-generated");
        generated.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"priority", (Object)"100");
        generated.setConfig(config);
        realm.addComponentModel(generated);
    }

    protected static boolean hasProvider(RealmModel realm, String providerId) {
        return realm.getComponentsStream(realm.getId(), KeyProvider.class.getName()).anyMatch(component -> Objects.equals(component.getProviderId(), providerId));
    }

    public static void createProviders(RealmModel realm, String privateKeyPem, String certificatePem) {
        if (!DefaultKeyProviders.hasProvider(realm, "rsa")) {
            ComponentModel rsa = new ComponentModel();
            rsa.setName("rsa");
            rsa.setParentId(realm.getId());
            rsa.setProviderId("rsa");
            rsa.setProviderType(KeyProvider.class.getName());
            MultivaluedHashMap config = new MultivaluedHashMap();
            config.putSingle((Object)"priority", (Object)"100");
            config.putSingle((Object)"privateKey", (Object)privateKeyPem);
            if (certificatePem != null) {
                config.putSingle((Object)"certificate", (Object)certificatePem);
            }
            rsa.setConfig(config);
            realm.addComponentModel(rsa);
        }
        DefaultKeyProviders.createSecretProvider(realm);
        DefaultKeyProviders.createAesProvider(realm);
    }
}

