/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.SearchableModelField;

public interface GroupModel
extends RoleMapperModel {
    public static final Comparator<GroupModel> COMPARE_BY_NAME = Comparator.comparing(GroupModel::getName);

    public String getId();

    public String getName();

    public void setName(String var1);

    public void setSingleAttribute(String var1, String var2);

    public void setAttribute(String var1, List<String> var2);

    public void removeAttribute(String var1);

    public String getFirstAttribute(String var1);

    @Deprecated
    public List<String> getAttribute(String var1);

    default public Stream<String> getAttributeStream(String name) {
        List<String> value = this.getAttribute(name);
        return value != null ? value.stream() : Stream.empty();
    }

    public Map<String, List<String>> getAttributes();

    public GroupModel getParent();

    public String getParentId();

    @Deprecated
    public Set<GroupModel> getSubGroups();

    default public Stream<GroupModel> getSubGroupsStream() {
        Set<GroupModel> value = this.getSubGroups();
        return value != null ? value.stream() : Stream.empty();
    }

    public void setParent(GroupModel var1);

    public void addChild(GroupModel var1);

    public void removeChild(GroupModel var1);

    public static interface Streams
    extends GroupModel,
    RoleMapperModel.Streams {
        @Override
        default public List<String> getAttribute(String name) {
            return this.getAttributeStream(name).collect(Collectors.toList());
        }

        @Override
        public Stream<String> getAttributeStream(String var1);

        @Override
        default public Set<GroupModel> getSubGroups() {
            return this.getSubGroupsStream().collect(Collectors.toSet());
        }

        @Override
        public Stream<GroupModel> getSubGroupsStream();
    }

    public static interface GroupRemovedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public GroupModel getGroup();

        public KeycloakSession getKeycloakSession();
    }

    public static class SearchableFields {
        public static final SearchableModelField<GroupModel> ID = new SearchableModelField("id", String.class);
        public static final SearchableModelField<GroupModel> REALM_ID = new SearchableModelField("realmId", String.class);
        public static final SearchableModelField<GroupModel> PARENT_ID = new SearchableModelField("parentGroupId", String.class);
        public static final SearchableModelField<GroupModel> NAME = new SearchableModelField("name", String.class);
        public static final SearchableModelField<GroupModel> ASSIGNED_ROLE = new SearchableModelField("assignedRole", String.class);
    }
}

