/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.provider.Provider;

public interface UserSessionProvider
extends Provider {
    public KeycloakSession getKeycloakSession();

    public AuthenticatedClientSessionModel createClientSession(RealmModel var1, ClientModel var2, UserSessionModel var3);

    default public AuthenticatedClientSessionModel getClientSession(UserSessionModel userSession, ClientModel client, UUID clientSessionId, boolean offline) {
        return this.getClientSession(userSession, client, clientSessionId == null ? null : clientSessionId.toString(), offline);
    }

    public AuthenticatedClientSessionModel getClientSession(UserSessionModel var1, ClientModel var2, String var3, boolean var4);

    public UserSessionModel createUserSession(RealmModel var1, UserModel var2, String var3, String var4, String var5, boolean var6, String var7, String var8);

    public UserSessionModel createUserSession(String var1, RealmModel var2, UserModel var3, String var4, String var5, String var6, boolean var7, String var8, String var9, UserSessionModel.SessionPersistenceState var10);

    public UserSessionModel getUserSession(RealmModel var1, String var2);

    @Deprecated
    default public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        return this.getUserSessionsStream(realm, user).collect(Collectors.toList());
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel var1, UserModel var2);

    @Deprecated
    default public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessionsStream(realm, client).collect(Collectors.toList());
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel var1, ClientModel var2);

    @Deprecated
    default public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        return this.getUserSessionsStream(realm, client, firstResult, maxResults).collect(Collectors.toList());
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel var1, ClientModel var2, Integer var3, Integer var4);

    @Deprecated
    default public List<UserSessionModel> getUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        return this.getUserSessionByBrokerUserIdStream(realm, brokerUserId).collect(Collectors.toList());
    }

    public Stream<UserSessionModel> getUserSessionByBrokerUserIdStream(RealmModel var1, String var2);

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel var1, String var2);

    public UserSessionModel getUserSessionWithPredicate(RealmModel var1, String var2, boolean var3, Predicate<UserSessionModel> var4);

    public long getActiveUserSessions(RealmModel var1, ClientModel var2);

    public Map<String, Long> getActiveClientSessionStats(RealmModel var1, boolean var2);

    public void removeUserSession(RealmModel var1, UserSessionModel var2);

    public void removeUserSessions(RealmModel var1, UserModel var2);

    public void removeAllExpired();

    public void removeExpired(RealmModel var1);

    public void removeUserSessions(RealmModel var1);

    @Deprecated
    default public UserLoginFailureModel getUserLoginFailure(RealmModel realm, String userId) {
        return this.getKeycloakSession().loginFailures().getUserLoginFailure(realm, userId);
    }

    @Deprecated
    default public UserLoginFailureModel addUserLoginFailure(RealmModel realm, String userId) {
        return this.getKeycloakSession().loginFailures().addUserLoginFailure(realm, userId);
    }

    @Deprecated
    default public void removeUserLoginFailure(RealmModel realm, String userId) {
        this.getKeycloakSession().loginFailures().removeUserLoginFailure(realm, userId);
    }

    @Deprecated
    default public void removeAllUserLoginFailures(RealmModel realm) {
        this.getKeycloakSession().loginFailures().removeAllUserLoginFailures(realm);
    }

    public void onRealmRemoved(RealmModel var1);

    public void onClientRemoved(RealmModel var1, ClientModel var2);

    public UserSessionModel createOfflineUserSession(UserSessionModel var1);

    public UserSessionModel getOfflineUserSession(RealmModel var1, String var2);

    public void removeOfflineUserSession(RealmModel var1, UserSessionModel var2);

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel var1, UserSessionModel var2);

    @Deprecated
    default public List<UserSessionModel> getOfflineUserSessions(RealmModel realm, UserModel user) {
        return this.getOfflineUserSessionsStream(realm, user).collect(Collectors.toList());
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel var1, UserModel var2);

    public UserSessionModel getOfflineUserSessionByBrokerSessionId(RealmModel var1, String var2);

    @Deprecated
    default public List<UserSessionModel> getOfflineUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        return this.getOfflineUserSessionByBrokerUserIdStream(realm, brokerUserId).collect(Collectors.toList());
    }

    public Stream<UserSessionModel> getOfflineUserSessionByBrokerUserIdStream(RealmModel var1, String var2);

    public long getOfflineSessionsCount(RealmModel var1, ClientModel var2);

    @Deprecated
    default public List<UserSessionModel> getOfflineUserSessions(RealmModel realm, ClientModel client, int first, int max) {
        return this.getOfflineUserSessionsStream(realm, client, first, max).collect(Collectors.toList());
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel var1, ClientModel var2, Integer var3, Integer var4);

    public void importUserSessions(Collection<UserSessionModel> var1, boolean var2);

    @Override
    public void close();

    public int getStartupTime(RealmModel var1);
}

