/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.Set;
import java.util.function.Predicate;
import org.keycloak.utils.StringUtil;

public enum UserProfileContext {
    UPDATE_PROFILE(false, true, true),
    USER_API(true, false, false),
    ACCOUNT(false, false, true),
    IDP_REVIEW(false, true, false),
    REGISTRATION(false, true, false),
    UPDATE_EMAIL(false, true, false, Set.of("email")::contains);

    private final boolean resetEmailVerified;
    private final Predicate<String> attributeSelector;
    private final boolean adminContext;
    private final boolean authFlowContext;

    private UserProfileContext(boolean adminContext, boolean authFlowContext, boolean resetEmailVerified, Predicate<String> attributeSelector) {
        this.adminContext = adminContext;
        this.authFlowContext = authFlowContext;
        this.resetEmailVerified = resetEmailVerified;
        this.attributeSelector = attributeSelector;
    }

    private UserProfileContext(boolean adminContext, boolean authFlowContext, boolean resetEmailVerified) {
        this(adminContext, authFlowContext, resetEmailVerified, StringUtil::isNotBlank);
    }

    public boolean isAdminContext() {
        return this.adminContext;
    }

    public boolean canBeAuthFlowContext() {
        return this.authFlowContext;
    }

    public boolean isResetEmailVerified() {
        return this.resetEmailVerified;
    }

    public boolean isRoleForContext(Set<String> roles) {
        if (roles == null) {
            return false;
        }
        return roles.contains(this.getContextRole());
    }

    private String getContextRole() {
        return this.isAdminContext() ? "admin" : "user";
    }

    public boolean isAttributeSupported(String name) {
        return this.attributeSelector.test(name);
    }
}

