/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.security.PublicKey;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.jose.jws.JWSInput;
import org.jboss.resteasy.jose.jws.crypto.RSAProvider;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.services.email.EmailSender;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.FormFlows;
import org.keycloak.services.validation.Validation;

public class RequiredActionsService {
    protected static final Logger logger = Logger.getLogger(RequiredActionsService.class);
    private RealmModel realm;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    protected Providers providers;
    protected AuthenticationManager authManager = new AuthenticationManager();
    private TokenManager tokenManager;

    public RequiredActionsService(RealmModel realm, TokenManager tokenManager) {
        this.realm = realm;
        this.tokenManager = tokenManager;
    }

    @Path(value="profile")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateProfile(MultivaluedMap<String, String> formData) {
        AccessCodeEntry accessCode = this.getAccessCodeEntry(UserModel.RequiredAction.UPDATE_PROFILE);
        if (accessCode == null) {
            return this.forwardToErrorPage();
        }
        UserModel user = this.getUser(accessCode);
        String error = Validation.validateUpdateProfileForm(formData);
        if (error != null) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setError(error).forwardToAction(UserModel.RequiredAction.UPDATE_PROFILE);
        }
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        user.setEmail((String)formData.getFirst((Object)"email"));
        user.removeRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
        accessCode.getRequiredActions().remove(UserModel.RequiredAction.UPDATE_PROFILE);
        return this.redirectOauth(user, accessCode);
    }

    @Path(value="totp")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateTotp(MultivaluedMap<String, String> formData) {
        AccessCodeEntry accessCode = this.getAccessCodeEntry(UserModel.RequiredAction.CONFIGURE_TOTP);
        if (accessCode == null) {
            return this.forwardToErrorPage();
        }
        UserModel user = this.getUser(accessCode);
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        FormFlows forms = Flows.forms(this.realm, this.request, this.uriInfo).setUser(user);
        if (Validation.isEmpty(totp)) {
            return forms.setError("missingTotp").forwardToAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        }
        if (!new TimeBasedOTP().validate(totp, totpSecret.getBytes())) {
            return forms.setError("invalidTotp").forwardToAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("totp");
        credentials.setValue(totpSecret);
        this.realm.updateCredential(user, credentials);
        user.setTotp(true);
        user.removeRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        accessCode.getRequiredActions().remove(UserModel.RequiredAction.CONFIGURE_TOTP);
        return this.redirectOauth(user, accessCode);
    }

    @Path(value="password")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updatePassword(MultivaluedMap<String, String> formData) {
        logger.debug("updatePassword");
        AccessCodeEntry accessCode = this.getAccessCodeEntry(UserModel.RequiredAction.UPDATE_PASSWORD);
        if (accessCode == null) {
            logger.debug("updatePassword access code is null");
            return this.forwardToErrorPage();
        }
        logger.debug("updatePassword has access code");
        UserModel user = this.getUser(accessCode);
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        FormFlows forms = Flows.forms(this.realm, this.request, this.uriInfo).setUser(user);
        if (Validation.isEmpty(passwordNew)) {
            return forms.setError("missingPassword").forwardToAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        if (!passwordNew.equals(passwordConfirm)) {
            return forms.setError("notMatchPassword").forwardToAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("password");
        credentials.setValue(passwordNew);
        this.realm.updateCredential(user, credentials);
        logger.debug("updatePassword updated credential");
        user.removeRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        if (accessCode != null) {
            accessCode.getRequiredActions().remove(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        if (accessCode != null) {
            return this.redirectOauth(user, accessCode);
        }
        return Flows.forms(this.realm, this.request, this.uriInfo).setUser(user).forwardToPassword();
    }

    @Path(value="email-verification")
    @GET
    public Response emailVerification() {
        if (this.uriInfo.getQueryParameters().containsKey((Object)"key")) {
            AccessCodeEntry accessCode = this.tokenManager.getAccessCode((String)this.uriInfo.getQueryParameters().getFirst((Object)"key"));
            if (accessCode == null || accessCode.isExpired() || !accessCode.getRequiredActions().contains(UserModel.RequiredAction.VERIFY_EMAIL)) {
                return this.forwardToErrorPage();
            }
            UserModel user = this.getUser(accessCode);
            user.setEmailVerified(true);
            user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            accessCode.getRequiredActions().remove(UserModel.RequiredAction.VERIFY_EMAIL);
            return this.redirectOauth(user, accessCode);
        }
        AccessCodeEntry accessCode = this.getAccessCodeEntry(UserModel.RequiredAction.VERIFY_EMAIL);
        if (accessCode == null) {
            return this.forwardToErrorPage();
        }
        return Flows.forms(this.realm, this.request, this.uriInfo).setAccessCode(accessCode).setUser(accessCode.getUser()).forwardToAction(UserModel.RequiredAction.VERIFY_EMAIL);
    }

    @Path(value="password-reset")
    @GET
    public Response passwordReset() {
        if (this.uriInfo.getQueryParameters().containsKey((Object)"key")) {
            AccessCodeEntry accessCode = this.tokenManager.getAccessCode((String)this.uriInfo.getQueryParameters().getFirst((Object)"key"));
            if (accessCode == null || accessCode.isExpired() || !accessCode.getRequiredActions().contains(UserModel.RequiredAction.UPDATE_PASSWORD)) {
                return this.forwardToErrorPage();
            }
            return Flows.forms(this.realm, this.request, this.uriInfo).setAccessCode(accessCode).forwardToAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        }
        return Flows.forms(this.realm, this.request, this.uriInfo).forwardToPasswordReset();
    }

    @Path(value="password-reset")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response sendPasswordReset(MultivaluedMap<String, String> formData) {
        String username = (String)formData.getFirst((Object)"username");
        String email = (String)formData.getFirst((Object)"email");
        String scopeParam = (String)this.uriInfo.getQueryParameters().getFirst((Object)"scope");
        String state = (String)this.uriInfo.getQueryParameters().getFirst((Object)"state");
        String redirect = (String)this.uriInfo.getQueryParameters().getFirst((Object)"redirect_uri");
        String clientId = (String)this.uriInfo.getQueryParameters().getFirst((Object)"client_id");
        UserModel client = this.realm.getUser(clientId);
        if (client == null) {
            return Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager).forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            return Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager).forwardToSecurityFailure("Login requester not enabled.");
        }
        UserModel user = this.realm.getUser(username);
        if (user == null || !email.equals(user.getEmail())) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setError("emailError").forwardToPasswordReset();
        }
        HashSet<UserModel.RequiredAction> requiredActions = new HashSet<UserModel.RequiredAction>(user.getRequiredActions());
        requiredActions.add(UserModel.RequiredAction.UPDATE_PASSWORD);
        AccessCodeEntry accessCode = this.tokenManager.createAccessCode(scopeParam, state, redirect, this.realm, client, user);
        accessCode.setRequiredActions(requiredActions);
        accessCode.setExpiration(System.currentTimeMillis() / 1000L + (long)this.realm.getAccessCodeLifespanUserAction());
        new EmailSender(this.realm.getSmtpConfig()).sendPasswordReset(user, this.realm, accessCode, this.uriInfo);
        return Flows.forms(this.realm, this.request, this.uriInfo).setError("emailSent").setErrorType(FormFlows.MessageType.SUCCESS).forwardToPasswordReset();
    }

    private AccessCodeEntry getAccessCodeEntry(UserModel.RequiredAction requiredAction) {
        String code = (String)this.uriInfo.getQueryParameters().getFirst((Object)"code");
        if (code == null) {
            logger.debug("getAccessCodeEntry code as not in query param");
            return null;
        }
        JWSInput input = new JWSInput(code, this.providers);
        boolean verifiedCode = false;
        try {
            verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)this.realm.getPublicKey());
        }
        catch (Exception ignored) {
            logger.debug("getAccessCodeEntry code failed verification");
            return null;
        }
        if (!verifiedCode) {
            logger.debug("getAccessCodeEntry code failed verification2");
            return null;
        }
        String key = (String)input.readContent(String.class);
        AccessCodeEntry accessCodeEntry = this.tokenManager.getAccessCode(key);
        if (accessCodeEntry == null) {
            logger.debug("getAccessCodeEntry access code entry null");
            return null;
        }
        if (accessCodeEntry.isExpired()) {
            logger.debug("getAccessCodeEntry: access code id: {0}", new Object[]{accessCodeEntry.getId()});
            logger.debug("getAccessCodeEntry access code entry expired: {0}", new Object[]{accessCodeEntry.getExpiration()});
            logger.debug("getAccessCodeEntry current time: {0}", new Object[]{System.currentTimeMillis() / 1000L});
            return null;
        }
        if (accessCodeEntry.getRequiredActions() == null || !accessCodeEntry.getRequiredActions().contains(requiredAction)) {
            logger.debug("getAccessCodeEntry required actions null || entry does not contain required action: {0}|{1}", new Object[]{accessCodeEntry.getRequiredActions() == null, !accessCodeEntry.getRequiredActions().contains(requiredAction)});
            return null;
        }
        return accessCodeEntry;
    }

    private UserModel getUser(AccessCodeEntry accessCode) {
        return this.realm.getUser(accessCode.getUser().getLoginName());
    }

    private Response redirectOauth(UserModel user, AccessCodeEntry accessCode) {
        if (accessCode == null) {
            return null;
        }
        Set requiredActions = user.getRequiredActions();
        if (!requiredActions.isEmpty()) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setAccessCode(accessCode).setUser(user).forwardToAction((UserModel.RequiredAction)requiredActions.iterator().next());
        }
        logger.debug("redirectOauth: redirecting to: {0}", new Object[]{accessCode.getRedirectUri()});
        accessCode.setExpiration(System.currentTimeMillis() / 1000L + (long)this.realm.getAccessCodeLifespan());
        return Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager).redirectAccessCode(accessCode, accessCode.getState(), accessCode.getRedirectUri());
    }

    private Response forwardToErrorPage() {
        return Flows.forms(this.realm, this.request, this.uriInfo).forwardToErrorPage();
    }
}

