/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.flows;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.FormService;
import org.keycloak.services.email.EmailSender;
import org.keycloak.services.managers.AccessCodeEntry;

public class FormFlows {
    public static final String CODE = "code";
    private String error;
    private MessageType messageType = MessageType.ERROR;
    private MultivaluedMap<String, String> formData;
    private Map<String, String> queryParams;
    private RealmModel realm;
    private HttpRequest request;
    private UserModel userModel;
    private boolean socialRegistration;
    private AccessCodeEntry accessCode;
    private UriInfo uriInfo;

    FormFlows(RealmModel realm, HttpRequest request, UriInfo uriInfo) {
        this.realm = realm;
        this.request = request;
        this.uriInfo = uriInfo;
    }

    public Response forwardToAction(UserModel.RequiredAction action) {
        switch (action) {
            case CONFIGURE_TOTP: {
                return this.forwardToActionForm("login-config-totp.ftl", "actionTotpWarning");
            }
            case UPDATE_PROFILE: {
                return this.forwardToActionForm("login-update-profile.ftl", "actionProfileWarning");
            }
            case UPDATE_PASSWORD: {
                return this.forwardToActionForm("login-update-password.ftl", "actionPasswordWarning");
            }
            case VERIFY_EMAIL: {
                new EmailSender(this.realm.getSmtpConfig()).sendEmailVerification(this.userModel, this.realm, this.accessCode, this.uriInfo);
                return this.forwardToActionForm("login-verify-email.ftl", "actionEmailWarning");
            }
        }
        return Response.serverError().build();
    }

    public Response forwardToAccess() {
        return this.forwardToForm("access.ftl");
    }

    public Response forwardToAccount() {
        return this.forwardToForm("account.ftl");
    }

    private Response forwardToForm(String template, FormService.FormServiceDataBean formDataBean) {
        ResteasyUriInfo uriInfo = this.request.getUri();
        MultivaluedMap queryParameterMap = uriInfo.getQueryParameters();
        String requestURI = uriInfo.getBaseUri().getPath();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)requestURI);
        for (String string : queryParameterMap.keySet()) {
            uriBuilder.replaceQueryParam(string, ((List)queryParameterMap.get((Object)string)).toArray());
        }
        if (this.accessCode != null) {
            uriBuilder.queryParam(CODE, new Object[]{this.accessCode.getCode()});
        }
        if (this.queryParams != null) {
            for (Map.Entry entry : this.queryParams.entrySet()) {
                uriBuilder.replaceQueryParam((String)entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        URI baseURI = uriBuilder.build(new Object[0]);
        formDataBean.setBaseURI(baseURI);
        formDataBean.setContextPath(requestURI.substring(0, requestURI.length() - 6));
        formDataBean.setSocialRegistration(this.socialRegistration);
        Iterator<FormService> iterator = ServiceRegistry.lookupProviders(FormService.class);
        while (iterator.hasNext()) {
            FormService provider = iterator.next();
            if (!provider.getId().equals("FormServiceId")) continue;
            return Response.status((int)200).type("text/html").entity((Object)provider.process(template, formDataBean)).build();
        }
        return Response.status((int)200).entity((Object)"form provider not found").build();
    }

    public Response forwardToForm(String template) {
        FormService.FormServiceDataBean formDataBean = new FormService.FormServiceDataBean(this.realm, this.userModel, this.formData, this.queryParams, this.error);
        formDataBean.setMessageType(this.messageType);
        return this.forwardToForm(template, formDataBean);
    }

    private Response forwardToActionForm(String template, String warningSummary) {
        if (this.error == null) {
            this.messageType = MessageType.WARNING;
            this.error = warningSummary;
        }
        return this.forwardToForm(template);
    }

    public Response forwardToLogin() {
        return this.forwardToForm("login.ftl");
    }

    public Response forwardToPasswordReset() {
        return this.forwardToForm("login-reset-password.ftl");
    }

    public Response forwardToLoginTotp() {
        return this.forwardToForm("login-totp.ftl");
    }

    public Response forwardToPassword() {
        return this.forwardToForm("password.ftl");
    }

    public Response forwardToRegistration() {
        return this.forwardToForm("register.ftl");
    }

    public Response forwardToSocial() {
        return this.forwardToForm("social.ftl");
    }

    public Response forwardToTotp() {
        return this.forwardToForm("totp.ftl");
    }

    public Response forwardToErrorPage() {
        return this.forwardToForm("error.ftl");
    }

    public Response forwardToOAuthGrant() {
        FormService.FormServiceDataBean formDataBean = new FormService.FormServiceDataBean(this.realm, this.userModel, this.formData, this.queryParams, this.error);
        formDataBean.setOAuthRealmRolesRequested((List)this.request.getAttribute("realmRolesRequested"));
        formDataBean.setOAuthResourceRolesRequested((MultivaluedMap<String, RoleModel>)((MultivaluedMap)this.request.getAttribute("resourceRolesRequested")));
        formDataBean.setOAuthClient((UserModel)this.request.getAttribute("client"));
        formDataBean.setOAuthCode((String)this.request.getAttribute(CODE));
        formDataBean.setOAuthAction((String)this.request.getAttribute("action"));
        return this.forwardToForm("login-oauth-grant.ftl", formDataBean);
    }

    public FormFlows setAccessCode(AccessCodeEntry accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    public FormFlows setQueryParam(String key, String value) {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, String>();
        }
        this.queryParams.put(key, value);
        return this;
    }

    public FormFlows setError(String error) {
        this.error = error;
        return this;
    }

    public FormFlows setErrorType(MessageType errorType) {
        this.messageType = errorType;
        return this;
    }

    public FormFlows setUser(UserModel userModel) {
        this.userModel = userModel;
        return this;
    }

    public FormFlows setSocialRegistration(boolean socialRegistration) {
        this.socialRegistration = socialRegistration;
        return this;
    }

    public FormFlows setFormData(MultivaluedMap<String, String> formData) {
        this.formData = formData;
        return this;
    }

    public static enum MessageType {
        SUCCESS,
        WARNING,
        ERROR;

    }
}

